/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther.filechooser;

import ch.randelshofer.quaqua.BrowserPreviewRenderer;
import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.filechooser.AliasFileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.util.ResourceBundleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;

public class FilePreview
extends JPanel
implements BrowserPreviewRenderer {
    private ResourceBundleUtil labels = (ResourceBundleUtil)UIManager.get("Labels");
    private JFileChooser fileChooser;
    private JLabel kindLabel;
    private JTextArea kindText;
    private JLabel modifiedLabel;
    private JTextArea modifiedText;
    private JLabel nameLabel;
    private JTextArea nameText;
    private JPanel northPanel;
    private JLabel originalLabel;
    private JTextArea originalText;
    private JLabel sizeLabel;
    private JTextArea sizeText;
    private JLabel whereLabel;
    private JTextArea whereText;

    public FilePreview(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.initComponents();
        Color bg = UIManager.getColor("List.background");
        Color fgl = UIManager.getColor("FileChooser.previewLabelForeground");
        Color fgv = UIManager.getColor("FileChooser.previewValueForeground");
        Font fl = UIManager.getFont("FileChooser.previewLabelFont");
        Font fv = UIManager.getFont("FileChooser.previewValueFont");
        Insets labelInsets = UIManager.getInsets("FileChooser.previewLabelInsets");
        GridBagLayout layout = (GridBagLayout)this.northPanel.getLayout();
        int n = this.northPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent c = (JComponent)this.northPanel.getComponent(i);
            if (c instanceof JLabel) {
                c.setFont(fl);
                c.setForeground(fgl);
                if (labelInsets != null) {
                    GridBagConstraints gbc = layout.getConstraints(c);
                    gbc.insets = labelInsets;
                    layout.setConstraints(c, gbc);
                }
            } else {
                c.setFont(fv);
                c.setForeground(fgv);
            }
            c.setBackground(bg);
        }
        this.whereLabel.setVisible(false);
        this.whereText.setVisible(false);
        Insets borderMargin = new Insets(0, 0, 0, 0);
        this.kindLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.modifiedLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.nameLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.originalLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.sizeLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.whereLabel.putClientProperty("Quaqua.Component.visualMargin", borderMargin);
        this.setBackground(bg);
        this.northPanel.setBackground(bg);
        this.setOpaque(true);
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextArea();
        this.kindLabel = new JLabel();
        this.kindText = new JTextArea();
        this.sizeLabel = new JLabel();
        this.sizeText = new JTextArea();
        this.modifiedLabel = new JLabel();
        this.modifiedText = new JTextArea();
        this.whereLabel = new JLabel();
        this.whereText = new JTextArea();
        this.originalLabel = new JLabel();
        this.originalText = new JTextArea();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(3, 4, 4, 4)));
        this.northPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(this.labels.getString("FileChooser.name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameText.setEditable(false);
        this.nameText.setLineWrap(true);
        this.nameText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.nameText, gridBagConstraints);
        this.kindLabel.setText(this.labels.getString("FileChooser.kind"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.kindLabel, gridBagConstraints);
        this.kindText.setEditable(false);
        this.kindText.setLineWrap(true);
        this.kindText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.kindText, gridBagConstraints);
        this.sizeLabel.setText(this.labels.getString("FileChooser.size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeText.setEditable(false);
        this.sizeText.setLineWrap(true);
        this.sizeText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.sizeText, gridBagConstraints);
        this.modifiedLabel.setText(this.labels.getString("FileChooser.modified"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.modifiedLabel, gridBagConstraints);
        this.modifiedText.setEditable(false);
        this.modifiedText.setLineWrap(true);
        this.modifiedText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.modifiedText, gridBagConstraints);
        this.whereLabel.setText(this.labels.getString("FileChooser.whereLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.whereLabel, gridBagConstraints);
        this.whereText.setEditable(false);
        this.whereText.setLineWrap(true);
        this.whereText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.whereText, gridBagConstraints);
        this.originalLabel.setText(this.labels.getString("FileChooser.original"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        this.northPanel.add((Component)this.originalLabel, gridBagConstraints);
        this.originalText.setEditable(false);
        this.originalText.setLineWrap(true);
        this.originalText.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.originalText, gridBagConstraints);
        this.add((Component)this.northPanel, "North");
    }

    private String toOSXPath(File file) {
        StringBuffer buf = new StringBuffer();
        QuaquaFileSystemView fsv = QuaquaFileSystemView.getQuaquaFileSystemView();
        if (file != null && file.isDirectory()) {
            buf.append(':');
        }
        while (file != null) {
            buf.insert(0, this.fileChooser.getName(file));
            if ((file = ((FileSystemView)fsv).getParentDirectory(file)) == null) continue;
            buf.insert(0, ':');
        }
        return buf.toString();
    }

    public Component getPreviewRendererComponent(JBrowser browser, TreePath[] paths) {
        float scaledLength;
        String label;
        Locale locale = Locale.getDefault();
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(1);
        FileInfo info = (FileInfo)paths[0].getLastPathComponent();
        long fileLength = 0L;
        if (paths.length == 1) {
            this.nameLabel.setVisible(true);
            this.modifiedLabel.setVisible(true);
            this.modifiedText.setVisible(true);
            this.nameText.setText(info.getUserName());
            File file = info.getFile();
            fileLength = info.getFileLength();
            this.modifiedText.setText(DateFormat.getInstance().format(new Date(file.lastModified())));
            String kind = info.getFileKind();
            this.kindText.setText(this.labels.getString("FileChooser." + kind));
            if (kind == "alias") {
                this.originalText.setText(this.toOSXPath(info.getFile()));
                this.originalLabel.setVisible(true);
                this.originalText.setVisible(true);
            } else {
                this.originalLabel.setVisible(false);
                this.originalText.setVisible(false);
            }
        } else {
            this.nameLabel.setVisible(false);
            this.modifiedLabel.setVisible(false);
            this.modifiedText.setVisible(false);
            this.nameText.setText(this.labels.getFormatted("FileChooser.items", nf.format(paths.length)));
            TreeMap<String, Integer> kinds = new TreeMap<String, Integer>();
            for (int i = 0; i < paths.length; ++i) {
                Integer kindCount;
                String kind;
                info = (AliasFileSystemTreeModel.Node)paths[i].getLastPathComponent();
                if (fileLength != -1L) {
                    fileLength = info.getFileLength() == -1L ? -1L : (fileLength += info.getFileLength());
                }
                kinds.put(kind, (kindCount = (Integer)kinds.get(kind = info.getFileKind())) == null ? new Integer(1) : new Integer(kindCount + 1));
            }
            StringBuffer buf = new StringBuffer();
            Iterator i = kinds.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                buf.append(this.labels.getFormatted("FileChooser." + entry.getKey() + "Count", entry.getValue()));
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            this.kindText.setText(buf.toString());
            this.originalLabel.setVisible(false);
            this.originalText.setVisible(false);
        }
        if (fileLength == -1L) {
            label = "FileChooser.sizeUnknown";
            scaledLength = 0.0f;
        } else if (fileLength >= 0x40000000L) {
            label = "FileChooser.sizeGBytes";
            scaledLength = (float)fileLength / 1.0737418E9f;
        } else if (fileLength >= 0x100000L) {
            label = "FileChooser.sizeMBytes";
            scaledLength = (float)fileLength / 1048576.0f;
        } else if (fileLength >= 1024L) {
            label = "FileChooser.sizeKBytes";
            scaledLength = (float)fileLength / 1024.0f;
        } else {
            label = "FileChooser.sizeBytes";
            scaledLength = fileLength;
        }
        this.sizeText.setText(this.labels.getFormatted(label, new Object[]{new Float(scaledLength), new Long(fileLength), new Integer(paths.length)}));
        return this;
    }
}

