/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.analytics.process;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.umeng.analytics.AnalyticsConfig;
import com.umeng.analytics.c;
import com.umeng.analytics.pro.k;
import com.umeng.analytics.pro.n;
import com.umeng.analytics.process.DBFileTraversalUtil;
import com.umeng.analytics.process.UMProcessDBHelper;
import com.umeng.analytics.process.b;
import com.umeng.commonsdk.debug.UMRTLog;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.framework.UMLogDataProtocol;
import com.umeng.commonsdk.service.UMGlobalContext;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.internal.PreferenceWrapper;
import com.umeng.commonsdk.statistics.noise.ABTest;
import com.umeng.commonsdk.utils.FileLockCallback;
import com.umeng.commonsdk.utils.FileLockUtil;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class UMProcessDBDatasSender
implements UMLogDataProtocol {
    public static final int UM_PROCESS_EVENT_KEY = 36945;
    public static final int UM_PROCESS_CONSTRUCTMESSAGE = 36946;
    private FileLockUtil mLockUtil = new FileLockUtil();
    private Context mContext;
    private k.c mPolicySelector;
    private static UMProcessDBDatasSender mInstance;
    private static ScheduledThreadPoolExecutor executor;
    private List<Integer> mGeneralBodyIds;

    private UMProcessDBDatasSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static UMProcessDBDatasSender getInstance(Context context) {
        if (mInstance == null) {
            Class<UMProcessDBDatasSender> clazz = UMProcessDBDatasSender.class;
            // MONITORENTER : com.umeng.analytics.process.UMProcessDBDatasSender.class
            if (mInstance == null) {
                mInstance = new UMProcessDBDatasSender();
            }
            // MONITOREXIT : clazz
        }
        UMProcessDBDatasSender.mInstance.mContext = context;
        return mInstance;
    }

    public void workEvent(Object object, int n2) {
        if (!UMGlobalContext.getInstance().isMainProcess(this.mContext)) {
            return;
        }
        switch (n2) {
            case 36945: {
                executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        UMRTLog.i((String)"MobclickRT", (String)"--->>> call processDBToMain start.");
                        UMProcessDBHelper.getInstance(UMProcessDBDatasSender.this.mContext).processDBToMain();
                    }
                }, 5L, TimeUnit.SECONDS);
                break;
            }
            case 36946: {
                UMRTLog.i((String)"MobclickRT", (String)"--->>> recv UM_PROCESS_CONSTRUCTMESSAGE msg.");
                this.constructMessage();
                break;
            }
        }
    }

    public void removeCacheData(Object object) {
        JSONObject jSONObject;
        if (object == null || this.mGeneralBodyIds == null || this.mGeneralBodyIds.size() == 0) {
            return;
        }
        JSONObject jSONObject2 = (JSONObject)object;
        if (jSONObject2.has("analytics") && (jSONObject = jSONObject2.optJSONObject("analytics")) != null && jSONObject.length() > 0 && jSONObject.has("ekv")) {
            UMProcessDBHelper.getInstance(this.mContext).deleteMainProcessEventDatasByIds(this.mGeneralBodyIds);
            this.mGeneralBodyIds.clear();
        }
    }

    public JSONObject setupReportData(long l2) {
        int n2 = n.a().a(this.mContext);
        JSONObject jSONObject = this.generalBody();
        if (jSONObject.length() <= 0) {
            return null;
        }
        JSONObject jSONObject2 = this.generalHeader();
        JSONObject jSONObject3 = new JSONObject();
        try {
            JSONObject jSONObject4 = new JSONObject();
            if (n2 == 3) {
                jSONObject4.put("analytics", (Object)new JSONObject());
            } else if (jSONObject != null && jSONObject.length() > 0) {
                jSONObject4.put("analytics", (Object)jSONObject);
            }
            if (jSONObject2 != null && jSONObject2.length() > 0) {
                jSONObject3.put("header", (Object)jSONObject2);
            }
            if (jSONObject4.length() > 0) {
                if (jSONObject4.has("analytics")) {
                    JSONObject jSONObject5 = jSONObject4.optJSONObject("analytics");
                    if (jSONObject5.length() == 1) {
                        if (jSONObject5.optJSONObject("active_user") != null) {
                            return null;
                        }
                        if (!TextUtils.isEmpty((CharSequence)jSONObject5.optString("userlevel"))) {
                            return null;
                        }
                    }
                    if (jSONObject5.length() == 2 && jSONObject5.optJSONObject("active_user") != null && !TextUtils.isEmpty((CharSequence)jSONObject5.optString("userlevel"))) {
                        return null;
                    }
                }
                jSONObject3.put("content", (Object)jSONObject4);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jSONObject3;
    }

    private JSONObject generalHeader() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (AnalyticsConfig.mWrapperType != null && AnalyticsConfig.mWrapperVersion != null) {
                jSONObject.put("wrapper_version", (Object)AnalyticsConfig.mWrapperVersion);
                jSONObject.put("wrapper_type", (Object)AnalyticsConfig.mWrapperType);
            }
            int n2 = AnalyticsConfig.getVerticalType(this.mContext);
            jSONObject.put("vertical_type", n2);
            jSONObject.put("sdk_version", (Object)"8.0.2");
            JSONObject jSONObject2 = null;
            String string = "";
            String string2 = "";
            if (this.mGeneralBodyIds.size() > 0 && (jSONObject2 = UMProcessDBHelper.getInstance(this.mContext).readVersionInfoFromColumId(this.mGeneralBodyIds.get(0))) != null) {
                string = jSONObject2.optString("__av");
                string2 = jSONObject2.optString("__vc");
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                jSONObject.put("app_version", (Object)UMUtils.getAppVersionName((Context)this.mContext));
            } else {
                jSONObject.put("app_version", (Object)string);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("version_code", (Object)UMUtils.getAppVersionCode((Context)this.mContext));
            } else {
                jSONObject.put("version_code", (Object)string2);
            }
            String string3 = HelperUtils.MD5((String)AnalyticsConfig.getSecretKey(this.mContext));
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("secret", (Object)string3);
            }
            String string4 = UMEnvelopeBuild.imprintProperty((Context)this.mContext, (String)"pr_ve", null);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault((Context)this.mContext);
            jSONObject.put("$pr_ve", (Object)UMEnvelopeBuild.imprintProperty((Context)this.mContext, (String)"pr_ve", null));
            jSONObject.put("$ud_da", (Object)UMEnvelopeBuild.imprintProperty((Context)this.mContext, (String)"ud_da", null));
            jSONObject.put("pro_ver", (Object)"1.0.0");
            if (TextUtils.isEmpty((CharSequence)string4)) {
                jSONObject.put("$pr_ve", (Object)sharedPreferences.getString("vers_pre_version", "0"));
                String string5 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date(System.currentTimeMillis()));
                jSONObject.put("$ud_da", (Object)sharedPreferences.getString("vers_date", string5));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject generalBody() {
        JSONObject jSONObject = null;
        try {
            JSONObject jSONObject2;
            Object object;
            if (this.mGeneralBodyIds == null) {
                this.mGeneralBodyIds = new ArrayList<Integer>();
            }
            jSONObject = UMProcessDBHelper.getInstance(this.mContext).readMainEvents(UMEnvelopeBuild.maxDataSpace((Context)this.mContext) - 2000L, this.mGeneralBodyIds);
            SharedPreferences sharedPreferences = PreferenceWrapper.getDefault((Context)this.mContext);
            if (sharedPreferences != null && !TextUtils.isEmpty((CharSequence)(object = sharedPreferences.getString("userlevel", "")))) {
                jSONObject.put("userlevel", object);
            }
            if ((object = c.a(this.mContext)) != null && !TextUtils.isEmpty((CharSequence)object[0]) && !TextUtils.isEmpty((CharSequence)object[1])) {
                jSONObject2 = new JSONObject();
                jSONObject2.put("provider", (Object)object[0]);
                jSONObject2.put("puid", (Object)object[1]);
                if (jSONObject2.length() > 0) {
                    jSONObject.put("active_user", (Object)jSONObject2);
                }
            }
            if (ABTest.getService((Context)this.mContext).isInTest()) {
                jSONObject2 = new JSONObject();
                jSONObject2.put(ABTest.getService((Context)this.mContext).getTestName(), (Object)ABTest.getService((Context)this.mContext).getGroupInfo());
                jSONObject.put("group_info", (Object)jSONObject2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jSONObject;
    }

    private void constructMessage() {
        int n2 = this.defconProcesserHandler();
        if (n2 != 0) {
            return;
        }
        this.mLockUtil.doFileOperateion(b.b(this.mContext, ""), (FileLockCallback)new ConstructMessageCallback());
    }

    private int defconProcesserHandler() {
        int n2 = n.a().a(this.mContext);
        if (n2 != 0) {
            try {
                DBFileTraversalUtil.traverseDBFiles(b.a(this.mContext), new ReplaceCallback(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            UMProcessDBHelper.getInstance(this.mContext).deleteEventDatas("_main_", null, null);
        }
        return n2;
    }

    static {
        executor = new ScheduledThreadPoolExecutor(1);
    }

    private class ReplaceCallback
    implements FileLockCallback {
        private ReplaceCallback() {
        }

        public boolean onFileLock(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return true;
            }
            if (string.startsWith("ua_")) {
                string = string.replaceFirst("ua_", "");
            }
            string = string.replace(".db", "");
            UMProcessDBHelper.getInstance(UMProcessDBDatasSender.this.mContext).deleteEventDatas(string, null, null);
            return true;
        }

        public boolean onFileLock(File file, int n2) {
            return false;
        }

        public boolean onFileLock(String string, Object object) {
            return false;
        }
    }

    private class ConstructMessageCallback
    implements FileLockCallback {
        private ConstructMessageCallback() {
        }

        public boolean onFileLock(String string) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = UMProcessDBDatasSender.this.setupReportData(UMEnvelopeBuild.maxDataSpace((Context)UMProcessDBDatasSender.this.mContext));
            if (jSONObject2 == null || jSONObject2.length() < 1) {
                return true;
            }
            JSONObject jSONObject3 = (JSONObject)jSONObject2.opt("header");
            JSONObject jSONObject4 = (JSONObject)jSONObject2.opt("content");
            if (UMProcessDBDatasSender.this.mContext != null && jSONObject3 != null && jSONObject4 != null && (jSONObject = UMEnvelopeBuild.buildEnvelopeWithExtHeader((Context)UMProcessDBDatasSender.this.mContext, (JSONObject)jSONObject3, (JSONObject)jSONObject4)) != null) {
                UMProcessDBDatasSender.this.removeCacheData(jSONObject);
            }
            return true;
        }

        public boolean onFileLock(File file, int n2) {
            return false;
        }

        public boolean onFileLock(String string, Object object) {
            return false;
        }
    }
}

