﻿namespace ByteBard.AsyncAPI.Tests.Bindings.WebSockets
{
    using System.Linq;
    using FluentAssertions;
    using ByteBard.AsyncAPI.Bindings.MQTT;
    using ByteBard.AsyncAPI.Bindings.Pulsar;
    using ByteBard.AsyncAPI.Bindings.WebSockets;
    using ByteBard.AsyncAPI.Models;
    using NUnit.Framework;

    public class BindingExtensions_Should
    {
        [Test]
        public void V2_TryGetValue_WithChannelBinding_ReturnsBinding()
        {
            var channel = new AsyncApiChannel();
            channel.Bindings.Add(new WebSocketsChannelBinding
            {
                Method = "POST",
                Query = new AsyncApiJsonSchema
                {
                    Description = "this mah query",
                },
                Headers = new AsyncApiJsonSchema
                {
                    Description = "this mah binding",
                },
            });

            var result = channel.Bindings.TryGetValue<WebSocketsChannelBinding>(out var channelBinding);
            result.Should().BeTrue();
            channelBinding.Should().NotBeNull();
            channelBinding.Should().BeEquivalentTo(channel.Bindings.First().Value);
        }

        [Test]
        public void V2_TryGetValue_WithServerBinding_ReturnsBinding()
        {
            var server = new AsyncApiServer();
            server.Bindings.Add(new PulsarServerBinding
            {
                Tenant = "test tenant",
            });

            var result = server.Bindings.TryGetValue<PulsarServerBinding>(out var serverBinding);
            result.Should().BeTrue();
            serverBinding.Should().NotBeNull();
            serverBinding.Should().BeEquivalentTo(server.Bindings.First().Value);
        }

        [Test]
        public void V2_TryGetValue_WithOperationBinding_ReturnsBinding()
        {
            var operation = new AsyncApiOperation();
            operation.Bindings.Add(new MQTTOperationBinding
            {
                QoS = 23,
                MessageExpiryInterval = 1,
                Retain = true,
            });

            var result = operation.Bindings.TryGetValue<MQTTOperationBinding>(out var operationBinding);
            result.Should().BeTrue();
            operationBinding.Should().NotBeNull();
            operationBinding.Should().BeEquivalentTo(operation.Bindings.First().Value);
        }

        [Test]
        public void V2_TryGetValue_WithMessageBinding_ReturnsBinding()
        {
            var message = new AsyncApiMessage();
            message.Bindings.Add(new MQTTMessageBinding
            {
                PayloadFormatIndicator = 2,
                CorrelationData = new AsyncApiJsonSchema
                {
                    Description = "Test",
                },
            });

            var result = message.Bindings.TryGetValue<MQTTMessageBinding>(out var messageBinding);
            result.Should().BeTrue();
            messageBinding.Should().NotBeNull();
            messageBinding.Should().BeEquivalentTo(message.Bindings.First().Value);
        }
    }
}
