﻿namespace ByteBard.AsyncAPI.Validation.Rules
{
    using ByteBard.AsyncAPI.Models.Interfaces;
    using ByteBard.AsyncAPI.Validations;

    [AsyncApiRule]
    public static class AsyncApiExtensionRules
    {
        /// <summary>
        /// Extension name MUST start with "x-".
        /// </summary>
        public static ValidationRule<IAsyncApiExtensible> ExtensionNameMustStartWithXDash =>
            new ValidationRule<IAsyncApiExtensible>(
                (context, item) =>
                {
                    context.Enter("extensions");
                    foreach (var extensible in item.Extensions)
                    {
                        if (!extensible.Key.StartsWith("x-"))
                        {
                            context.CreateError(
                                nameof(ExtensionNameMustStartWithXDash),
                                string.Format(Resource.Validation_ExtensionNameMustBeginWithXDash, extensible.Key, context.PathString));
                        }
                    }

                    context.Exit();
                });
    }
}
