﻿namespace ByteBard.AsyncAPI.Models
{
    public static class AsyncApiConstants
    {
        public const string ExtensionFieldNamePrefix = "x-";
        public const string AsyncApi = "asyncapi";
        public const string DollarRef = "$ref";
        public const string Info = "info";
        public const string Servers = "servers";
        public const string Channels = "channels";
        public const string Operations = "operations";
        public const string Components = "components";
        public const string Tags = "tags";
        public const string ExternalDocs = "externalDocs";
        public const string Action = "action";
        public const string Channel = "channel";
        public const string Address = "address";
        public const string Title = "title";
        public const string Description = "description";
        public const string TermsOfService = "termsOfService";
        public const string Contact = "contact";
        public const string License = "license";
        public const string Version = "version";
        public const string Name = "name";
        public const string Url = "url";
        public const string Email = "email";
        public const string Protocol = "protocol";
        public const string Host = "host";
        public const string PathName = "pathname";
        public const string ProtocolVersion = "protocolVersion";
        public const string Variables = "variables";
        public const string Security = "security";
        public const string Bindings = "bindings";
        public const string Type = "type";
        public const string In = "in";
        public const string Scheme = "scheme";
        public const string BearerFormat = "bearerFormat";
        public const string OpenIdConnectUrl = "openIdConnectUrl";
        public const string Flows = "flows";
        public const string Implicit = "implicit";
        public const string Password = "password";
        public const string ClientCredentials = "clientCredentials";
        public const string AuthorizationCode = "authorizationCode";
        public const string Basic = "basic";
        public const string Flow = "flow";
        public const string AuthorizationUrl = "authorizationUrl";
        public const string TokenUrl = "tokenUrl";
        public const string Scopes = "scopes";
        public const string AvailableScopes = "availableScopes";
        public const string Application = "application";
        public const string AccessCode = "accessCode";
        public const string Enum = "enum";
        public const string Default = "default";
        public const string Example = "example";
        public const string Examples = "examples";
        public const string Id = "id";
        public const string DefaultContentType = "defaultContentType";
        public const string OperationId = "operationId";
        public const string Summary = "summary";
        public const string Traits = "traits";
        public const string Message = "message";
        public const string MultipleOf = "multipleOf";
        public const string Maximum = "maximum";
        public const string ExclusiveMaximum = "exclusiveMaximum";
        public const string Minimum = "minimum";
        public const string ExclusiveMinimum = "exclusiveMinimum";
        public const string MaxLength = "maxLength";
        public const string MinLength = "minLength";
        public const string Pattern = "pattern";
        public const string MaxItems = "maxItems";
        public const string MinItems = "minItems";
        public const string UniqueItems = "uniqueItems";
        public const string MaxProperties = "maxProperties";
        public const string MinProperties = "minProperties";
        public const string Required = "required";
        public const string Const = "const";
        public const string AllOf = "allOf";
        public const string AnyOf = "anyOf";
        public const string OneOf = "oneOf";
        public const string Not = "not";
        public const string Contains = "contains";
        public const string If = "if";
        public const string Then = "then";
        public const string Else = "else";
        public const string Items = "items";
        public const string Properties = "properties";
        public const string AdditionalProperties = "additionalProperties";
        public const string Format = "format";
        public const string Nullable = "nullable";
        public const string Discriminator = "discriminator";
        public const string ReadOnly = "readOnly";
        public const string WriteOnly = "writeOnly";
        public const string Deprecated = "deprecated";
        public const string Schema = "schema";
        public const string Location = "location";
        public const string Subscribe = "subscribe";
        public const string Publish = "publish";
        public const string Parameters = "parameters";
        public const string Schemas = "schemas";
        public const string Messages = "messages";
        public const string Reply = "reply";
        public const string SecuritySchemes = "securitySchemes";
        public const string CorrelationIds = "correlationIds";
        public const string OperationTraits = "operationTraits";
        public const string MessageTraits = "messageTraits";
        public const string ServerBindings = "serverBindings";
        public const string ChannelBindings = "channelBindings";
        public const string OperationBindings = "operationBindings";
        public const string MessageBindings = "messageBindings";
        public const string RefreshUrl = "refreshUrl";
        public const string Headers = "headers";
        public const string Payload = "payload";
        public const string CorrelationId = "correlationId";
        public const string SchemaFormat = "schemaFormat";
        public const string ContentType = "contentType";
        public const string BindingVersion = "bindingVersion";
        public const string Key = "key";
        public const string Method = "method";
        public const string SchemaIdPayloadEncoding = "schemaIdPayloadEncoding";
        public const string SchemaLookupStrategy = "schemaLookupStrategy";
        public const string SchemaIdLocation = "SchemaIdLocation";
        public const string Query = "query";
        public const string GroupId = "groupId";
        public const string ClientId = "clientId";
        public const string SchemaRegistryUrl = "schemaRegistryUrl";
        public const string SchemaRegistryVendor = "schemaRegistryVendor";
        public const string Topic = "topic";
        public const string Partitions = "partitions";
        public const string Replicas = "replicas";
        public const string Retention = "retention";
        public const string Deduplication = "deduplication";
        public const string Time = "time";
        public const string Size = "size";
        public const string Persistence = "persistence";
        public const string Compaction = "compaction";
        public const string TTL = "ttl";
        public const string Tenant = "tenant";
        public const string Namespace = "namespace";
        public const string ServerVariables = "serverVariables";
        public const string MessageId = "messageId";
        public const string CleanupPolicy = "cleanup.policy";
        public const string RetentionMilliseconds = "retention.ms";
        public const string RetentionBytes = "retention.bytes";
        public const string DeleteRetentionMilliseconds = "delete.retention.ms";
        public const string MaxMessageBytes = "max.message.bytes";
        public const string ConfluentKeySchemaValidation = "confluent.key.schema.validation";
        public const string ConfluentKeySubjectName = "confluent.key.subject.name.strategy";
        public const string ConfluentValueSchemaValidation = "confluent.value.schema.validation";
        public const string ConfluentValueSubjectName = "confluent.value.subject.name.strategy";
        public const string TopicConfiguration = "topicConfiguration";
        public const string GeoReplication = "geo-replication";
        public const string AdditionalItems = "additionalItems";
        public const string PropertyNames = "propertyNames";
        public const string PatternProperties = "patternProperties";
    }
}
