/**
 * 
 * Unit tests for StopStream Verb class
 *
 * @throws JAXBException if the test fails
 */

package com.bandwidth.sdk.unit.models.bxml;

import com.bandwidth.sdk.model.bxml.Bxml;
import com.bandwidth.sdk.model.bxml.StopStream;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;

import org.junit.jupiter.api.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

public class StopStreamVerbTest {

    @Test
    public void stopStreamVerbWorks() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance(Bxml.class);
        String expectedBxml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Bxml><StopStream name=\"name\"/></Bxml>";

        assertThat(new Bxml().with(new StopStream("name")).toBxml(jaxbContext), is(expectedBxml));
    };

    @Test
    public void stopStreamVerbWithWaitWorks() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance(Bxml.class);
        String expectedBxml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Bxml><StopStream name=\"name\" wait=\"true\"/></Bxml>";

        assertThat(new Bxml().with(new StopStream("name", true)).toBxml(jaxbContext), is(expectedBxml));
    };
};
