/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk.unit.models;

import com.bandwidth.sdk.model.CompletedLookupStatusEnum;
import com.bandwidth.sdk.model.CreateSyncLookupResponse;
import com.bandwidth.sdk.model.CreateSyncLookupResponseData;
import com.bandwidth.sdk.model.LinkSchema;
import com.bandwidth.sdk.model.LookupErrorSchema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.instanceOf;

/**
 * Model tests for CreateSyncLookupResponse
 */
public class CreateSyncLookupResponseTest {
    private final CreateSyncLookupResponse model = new CreateSyncLookupResponse()
            .links(Arrays.asList(new LinkSchema()
                    .href("https://api.bandwidth.com/v1.0/lookups/12345")
                    .rel("self").method("GET")))
            .data(new CreateSyncLookupResponseData()
                    .requestId(java.util.UUID.fromString("123e4567-e89b-12d3-a456-426614174000"))
                    .status(CompletedLookupStatusEnum.COMPLETE)
                    .results(new ArrayList<>()))
            .errors(Arrays.asList(new LookupErrorSchema()
                    .code("InvalidNumber")
                    .description("The phone number provided is invalid.")
                    .type("ValidationError")));

    /**
     * Model tests for CreateSyncLookupResponse
     */
    @Test
    public void testCreateSyncLookupResponse() {
        assertThat(model, instanceOf(CreateSyncLookupResponse.class));
    }

    /**
     * Test the property 'links'
     */
    @Test
    public void linksTest() {
        assertThat(model.getLinks(), instanceOf(List.class));
    }

    /**
     * Test the property 'data'
     */
    @Test
    public void dataTest() {
        assertThat(model.getData(), instanceOf(CreateSyncLookupResponseData.class));
    }

    /**
     * Test the property 'errors'
     */
    @Test
    public void errorsTest() {
        assertThat(model.getErrors(), instanceOf(List.class));
    }

}
