/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.bandwidth.sdk.unit.api;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import com.bandwidth.sdk.ApiClient;
import com.bandwidth.sdk.ApiException;
import com.bandwidth.sdk.ApiResponse;
import com.bandwidth.sdk.Configuration;
import com.bandwidth.sdk.api.TollFreeVerificationApi;
import com.bandwidth.sdk.auth.HttpBasicAuth;
import com.bandwidth.sdk.model.Address;
import com.bandwidth.sdk.model.BusinessEntityTypeEnum;
import com.bandwidth.sdk.model.BusinessRegistrationTypeEnum;
import com.bandwidth.sdk.model.Contact;
import com.bandwidth.sdk.model.LinksObject;
import com.bandwidth.sdk.model.OptInWorkflow;
import com.bandwidth.sdk.model.TelephoneNumber;
import com.bandwidth.sdk.model.TfvBasicAuthentication;
import com.bandwidth.sdk.model.TfvStatus;
import com.bandwidth.sdk.model.TfvStatusEnum;
import com.bandwidth.sdk.model.TfvSubmissionInfo;
import com.bandwidth.sdk.model.TfvSubmissionWrapper;
import com.bandwidth.sdk.model.VerificationRequest;
import com.bandwidth.sdk.model.WebhookSubscription;
import com.bandwidth.sdk.model.WebhookSubscriptionBasicAuthentication;
import com.bandwidth.sdk.model.WebhookSubscriptionRequestSchema;
import com.bandwidth.sdk.model.WebhookSubscriptionTypeEnum;
import com.bandwidth.sdk.model.WebhookSubscriptionsListBody;

import static com.bandwidth.sdk.utils.TestingEnvironmentVariables.*;
import static org.hamcrest.MatcherAssert.assertThat;

import java.time.OffsetDateTime;
import java.util.List;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.is;

@SuppressWarnings("null")
public class TollFreeVerificationApiTest {
    private static ApiClient defaultClient = Configuration.getDefaultApiClient();
    private static HttpBasicAuth Basic = (HttpBasicAuth) defaultClient.getAuthentication("Basic");
    private static TollFreeVerificationApi api = new TollFreeVerificationApi(defaultClient);

    private static WebhookSubscriptionRequestSchema webhookSubscriptionRequestSchema = new WebhookSubscriptionRequestSchema()
            .basicAuthentication(new TfvBasicAuthentication()
                    .username("username")
                    .password("password"))
            .callbackUrl("https://example.com")
            .sharedSecretKey("shared-secret-key");

    @BeforeAll
    public static void setUp() {
        Basic.setUsername(BW_USERNAME);
        Basic.setPassword(BW_PASSWORD);
        api.setCustomBaseUrl("http://127.0.0.1:4010");
    }

    @Test
    public void createWebhookSubscriptionTest() throws ApiException {
        ApiResponse<WebhookSubscription> response = api.createWebhookSubscriptionWithHttpInfo(BW_ACCOUNT_ID,
                webhookSubscriptionRequestSchema);

        assertThat(response.getStatusCode(), is(201));
        assertThat(response.getData(), instanceOf(WebhookSubscription.class));
        assertThat(response.getData().getId(), instanceOf(String.class));
        assertThat(response.getData().getAccountId(), instanceOf(String.class));
        assertThat(response.getData().getCallbackUrl(), instanceOf(String.class));
        assertThat(response.getData().getType(), instanceOf(WebhookSubscriptionTypeEnum.class));
        assertThat(response.getData().getBasicAuthentication(),
                instanceOf(WebhookSubscriptionBasicAuthentication.class));
        assertThat(response.getData().getBasicAuthentication().getUsername(), instanceOf(String.class));
        assertThat(response.getData().getBasicAuthentication().getPassword(), instanceOf(String.class));
        assertThat(response.getData().getCreatedDate(), instanceOf(OffsetDateTime.class));
        assertThat(response.getData().getModifiedDate(), instanceOf(OffsetDateTime.class));
    }

    @Test
    public void deleteWebhookSubscriptionTest() throws ApiException {
        ApiResponse<Void> response = api.deleteWebhookSubscriptionWithHttpInfo(BW_ACCOUNT_ID, "test-id-1234");
        assertThat(response.getStatusCode(), is(204));
    }

    @Test
    public void getTollFreeVerificationStatusTest() throws ApiException {
        ApiResponse<TfvStatus> response = api
                .getTollFreeVerificationStatusWithHttpInfo(BW_ACCOUNT_ID, "+18005551234");

        assertThat(response.getStatusCode(), is(200));
        assertThat(response.getData(), instanceOf(TfvStatus.class));
        assertThat(response.getData().getPhoneNumber(), instanceOf(String.class));
        assertThat(response.getData().getStatus(), instanceOf(TfvStatusEnum.class));
        assertThat(response.getData().getInternalTicketNumber(), instanceOf(String.class));
        assertThat(response.getData().getDeclineReasonDescription(), instanceOf(String.class));
        assertThat(response.getData().getResubmitAllowed(), instanceOf(Boolean.class));
        assertThat(response.getData().getCreatedDateTime(), instanceOf(OffsetDateTime.class));
        assertThat(response.getData().getModifiedDateTime(), instanceOf(OffsetDateTime.class));
        assertThat(response.getData().getSubmission(), instanceOf(TfvSubmissionInfo.class));
        assertThat(response.getData().getBlocked(), instanceOf(Boolean.class));
        assertThat(response.getData().getBlockedReason(), instanceOf(String.class));
        assertThat(response.getData().getCvToken(), instanceOf(String.class));
    }

    @Test
    public void deleteVerificationRequestTest() throws ApiException {
        ApiResponse<Void> response = api.deleteVerificationRequestWithHttpInfo(BW_ACCOUNT_ID, "+18005551234");

        assertThat(response.getStatusCode(), is(204));
    }

    @Test
    public void listTollFreeUseCasesTest() throws ApiException {
        ApiResponse<List<String>> response = api.listTollFreeUseCasesWithHttpInfo();

        assertThat(response.getStatusCode(), is(200));
        assertThat(response.getData(), instanceOf(List.class));
    }

    @Test
    public void listWebhookSubscriptionsTest() throws ApiException {
        ApiResponse<WebhookSubscriptionsListBody> response = api.listWebhookSubscriptionsWithHttpInfo(BW_ACCOUNT_ID);

        assertThat(response.getStatusCode(), is(200));
        assertThat(response.getData(), instanceOf(WebhookSubscriptionsListBody.class));
        assertThat(response.getData().getLinks(), instanceOf(LinksObject.class));
        assertThat(response.getData().getLinks().getFirst(), instanceOf(String.class));
        assertThat(response.getData().getLinks().getNext(), instanceOf(String.class));
        assertThat(response.getData().getLinks().getPrevious(), instanceOf(String.class));
        assertThat(response.getData().getLinks().getLast(), instanceOf(String.class));
        assertThat(response.getData().getErrors(), instanceOf(List.class));
        assertThat(response.getData().getErrors().get(0).getCode(), instanceOf(Integer.class));
        assertThat(response.getData().getErrors().get(0).getDescription(), instanceOf(String.class));
        assertThat(response.getData().getErrors().get(0).getTelephoneNumbers(), instanceOf(List.class));
        assertThat(response.getData().getErrors().get(0).getTelephoneNumbers().get(0),
                instanceOf(TelephoneNumber.class));
        assertThat(response.getData().getErrors().get(0).getTelephoneNumbers().get(0).getTelephoneNumber(),
                instanceOf(String.class));
        assertThat(response.getData().getData(), instanceOf(List.class));
        assertThat(response.getData().getData().get(0), instanceOf(WebhookSubscription.class));
        assertThat(response.getData().getData().get(0).getId(), instanceOf(String.class));
        assertThat(response.getData().getData().get(0).getAccountId(), instanceOf(String.class));
        assertThat(response.getData().getData().get(0).getCallbackUrl(), instanceOf(String.class));
        assertThat(response.getData().getData().get(0).getType(), instanceOf(WebhookSubscriptionTypeEnum.class));
        assertThat(response.getData().getData().get(0).getBasicAuthentication(),
                instanceOf(WebhookSubscriptionBasicAuthentication.class));
        assertThat(response.getData().getData().get(0).getBasicAuthentication().getUsername(),
                instanceOf(String.class));
        assertThat(response.getData().getData().get(0).getBasicAuthentication().getPassword(),
                instanceOf(String.class));
        assertThat(response.getData().getData().get(0).getCreatedDate(), instanceOf(OffsetDateTime.class));
        assertThat(response.getData().getData().get(0).getModifiedDate(), instanceOf(OffsetDateTime.class));
    }

    @Test
    public void requestTollFreeVerificationTest() throws ApiException {
        VerificationRequest verificationRequest = new VerificationRequest()
                .businessAddress(new Address()
                        .name("name")
                        .addr1("addr1")
                        .addr2("addr2")
                        .city("city")
                        .state("state")
                        .zip("zip")
                        .url("https://example.com"))
                .businessContact(new Contact()
                        .firstName("first-name")
                        .lastName("last-name")
                        .email("email@email.com")
                        .phoneNumber("+19195551234"))
                .messageVolume(12)
                .phoneNumbers(List.of("+18005551234"))
                .useCase("useCase")
                .useCaseSummary("useCaseSummary")
                .productionMessageContent("productionMessageContent")
                .optInWorkflow(new OptInWorkflow()
                        .description("description")
                        .imageUrls(List.of("https://example.com"))
                        .confirmationResponse("confirmationResponse"))
                .additionalInformation("additionalInformation")
                .isvReseller("isvReseller")
                .privacyPolicyUrl("privacyPolicyUrl")
                .termsAndConditionsUrl("termsAndConditionsUrl")
                .businessDba("businessDba")
                .businessRegistrationNumber("businessRegistrationNumber")
                .businessRegistrationType(BusinessRegistrationTypeEnum.EIN)
                .businessEntityType(BusinessEntityTypeEnum.PRIVATE_PROFIT)
                .helpMessageResponse("helpMessageResponse")
                .ageGatedContent(true)
                .cvToken("cvToken");

        ApiResponse<Void> response = api.requestTollFreeVerificationWithHttpInfo(BW_ACCOUNT_ID, verificationRequest);

        assertThat(response.getStatusCode(), is(202));
    }

    @Test
    public void updateTollFreeVerificationRequestTest() throws ApiException {
        TfvSubmissionWrapper tfvSubmissionWrapper = new TfvSubmissionWrapper()
                .submission(null);
        ApiResponse<Void> response = api.updateTollFreeVerificationRequestWithHttpInfo(BW_ACCOUNT_ID, "+18005551234",
                tfvSubmissionWrapper);

        assertThat(response.getStatusCode(), is(202));
    }

    @Test
    public void updateWebhookSubscriptionTest() throws ApiException {
        ApiResponse<WebhookSubscription> response = api.updateWebhookSubscriptionWithHttpInfo(BW_ACCOUNT_ID,
                "test-id-1234",
                webhookSubscriptionRequestSchema);

        assertThat(response.getStatusCode(), is(200));
        assertThat(response.getData(), instanceOf(WebhookSubscription.class));
        assertThat(response.getData().getId(), instanceOf(String.class));
        assertThat(response.getData().getAccountId(), instanceOf(String.class));
        assertThat(response.getData().getCallbackUrl(), instanceOf(String.class));
        assertThat(response.getData().getType(),
                instanceOf(WebhookSubscriptionTypeEnum.class));
        assertThat(response.getData().getBasicAuthentication(),
                instanceOf(WebhookSubscriptionBasicAuthentication.class));
        assertThat(response.getData().getBasicAuthentication().getUsername(),
                instanceOf(String.class));
        assertThat(response.getData().getBasicAuthentication().getPassword(),
                instanceOf(String.class));
        assertThat(response.getData().getCreatedDate(),
                instanceOf(OffsetDateTime.class));
        assertThat(response.getData().getModifiedDate(),
                instanceOf(OffsetDateTime.class));
    }

}
