/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk.model;

import java.util.Objects;
import java.util.Locale;
import com.bandwidth.sdk.model.TfvStatusEnum;
import com.bandwidth.sdk.model.TfvSubmissionInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Locale;

import com.bandwidth.sdk.JSON;

/**
 * TfvStatus
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.17.0")
public class TfvStatus {
  public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
  @SerializedName(SERIALIZED_NAME_PHONE_NUMBER)
  @javax.annotation.Nullable
  private String phoneNumber;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  @javax.annotation.Nullable
  private TfvStatusEnum status;

  public static final String SERIALIZED_NAME_INTERNAL_TICKET_NUMBER = "internalTicketNumber";
  @SerializedName(SERIALIZED_NAME_INTERNAL_TICKET_NUMBER)
  @javax.annotation.Nullable
  private String internalTicketNumber;

  public static final String SERIALIZED_NAME_DECLINE_REASON_DESCRIPTION = "declineReasonDescription";
  @SerializedName(SERIALIZED_NAME_DECLINE_REASON_DESCRIPTION)
  @javax.annotation.Nullable
  private String declineReasonDescription;

  public static final String SERIALIZED_NAME_RESUBMIT_ALLOWED = "resubmitAllowed";
  @SerializedName(SERIALIZED_NAME_RESUBMIT_ALLOWED)
  @javax.annotation.Nullable
  private Boolean resubmitAllowed;

  public static final String SERIALIZED_NAME_CREATED_DATE_TIME = "createdDateTime";
  @SerializedName(SERIALIZED_NAME_CREATED_DATE_TIME)
  @javax.annotation.Nullable
  private OffsetDateTime createdDateTime;

  public static final String SERIALIZED_NAME_MODIFIED_DATE_TIME = "modifiedDateTime";
  @SerializedName(SERIALIZED_NAME_MODIFIED_DATE_TIME)
  @javax.annotation.Nullable
  private OffsetDateTime modifiedDateTime;

  public static final String SERIALIZED_NAME_SUBMISSION = "submission";
  @SerializedName(SERIALIZED_NAME_SUBMISSION)
  @javax.annotation.Nullable
  private TfvSubmissionInfo submission;

  public static final String SERIALIZED_NAME_BLOCKED = "blocked";
  @SerializedName(SERIALIZED_NAME_BLOCKED)
  @javax.annotation.Nullable
  private Boolean blocked;

  public static final String SERIALIZED_NAME_BLOCKED_REASON = "blockedReason";
  @SerializedName(SERIALIZED_NAME_BLOCKED_REASON)
  @javax.annotation.Nullable
  private String blockedReason;

  public static final String SERIALIZED_NAME_CV_TOKEN = "cvToken";
  @SerializedName(SERIALIZED_NAME_CV_TOKEN)
  @javax.annotation.Nullable
  private String cvToken;

  public TfvStatus() {
  }

  public TfvStatus phoneNumber(@javax.annotation.Nullable String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Toll-free telephone number in E.164 format.
   * @return phoneNumber
   */
  @javax.annotation.Nullable
  public String getPhoneNumber() {
    return phoneNumber;
  }

  public void setPhoneNumber(@javax.annotation.Nullable String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public TfvStatus status(@javax.annotation.Nullable TfvStatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable
  public TfvStatusEnum getStatus() {
    return status;
  }

  public void setStatus(@javax.annotation.Nullable TfvStatusEnum status) {
    this.status = status;
  }


  public TfvStatus internalTicketNumber(@javax.annotation.Nullable String internalTicketNumber) {
    this.internalTicketNumber = internalTicketNumber;
    return this;
  }

  /**
   * Unique identifier (UUID) generated by Bandwidth to assist in tracking the verification status of a toll-free number - included in all webhook payloads.
   * @return internalTicketNumber
   */
  @javax.annotation.Nullable
  public String getInternalTicketNumber() {
    return internalTicketNumber;
  }

  public void setInternalTicketNumber(@javax.annotation.Nullable String internalTicketNumber) {
    this.internalTicketNumber = internalTicketNumber;
  }


  public TfvStatus declineReasonDescription(@javax.annotation.Nullable String declineReasonDescription) {
    this.declineReasonDescription = declineReasonDescription;
    return this;
  }

  /**
   * Explanation for why a verification request was declined.
   * @return declineReasonDescription
   */
  @javax.annotation.Nullable
  public String getDeclineReasonDescription() {
    return declineReasonDescription;
  }

  public void setDeclineReasonDescription(@javax.annotation.Nullable String declineReasonDescription) {
    this.declineReasonDescription = declineReasonDescription;
  }


  public TfvStatus resubmitAllowed(@javax.annotation.Nullable Boolean resubmitAllowed) {
    this.resubmitAllowed = resubmitAllowed;
    return this;
  }

  /**
   * Whether a Toll-Free Verification request qualifies for resubmission via PUT.
   * @return resubmitAllowed
   */
  @javax.annotation.Nullable
  public Boolean getResubmitAllowed() {
    return resubmitAllowed;
  }

  public void setResubmitAllowed(@javax.annotation.Nullable Boolean resubmitAllowed) {
    this.resubmitAllowed = resubmitAllowed;
  }


  public TfvStatus createdDateTime(@javax.annotation.Nullable OffsetDateTime createdDateTime) {
    this.createdDateTime = createdDateTime;
    return this;
  }

  /**
   * Date and time the verification request was created.
   * @return createdDateTime
   */
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedDateTime() {
    return createdDateTime;
  }

  public void setCreatedDateTime(@javax.annotation.Nullable OffsetDateTime createdDateTime) {
    this.createdDateTime = createdDateTime;
  }


  public TfvStatus modifiedDateTime(@javax.annotation.Nullable OffsetDateTime modifiedDateTime) {
    this.modifiedDateTime = modifiedDateTime;
    return this;
  }

  /**
   * Date and time the verification request was last modified.
   * @return modifiedDateTime
   */
  @javax.annotation.Nullable
  public OffsetDateTime getModifiedDateTime() {
    return modifiedDateTime;
  }

  public void setModifiedDateTime(@javax.annotation.Nullable OffsetDateTime modifiedDateTime) {
    this.modifiedDateTime = modifiedDateTime;
  }


  public TfvStatus submission(@javax.annotation.Nullable TfvSubmissionInfo submission) {
    this.submission = submission;
    return this;
  }

  /**
   * Get submission
   * @return submission
   */
  @javax.annotation.Nullable
  public TfvSubmissionInfo getSubmission() {
    return submission;
  }

  public void setSubmission(@javax.annotation.Nullable TfvSubmissionInfo submission) {
    this.submission = submission;
  }


  public TfvStatus blocked(@javax.annotation.Nullable Boolean blocked) {
    this.blocked = blocked;
    return this;
  }

  /**
   * Whether a Toll-Free Verification is blocked. This attribute will only be defined when the number is blocked.
   * @return blocked
   */
  @javax.annotation.Nullable
  public Boolean getBlocked() {
    return blocked;
  }

  public void setBlocked(@javax.annotation.Nullable Boolean blocked) {
    this.blocked = blocked;
  }


  public TfvStatus blockedReason(@javax.annotation.Nullable String blockedReason) {
    this.blockedReason = blockedReason;
    return this;
  }

  /**
   * The reason why the Toll-Free Verification is blocked. This attribute will only be defined when the number is blocked.
   * @return blockedReason
   */
  @javax.annotation.Nullable
  public String getBlockedReason() {
    return blockedReason;
  }

  public void setBlockedReason(@javax.annotation.Nullable String blockedReason) {
    this.blockedReason = blockedReason;
  }


  public TfvStatus cvToken(@javax.annotation.Nullable String cvToken) {
    this.cvToken = cvToken;
    return this;
  }

  /**
   * The token provided by Campaign Verify to validate your political use case. Only required for 527 political organizations. If you are not a 527 political organization, this field should be omitted. If you pass an empty string, it will be passed along and potentially rejected.
   * @return cvToken
   */
  @javax.annotation.Nullable
  public String getCvToken() {
    return cvToken;
  }

  public void setCvToken(@javax.annotation.Nullable String cvToken) {
    this.cvToken = cvToken;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the TfvStatus instance itself
   */
  public TfvStatus putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TfvStatus tfvStatus = (TfvStatus) o;
    return Objects.equals(this.phoneNumber, tfvStatus.phoneNumber) &&
        Objects.equals(this.status, tfvStatus.status) &&
        Objects.equals(this.internalTicketNumber, tfvStatus.internalTicketNumber) &&
        Objects.equals(this.declineReasonDescription, tfvStatus.declineReasonDescription) &&
        Objects.equals(this.resubmitAllowed, tfvStatus.resubmitAllowed) &&
        Objects.equals(this.createdDateTime, tfvStatus.createdDateTime) &&
        Objects.equals(this.modifiedDateTime, tfvStatus.modifiedDateTime) &&
        Objects.equals(this.submission, tfvStatus.submission) &&
        Objects.equals(this.blocked, tfvStatus.blocked) &&
        Objects.equals(this.blockedReason, tfvStatus.blockedReason) &&
        Objects.equals(this.cvToken, tfvStatus.cvToken)&&
        Objects.equals(this.additionalProperties, tfvStatus.additionalProperties);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumber, status, internalTicketNumber, declineReasonDescription, resubmitAllowed, createdDateTime, modifiedDateTime, submission, blocked, blockedReason, cvToken, additionalProperties);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TfvStatus {\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    internalTicketNumber: ").append(toIndentedString(internalTicketNumber)).append("\n");
    sb.append("    declineReasonDescription: ").append(toIndentedString(declineReasonDescription)).append("\n");
    sb.append("    resubmitAllowed: ").append(toIndentedString(resubmitAllowed)).append("\n");
    sb.append("    createdDateTime: ").append(toIndentedString(createdDateTime)).append("\n");
    sb.append("    modifiedDateTime: ").append(toIndentedString(modifiedDateTime)).append("\n");
    sb.append("    submission: ").append(toIndentedString(submission)).append("\n");
    sb.append("    blocked: ").append(toIndentedString(blocked)).append("\n");
    sb.append("    blockedReason: ").append(toIndentedString(blockedReason)).append("\n");
    sb.append("    cvToken: ").append(toIndentedString(cvToken)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>(Arrays.asList("phoneNumber", "status", "internalTicketNumber", "declineReasonDescription", "resubmitAllowed", "createdDateTime", "modifiedDateTime", "submission", "blocked", "blockedReason", "cvToken"));

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>(0);
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to TfvStatus
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!TfvStatus.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in TfvStatus is not found in the empty JSON string", TfvStatus.openapiRequiredFields.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("phoneNumber") != null && !jsonObj.get("phoneNumber").isJsonNull()) && !jsonObj.get("phoneNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("phoneNumber").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        TfvStatusEnum.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("internalTicketNumber") != null && !jsonObj.get("internalTicketNumber").isJsonNull()) && !jsonObj.get("internalTicketNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `internalTicketNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("internalTicketNumber").toString()));
      }
      if ((jsonObj.get("declineReasonDescription") != null && !jsonObj.get("declineReasonDescription").isJsonNull()) && !jsonObj.get("declineReasonDescription").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `declineReasonDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get("declineReasonDescription").toString()));
      }
      // validate the optional field `submission`
      if (jsonObj.get("submission") != null && !jsonObj.get("submission").isJsonNull()) {
        TfvSubmissionInfo.validateJsonElement(jsonObj.get("submission"));
      }
      if ((jsonObj.get("blockedReason") != null && !jsonObj.get("blockedReason").isJsonNull()) && !jsonObj.get("blockedReason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `blockedReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("blockedReason").toString()));
      }
      if ((jsonObj.get("cvToken") != null && !jsonObj.get("cvToken").isJsonNull()) && !jsonObj.get("cvToken").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `cvToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cvToken").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TfvStatus.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TfvStatus' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TfvStatus> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TfvStatus.class));

       return (TypeAdapter<T>) new TypeAdapter<TfvStatus>() {
           @Override
           public void write(JsonWriter out, TfvStatus value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                   if (jsonElement.isJsonArray()) {
                     obj.add(entry.getKey(), jsonElement.getAsJsonArray());
                   } else {
                     obj.add(entry.getKey(), jsonElement.getAsJsonObject());
                   }
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public TfvStatus read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             JsonObject jsonObj = jsonElement.getAsJsonObject();
             // store additional fields in the deserialized instance
             TfvStatus instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of TfvStatus given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TfvStatus
   * @throws IOException if the JSON string is invalid with respect to TfvStatus
   */
  public static TfvStatus fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TfvStatus.class);
  }

  /**
   * Convert an instance of TfvStatus to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

