/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import okio.ByteString;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
                .registerTypeSelector(com.bandwidth.sdk.model.Callback.class, new TypeSelector<com.bandwidth.sdk.model.Callback>() {
                    @Override
                    public Class<? extends com.bandwidth.sdk.model.Callback> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("message-delivered", com.bandwidth.sdk.model.StatusCallback.class);
                        classByDiscriminatorValue.put("message-failed", com.bandwidth.sdk.model.StatusCallback.class);
                        classByDiscriminatorValue.put("message-read", com.bandwidth.sdk.model.StatusCallback.class);
                        classByDiscriminatorValue.put("message-received", com.bandwidth.sdk.model.InboundCallback.class);
                        classByDiscriminatorValue.put("message-sent", com.bandwidth.sdk.model.StatusCallback.class);
                        classByDiscriminatorValue.put("request-location-response", com.bandwidth.sdk.model.InboundCallback.class);
                        classByDiscriminatorValue.put("suggestion-response", com.bandwidth.sdk.model.InboundCallback.class);
                        classByDiscriminatorValue.put("callback", com.bandwidth.sdk.model.Callback.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "type"));
                    }
          })
                .registerTypeSelector(com.bandwidth.sdk.model.MultiChannelAction.class, new TypeSelector<com.bandwidth.sdk.model.MultiChannelAction>() {
                    @Override
                    public Class<? extends com.bandwidth.sdk.model.MultiChannelAction> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("CREATE_CALENDAR_EVENT", com.bandwidth.sdk.model.MultiChannelActionCalendarEvent.class);
                        classByDiscriminatorValue.put("DIAL_PHONE", com.bandwidth.sdk.model.RbmActionDial.class);
                        classByDiscriminatorValue.put("OPEN_URL", com.bandwidth.sdk.model.RbmActionOpenUrl.class);
                        classByDiscriminatorValue.put("REPLY", com.bandwidth.sdk.model.RbmActionBase.class);
                        classByDiscriminatorValue.put("REQUEST_LOCATION", com.bandwidth.sdk.model.RbmActionBase.class);
                        classByDiscriminatorValue.put("SHOW_LOCATION", com.bandwidth.sdk.model.RbmActionViewLocation.class);
                        classByDiscriminatorValue.put("multiChannelAction", com.bandwidth.sdk.model.MultiChannelAction.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "type"));
                    }
          })
                .registerTypeSelector(com.bandwidth.sdk.model.MultiChannelChannelListRequestObject.class, new TypeSelector<com.bandwidth.sdk.model.MultiChannelChannelListRequestObject>() {
                    @Override
                    public Class<? extends com.bandwidth.sdk.model.MultiChannelChannelListRequestObject> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("MMS", com.bandwidth.sdk.model.MultiChannelChannelListMMSObject.class);
                        classByDiscriminatorValue.put("RBM", com.bandwidth.sdk.model.MultiChannelChannelListRBMObject.class);
                        classByDiscriminatorValue.put("SMS", com.bandwidth.sdk.model.MultiChannelChannelListSMSObject.class);
                        classByDiscriminatorValue.put("multiChannelChannelListRequestObject", com.bandwidth.sdk.model.MultiChannelChannelListRequestObject.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "channel"));
                    }
          })
                .registerTypeSelector(com.bandwidth.sdk.model.MultiChannelChannelListResponseObject.class, new TypeSelector<com.bandwidth.sdk.model.MultiChannelChannelListResponseObject>() {
                    @Override
                    public Class<? extends com.bandwidth.sdk.model.MultiChannelChannelListResponseObject> getClassForElement(JsonElement readElement) {
                        Map<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                        classByDiscriminatorValue.put("MMS", com.bandwidth.sdk.model.MultiChannelChannelListMMSResponseObject.class);
                        classByDiscriminatorValue.put("RBM", com.bandwidth.sdk.model.MultiChannelChannelListRBMResponseObject.class);
                        classByDiscriminatorValue.put("SMS", com.bandwidth.sdk.model.MultiChannelChannelListSMSResponseObject.class);
                        classByDiscriminatorValue.put("multiChannelChannelListResponseObject", com.bandwidth.sdk.model.MultiChannelChannelListResponseObject.class);
                        return getClassByDiscriminator(classByDiscriminatorValue,
                                getDiscriminatorValue(readElement, "channel"));
                    }
          })
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    static {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.AccountStatistics.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.AdditionalDenialReason.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Address.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.AnswerCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.AsyncLookupRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.BlockedWebhook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.BridgeCompleteCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.BridgeTargetCompleteCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CallRecordingMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CallState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CallTranscription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CallTranscriptionMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CallTranscriptionResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Callback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CodeRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Conference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceCompletedCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceCreatedCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceMember.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceMemberExitCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceMemberJoinCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceRecordingAvailableCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceRecordingMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ConferenceRedirectCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Contact.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateAsyncBulkLookupResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateAsyncBulkLookupResponseData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateCall.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateCallResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateMessageRequestError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateMultiChannelMessageResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateSyncLookupResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.CreateSyncLookupResponseData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.DisconnectCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Diversion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.DtmfCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ErrorObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ErrorSource.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.FailureWebhook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.FieldError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.GatherCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.GetAsyncBulkLookupResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.GetAsyncBulkLookupResponseData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.InboundCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.InboundCallbackMessage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.InitiateCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Link.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LinkSchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LinksObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.ListMessageItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LookupErrorResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LookupErrorSchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LookupErrorSchemaMeta.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.LookupResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MachineDetectionCompleteCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MachineDetectionConfiguration.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MachineDetectionResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Media.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Message.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MessageRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MessagesList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MessagingCodeResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MessagingRequestError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MfaForbiddenRequestError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MfaRequestError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MfaUnauthorizedRequestError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MmsMessageContent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MmsMessageContentFile.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelAction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelActionCalendarEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListMMSObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListMMSResponseObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListObjectBase.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListOwnerObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListRBMObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListRBMObjectAllOfContent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListRBMResponseObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListRequestObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListResponseObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListSMSObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelChannelListSMSResponseObject.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelMessageContent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelMessageRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.MultiChannelMessageResponseData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.OptInWorkflow.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.PageInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmActionBase.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmActionDial.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmActionOpenUrl.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmActionViewLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmCardContent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmCardContentMedia.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmLocationResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmMessageCarouselCard.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmMessageContentFile.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmMessageContentRichCard.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmMessageContentText.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmMessageMedia.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmStandaloneCard.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RbmSuggestionResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RecordingAvailableCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RecordingCompleteCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RecordingTranscriptionMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RecordingTranscriptions.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.RedirectCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.SmsMessageContent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.StatusCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.StatusCallbackMessage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.StirShaken.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.SyncLookupRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TelephoneNumber.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TfvBasicAuthentication.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TfvError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TfvStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TfvSubmissionInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TfvSubmissionWrapper.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TranscribeRecording.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.Transcription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TranscriptionAvailableCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TransferAnswerCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TransferCompleteCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.TransferDisconnectCallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.UpdateCall.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.UpdateCallRecording.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.UpdateConference.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.UpdateConferenceMember.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerificationDenialWebhook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerificationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerificationUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerificationWebhook.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerifyCodeRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VerifyCodeResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VoiceApiError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.VoiceCodeResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.WebhookSubscription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.WebhookSubscriptionBasicAuthentication.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.WebhookSubscriptionRequestSchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.bandwidth.sdk.model.WebhookSubscriptionsListBody.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
    * Deserialize the given JSON InputStream to a Java object.
    *
    * @param <T>         Type
    * @param inputStream The JSON InputStream
    * @param returnType  The type to deserialize into
    * @return The deserialized Java object
    */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(InputStream inputStream, Type returnType) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8)) {
        if (isLenientOnJson) {
            // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(true);
            return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(reader, returnType);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
