

# InitiateCallback

The Initiate event is fired when an inbound call is received for a Telephone Number on your Account. It is sent to the URL specified in the application associated with the location (sip-peer) that the called telephone number belongs to.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**eventType** | **String** | The event type, value can be one of the following: answer, bridgeComplete, bridgeTargetComplete, conferenceCreated, conferenceRedirect, conferenceMemberJoin, conferenceMemberExit, conferenceCompleted, conferenceRecordingAvailable, disconnect, dtmf, gather, initiate, machineDetectionComplete, recordingComplete, recordingAvailable, redirect, transcriptionAvailable, transferAnswer, transferComplete, transferDisconnect. |  [optional] |
|**eventTime** | **OffsetDateTime** | The approximate UTC date and time when the event was generated by the Bandwidth server, in ISO 8601 format. This may not be exactly the time of event execution. |  [optional] |
|**accountId** | **String** | The user account associated with the call. |  [optional] |
|**applicationId** | **String** | The id of the application associated with the call. |  [optional] |
|**from** | **String** | The provided identifier of the caller. Must be a phone number in E.164 format (e.g. +15555555555). |  [optional] |
|**to** | **String** | The phone number that received the call, in E.164 format (e.g. +15555555555). |  [optional] |
|**direction** | **CallDirectionEnum** |  |  [optional] |
|**callId** | **String** | The call id associated with the event. |  [optional] |
|**callUrl** | **URI** | The URL of the call associated with the event. |  [optional] |
|**startTime** | **OffsetDateTime** | Time the call was started, in ISO 8601 format. |  [optional] |
|**diversion** | [**Diversion**](Diversion.md) |  |  [optional] |
|**stirShaken** | [**StirShaken**](StirShaken.md) |  |  [optional] |
|**uui** | **String** | The value of the &#x60;User-To-User&#x60; header to send within the initial &#x60;INVITE&#x60;. Must include the encoding parameter as specified in RFC 7433. Only &#x60;base64&#x60;, &#x60;jwt&#x60; and &#x60;hex&#x60; encoding are currently allowed. This value, including the encoding specifier, may not exceed 256 characters. |  [optional] |



