

# GatherCallback

The gather event is sent after a <Gather> verb is executed. Its purpose is to report the gathered digits to the calling application.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**eventType** | **String** | The event type, value can be one of the following: answer, bridgeComplete, bridgeTargetComplete, conferenceCreated, conferenceRedirect, conferenceMemberJoin, conferenceMemberExit, conferenceCompleted, conferenceRecordingAvailable, disconnect, dtmf, gather, initiate, machineDetectionComplete, recordingComplete, recordingAvailable, redirect, transcriptionAvailable, transferAnswer, transferComplete, transferDisconnect. |  [optional] |
|**eventTime** | **OffsetDateTime** | The approximate UTC date and time when the event was generated by the Bandwidth server, in ISO 8601 format. This may not be exactly the time of event execution. |  [optional] |
|**accountId** | **String** | The user account associated with the call. |  [optional] |
|**applicationId** | **String** | The id of the application associated with the call. |  [optional] |
|**from** | **String** | The provided identifier of the caller. Must be a phone number in E.164 format (e.g. +15555555555). |  [optional] |
|**to** | **String** | The phone number that received the call, in E.164 format (e.g. +15555555555). |  [optional] |
|**direction** | **CallDirectionEnum** |  |  [optional] |
|**callId** | **String** | The call id associated with the event. |  [optional] |
|**digits** | **String** | (optional) The digits, letters, and/or symbols entered by the user. The string is empty if a timeout occurred before any buttons were pressed. |  [optional] |
|**callUrl** | **URI** | The URL of the call associated with the event. |  [optional] |
|**enqueuedTime** | **OffsetDateTime** | (optional) If call queueing is enabled and this is an outbound call, time the call was queued, in ISO 8601 format. |  [optional] |
|**startTime** | **OffsetDateTime** | Time the call was started, in ISO 8601 format. |  [optional] |
|**answerTime** | **OffsetDateTime** | Time the call was answered, in ISO 8601 format. |  [optional] |
|**parentCallId** | **String** | (optional) If the event is related to the B leg of a &lt;Transfer&gt;, the call id of the original call leg that executed the &lt;Transfer&gt;. Otherwise, this field will not be present. |  [optional] |
|**terminatingDigit** | **String** | (optional) The digit the user pressed to end the gather. Empty string value if no terminating digit was pressed. |  [optional] |
|**transferCallerId** | **String** | The phone number used as the from field of the B-leg call, in E.164 format (e.g. +15555555555). |  [optional] |
|**transferTo** | **String** | The phone number used as the to field of the B-leg call, in E.164 format (e.g. +15555555555). |  [optional] |
|**tag** | **String** | (optional) The tag specified on call creation. If no tag was specified or it was previously cleared, this field will not be present. |  [optional] |



