/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk.unit.models;

import org.junit.jupiter.api.Test;
import org.mockito.internal.util.collections.Sets;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import com.bandwidth.sdk.model.MessageDirectionEnum;
import com.bandwidth.sdk.model.MultiChannelMessageResponseData;
import com.bandwidth.sdk.model.PriorityEnum;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Model tests for MultiChannelMessageResponseData
 */
public class MultiChannelMessageResponseDataTest {
    private final MultiChannelMessageResponseData model = new MultiChannelMessageResponseData()
            .id("messageId")
            .time(OffsetDateTime.now())
            .direction(MessageDirectionEnum.IN)
            .to(Sets.newSet("to"))
            .channelList(new ArrayList<>())
            .tag("tag")
            .priority(PriorityEnum.DEFAULT)
            .expiration(OffsetDateTime.now().plusDays(1));

    /**
     * Model tests for MultiChannelMessageResponseData
     */
    @Test
    public void testMultiChannelMessageResponseData() {
        assertThat(model, instanceOf(MultiChannelMessageResponseData.class));
    }

    /**
     * Test the property 'id'
     */
    @Test
    public void idTest() {
        assertThat(model.getId(), instanceOf(String.class));
    }

    /**
     * Test the property 'time'
     */
    @Test
    public void timeTest() {
        assertThat(model.getTime(), instanceOf(OffsetDateTime.class));
    }

    /**
     * Test the property 'direction'
     */
    @Test
    public void directionTest() {
        assertThat(model.getDirection(), instanceOf(MessageDirectionEnum.class));
    }

    /**
     * Test the property 'to'
     */
    @Test
    public void toTest() {
        assertThat(model.getTo(), instanceOf(LinkedHashSet.class));
    }

    /**
     * Test the property 'channelList'
     */
    @Test
    public void channelListTest() {
        assertThat(model.getChannelList(), instanceOf(List.class));
    }

    /**
     * Test the property 'tag'
     */
    @Test
    public void tagTest() {
        assertThat(model.getTag(), instanceOf(String.class));
    }

    /**
     * Test the property 'priority'
     */
    @Test
    public void priorityTest() {
        assertThat(model.getPriority(), instanceOf(PriorityEnum.class));
    }

    /**
     * Test the property 'expiration'
     */
    @Test
    public void expirationTest() {
        assertThat(model.getExpiration(), instanceOf(OffsetDateTime.class));
    }

}
