/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.bandwidth.sdk.unit.models;

import org.junit.jupiter.api.Test;
import org.mockito.internal.util.collections.Sets;

import java.net.URI;
import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.time.OffsetDateTime;
import com.bandwidth.sdk.model.MessageRequest;
import com.bandwidth.sdk.model.PriorityEnum;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.instanceOf;

/**
 * Model tests for MessageRequest
 */
public class MessageRequestTest {
    private final MessageRequest model = new MessageRequest()
            .applicationId("applicationId")
            .to(Sets.newSet("+1234567890"))
            .from("tel:+1234567890")
            .text("text")
            .media(new ArrayList<URI>(Arrays.asList(URI.create("http://example.com"))))
            .tag("tag")
            .priority(PriorityEnum.HIGH)
            .expiration(OffsetDateTime.now());

    /**
     * Model tests for MessageRequest
     */
    @Test
    public void testMessageRequest() {
        assertThat(model, instanceOf(MessageRequest.class));
    }

    /**
     * Test the property 'applicationId'
     */
    @Test
    public void applicationIdTest() {
        assertThat(model.getApplicationId(), instanceOf(String.class));
    }

    /**
     * Test the property 'to'
     */
    @Test
    public void toTest() {
        assertThat(model.getTo(), instanceOf(LinkedHashSet.class));
    }

    /**
     * Test the property 'from'
     */
    @Test
    public void fromTest() {
        assertThat(model.getFrom(), instanceOf(String.class));
    }

    /**
     * Test the property 'text'
     */
    @Test
    public void textTest() {
        assertThat(model.getText(), instanceOf(String.class));
    }

    /**
     * Test the property 'media'
     */
    @Test
    public void mediaTest() {
        assertThat(model.getMedia(), instanceOf(List.class));
    }

    /**
     * Test the property 'tag'
     */
    @Test
    public void tagTest() {
        assertThat(model.getTag(), instanceOf(String.class));
    }

    /**
     * Test the property 'priority'
     */
    @Test
    public void priorityTest() {
        assertThat(model.getPriority(), instanceOf(PriorityEnum.class));
    }

    /**
     * Test the property 'expiration'
     */
    @Test
    public void expirationTest() {
        assertThat(model.getExpiration(), instanceOf(OffsetDateTime.class));
    }

}
