/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk.model;

import java.util.Objects;
import java.util.Locale;
import com.bandwidth.sdk.model.InboundCallback;
import com.bandwidth.sdk.model.InboundCallbackMessage;
import com.bandwidth.sdk.model.InboundCallbackTypeEnum;
import com.bandwidth.sdk.model.StatusCallback;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;



import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Locale;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;

import com.bandwidth.sdk.JSON;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.17.0")
public class Callback extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Callback.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Callback.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'Callback' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<StatusCallback> adapterStatusCallback = gson.getDelegateAdapter(this, TypeToken.get(StatusCallback.class));
            final TypeAdapter<InboundCallback> adapterInboundCallback = gson.getDelegateAdapter(this, TypeToken.get(InboundCallback.class));

            return (TypeAdapter<T>) new TypeAdapter<Callback>() {
                @Override
                public void write(JsonWriter out, Callback value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `StatusCallback`
                    if (value.getActualInstance() instanceof StatusCallback) {
                        JsonElement element = adapterStatusCallback.toJsonTree((StatusCallback)value.getActualInstance());
                        elementAdapter.write(out, element);
                        return;
                    }
                    // check if the actual instance is of the type `InboundCallback`
                    if (value.getActualInstance() instanceof InboundCallback) {
                        JsonElement element = adapterInboundCallback.toJsonTree((InboundCallback)value.getActualInstance());
                        elementAdapter.write(out, element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: InboundCallback, StatusCallback");
                }

                @Override
                public Callback read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = elementAdapter.read(in);

                    JsonObject jsonObject = jsonElement.getAsJsonObject();

                    // use discriminator value for faster oneOf lookup
                    Callback newCallback = new Callback();
                    if (jsonObject.get("type") == null) {
                        log.log(Level.WARNING, "Failed to lookup discriminator value for Callback as `type` was not found in the payload or the payload is empty.");
                    } else  {
                        // look up the discriminator value in the field `type`
                        switch (jsonObject.get("type").getAsString()) {
                            case "message-delivered":
                                deserialized = adapterStatusCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "message-failed":
                                deserialized = adapterStatusCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "message-read":
                                deserialized = adapterStatusCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "message-received":
                                deserialized = adapterInboundCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "message-sent":
                                deserialized = adapterStatusCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "request-location-response":
                                deserialized = adapterInboundCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            case "suggestion-response":
                                deserialized = adapterInboundCallback.fromJsonTree(jsonObject);
                                newCallback.setActualInstance(deserialized);
                                return newCallback;
                            default:
                                log.log(Level.WARNING, String.format(Locale.ROOT, "Failed to lookup discriminator value `%s` for Callback. Possible values: message-delivered message-failed message-read message-received message-sent request-location-response suggestion-response", jsonObject.get("type").getAsString()));
                        }
                    }

                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<>();
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize StatusCallback
                    try {
                        // validate the JSON object to see if any exception is thrown
                        StatusCallback.validateJsonElement(jsonElement);
                        actualAdapter = adapterStatusCallback;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'StatusCallback'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for StatusCallback failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'StatusCallback'", e);
                    }
                    // deserialize InboundCallback
                    try {
                        // validate the JSON object to see if any exception is thrown
                        InboundCallback.validateJsonElement(jsonElement);
                        actualAdapter = adapterInboundCallback;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'InboundCallback'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for InboundCallback failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'InboundCallback'", e);
                    }

                    if (match == 1) {
                        Callback ret = new Callback();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }

                    throw new IOException(String.format(Locale.ROOT, "Failed deserialization for Callback: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, Class<?>> schemas = new HashMap<String, Class<?>>();

    public Callback() {
        super("oneOf", Boolean.FALSE);
    }

    public Callback(Object o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("StatusCallback", StatusCallback.class);
        schemas.put("InboundCallback", InboundCallback.class);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return Callback.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * InboundCallback, StatusCallback
     *
     * It could be an instance of the 'oneOf' schemas.
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof StatusCallback) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof InboundCallback) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be InboundCallback, StatusCallback");
    }

    /**
     * Get the actual instance, which can be the following:
     * InboundCallback, StatusCallback
     *
     * @return The actual instance (InboundCallback, StatusCallback)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `StatusCallback`. If the actual instance is not `StatusCallback`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `StatusCallback`
     * @throws ClassCastException if the instance is not `StatusCallback`
     */
    public StatusCallback getStatusCallback() throws ClassCastException {
        return (StatusCallback)super.getActualInstance();
    }

    /**
     * Get the actual instance of `InboundCallback`. If the actual instance is not `InboundCallback`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `InboundCallback`
     * @throws ClassCastException if the instance is not `InboundCallback`
     */
    public InboundCallback getInboundCallback() throws ClassCastException {
        return (InboundCallback)super.getActualInstance();
    }

    /**
     * Validates the JSON Element and throws an exception if issues found
     *
     * @param jsonElement JSON Element
     * @throws IOException if the JSON Element is invalid with respect to Callback
     */
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        // validate oneOf schemas one by one
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<>();
        // validate the json string with StatusCallback
        try {
            StatusCallback.validateJsonElement(jsonElement);
            validCount++;
        } catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for StatusCallback failed with `%s`.", e.getMessage()));
            // continue to the next one
        }
        // validate the json string with InboundCallback
        try {
            InboundCallback.validateJsonElement(jsonElement);
            validCount++;
        } catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for InboundCallback failed with `%s`.", e.getMessage()));
            // continue to the next one
        }
        if (validCount != 1) {
            throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for Callback with oneOf schemas: InboundCallback, StatusCallback. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    /**
     * Create an instance of Callback given an JSON string
     *
     * @param jsonString JSON string
     * @return An instance of Callback
     * @throws IOException if the JSON string is invalid with respect to Callback
     */
    public static Callback fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Callback.class);
    }

    /**
     * Convert an instance of Callback to an JSON string
     *
     * @return JSON string
     */
    public String toJson() {
        return JSON.getGson().toJson(this);
    }
}

