/*
 * Bandwidth
 * Bandwidth's Communication APIs
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: letstalk@bandwidth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.bandwidth.sdk.api;

import com.bandwidth.sdk.ApiCallback;
import com.bandwidth.sdk.ApiClient;
import com.bandwidth.sdk.ApiException;
import com.bandwidth.sdk.ApiResponse;
import com.bandwidth.sdk.Configuration;
import com.bandwidth.sdk.Pair;
import com.bandwidth.sdk.ProgressRequestBody;
import com.bandwidth.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.bandwidth.sdk.model.AsyncLookupRequest;
import com.bandwidth.sdk.model.CreateAsyncBulkLookupResponse;
import com.bandwidth.sdk.model.CreateSyncLookupResponse;
import com.bandwidth.sdk.model.GetAsyncBulkLookupResponse;
import com.bandwidth.sdk.model.LookupErrorResponse;
import com.bandwidth.sdk.model.SyncLookupRequest;
import java.util.UUID;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PhoneNumberLookupApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PhoneNumberLookupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PhoneNumberLookupApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createAsyncBulkLookup
     * @param accountId  (required)
     * @param asyncLookupRequest Asynchronous bulk phone number lookup request. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createAsyncBulkLookupCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull AsyncLookupRequest asyncLookupRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.bandwidth.com/v2" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = asyncLookupRequest;

        // create path and map variables
        String localVarPath = "/accounts/{accountId}/phoneNumberLookup/bulk"
            .replace("{" + "accountId" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "Basic", "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createAsyncBulkLookupValidateBeforeCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull AsyncLookupRequest asyncLookupRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createAsyncBulkLookup(Async)");
        }

        // verify the required parameter 'asyncLookupRequest' is set
        if (asyncLookupRequest == null) {
            throw new ApiException("Missing the required parameter 'asyncLookupRequest' when calling createAsyncBulkLookup(Async)");
        }

        return createAsyncBulkLookupCall(accountId, asyncLookupRequest, _callback);

    }

    /**
     * Create Asynchronous Bulk Number Lookup
     * Creates an asynchronous bulk phone number lookup request. Maximum of 15,000 telephone numbers per request. Use the [Get Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/getAsyncBulkLookup) endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param asyncLookupRequest Asynchronous bulk phone number lookup request. (required)
     * @return CreateAsyncBulkLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public CreateAsyncBulkLookupResponse createAsyncBulkLookup(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull AsyncLookupRequest asyncLookupRequest) throws ApiException {
        ApiResponse<CreateAsyncBulkLookupResponse> localVarResp = createAsyncBulkLookupWithHttpInfo(accountId, asyncLookupRequest);
        return localVarResp.getData();
    }

    /**
     * Create Asynchronous Bulk Number Lookup
     * Creates an asynchronous bulk phone number lookup request. Maximum of 15,000 telephone numbers per request. Use the [Get Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/getAsyncBulkLookup) endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param asyncLookupRequest Asynchronous bulk phone number lookup request. (required)
     * @return ApiResponse&lt;CreateAsyncBulkLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateAsyncBulkLookupResponse> createAsyncBulkLookupWithHttpInfo(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull AsyncLookupRequest asyncLookupRequest) throws ApiException {
        okhttp3.Call localVarCall = createAsyncBulkLookupValidateBeforeCall(accountId, asyncLookupRequest, null);
        Type localVarReturnType = new TypeToken<CreateAsyncBulkLookupResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Asynchronous Bulk Number Lookup (asynchronously)
     * Creates an asynchronous bulk phone number lookup request. Maximum of 15,000 telephone numbers per request. Use the [Get Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/getAsyncBulkLookup) endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param asyncLookupRequest Asynchronous bulk phone number lookup request. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createAsyncBulkLookupAsync(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull AsyncLookupRequest asyncLookupRequest, final ApiCallback<CreateAsyncBulkLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = createAsyncBulkLookupValidateBeforeCall(accountId, asyncLookupRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateAsyncBulkLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createSyncLookup
     * @param accountId  (required)
     * @param syncLookupRequest Synchronous phone number lookup request. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSyncLookupCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull SyncLookupRequest syncLookupRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.bandwidth.com/v2" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = syncLookupRequest;

        // create path and map variables
        String localVarPath = "/accounts/{accountId}/phoneNumberLookup"
            .replace("{" + "accountId" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "Basic", "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSyncLookupValidateBeforeCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull SyncLookupRequest syncLookupRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createSyncLookup(Async)");
        }

        // verify the required parameter 'syncLookupRequest' is set
        if (syncLookupRequest == null) {
            throw new ApiException("Missing the required parameter 'syncLookupRequest' when calling createSyncLookup(Async)");
        }

        return createSyncLookupCall(accountId, syncLookupRequest, _callback);

    }

    /**
     * Create Synchronous Number Lookup
     * Creates a synchronous phone number lookup request. Maximum of 100 telephone numbers per request.
     * @param accountId  (required)
     * @param syncLookupRequest Synchronous phone number lookup request. (required)
     * @return CreateSyncLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public CreateSyncLookupResponse createSyncLookup(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull SyncLookupRequest syncLookupRequest) throws ApiException {
        ApiResponse<CreateSyncLookupResponse> localVarResp = createSyncLookupWithHttpInfo(accountId, syncLookupRequest);
        return localVarResp.getData();
    }

    /**
     * Create Synchronous Number Lookup
     * Creates a synchronous phone number lookup request. Maximum of 100 telephone numbers per request.
     * @param accountId  (required)
     * @param syncLookupRequest Synchronous phone number lookup request. (required)
     * @return ApiResponse&lt;CreateSyncLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateSyncLookupResponse> createSyncLookupWithHttpInfo(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull SyncLookupRequest syncLookupRequest) throws ApiException {
        okhttp3.Call localVarCall = createSyncLookupValidateBeforeCall(accountId, syncLookupRequest, null);
        Type localVarReturnType = new TypeToken<CreateSyncLookupResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Synchronous Number Lookup (asynchronously)
     * Creates a synchronous phone number lookup request. Maximum of 100 telephone numbers per request.
     * @param accountId  (required)
     * @param syncLookupRequest Synchronous phone number lookup request. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSyncLookupAsync(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull SyncLookupRequest syncLookupRequest, final ApiCallback<CreateSyncLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = createSyncLookupValidateBeforeCall(accountId, syncLookupRequest, _callback);
        Type localVarReturnType = new TypeToken<CreateSyncLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAsyncBulkLookup
     * @param accountId  (required)
     * @param requestId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAsyncBulkLookupCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull UUID requestId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.bandwidth.com/v2" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/accounts/{accountId}/phoneNumberLookup/bulk/{requestId}"
            .replace("{" + "accountId" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "requestId" + "}", localVarApiClient.escapeString(requestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "Basic", "OAuth2" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAsyncBulkLookupValidateBeforeCall(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull UUID requestId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAsyncBulkLookup(Async)");
        }

        // verify the required parameter 'requestId' is set
        if (requestId == null) {
            throw new ApiException("Missing the required parameter 'requestId' when calling getAsyncBulkLookup(Async)");
        }

        return getAsyncBulkLookupCall(accountId, requestId, _callback);

    }

    /**
     * Get Asynchronous Bulk Number Lookup
     * Get an existing [Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/createAsyncBulkLookup). Use this endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param requestId  (required)
     * @return GetAsyncBulkLookupResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public GetAsyncBulkLookupResponse getAsyncBulkLookup(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull UUID requestId) throws ApiException {
        ApiResponse<GetAsyncBulkLookupResponse> localVarResp = getAsyncBulkLookupWithHttpInfo(accountId, requestId);
        return localVarResp.getData();
    }

    /**
     * Get Asynchronous Bulk Number Lookup
     * Get an existing [Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/createAsyncBulkLookup). Use this endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param requestId  (required)
     * @return ApiResponse&lt;GetAsyncBulkLookupResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetAsyncBulkLookupResponse> getAsyncBulkLookupWithHttpInfo(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull UUID requestId) throws ApiException {
        okhttp3.Call localVarCall = getAsyncBulkLookupValidateBeforeCall(accountId, requestId, null);
        Type localVarReturnType = new TypeToken<GetAsyncBulkLookupResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Asynchronous Bulk Number Lookup (asynchronously)
     * Get an existing [Asynchronous Bulk Number Lookup](#tag/Phone-Number-Lookup/operation/createAsyncBulkLookup). Use this endpoint to check the status of the request and view the results.
     * @param accountId  (required)
     * @param requestId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Bad Request </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAsyncBulkLookupAsync(@javax.annotation.Nonnull String accountId, @javax.annotation.Nonnull UUID requestId, final ApiCallback<GetAsyncBulkLookupResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAsyncBulkLookupValidateBeforeCall(accountId, requestId, _callback);
        Type localVarReturnType = new TypeToken<GetAsyncBulkLookupResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
