

# BridgeCompleteCallback

If the target call leaves the <Bridge>, then this callback is sent to the bridgeCompleteUrl, and the BXML returned in it is executed on the call. If this webhook is sent, the Bridge Target Complete webhook is NOT sent. This callback is also sent if any problem occurs that prevents the calls to be bridged.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**eventType** | **String** | The event type, value can be one of the following: answer, bridgeComplete, bridgeTargetComplete, conferenceCreated, conferenceRedirect, conferenceMemberJoin, conferenceMemberExit, conferenceCompleted, conferenceRecordingAvailable, disconnect, dtmf, gather, initiate, machineDetectionComplete, recordingComplete, recordingAvailable, redirect, transcriptionAvailable, transferAnswer, transferComplete, transferDisconnect. |  [optional] |
|**eventTime** | **OffsetDateTime** | The approximate UTC date and time when the event was generated by the Bandwidth server, in ISO 8601 format. This may not be exactly the time of event execution. |  [optional] |
|**accountId** | **String** | The user account associated with the call. |  [optional] |
|**applicationId** | **String** | The id of the application associated with the call. |  [optional] |
|**from** | **String** | The provided identifier of the caller. Must be a phone number in E.164 format (e.g. +15555555555). |  [optional] |
|**to** | **String** | The phone number that received the call, in E.164 format (e.g. +15555555555). |  [optional] |
|**direction** | **CallDirectionEnum** |  |  [optional] |
|**callId** | **String** | The call id associated with the event. |  [optional] |
|**callUrl** | **URI** | The URL of the call associated with the event. |  [optional] |
|**enqueuedTime** | **OffsetDateTime** | (optional) If call queueing is enabled and this is an outbound call, time the call was queued, in ISO 8601 format. |  [optional] |
|**startTime** | **OffsetDateTime** | Time the call was started, in ISO 8601 format. |  [optional] |
|**answerTime** | **OffsetDateTime** | Time the call was answered, in ISO 8601 format. |  [optional] |
|**tag** | **String** | (optional) The tag specified on call creation. If no tag was specified or it was previously cleared, this field will not be present. |  [optional] |
|**cause** | **String** | Reason the call failed - hangup, busy, timeout, cancel, rejected, callback-error, invalid-bxml, application-error, account-limit, node-capacity-exceeded, error, or unknown. |  [optional] |
|**errorMessage** | **String** | Text explaining the reason that caused the call to fail in case of errors. |  [optional] |
|**errorId** | **String** | Bandwidth&#39;s internal id that references the error event. |  [optional] |



