# bandwidth-sdk

Bandwidth
- API version: 1.0.0
  - Generator version: 7.17.0

Bandwidth's Communication APIs

  For more information, please visit [https://dev.bandwidth.com](https://dev.bandwidth.com)

*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*


## Requirements

Building the API client library requires:
1. Java 1.8+
2. Maven (3.8.3+)/Gradle (7.2+)

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>com.bandwidth.sdk</groupId>
  <artifactId>bandwidth-sdk</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'bandwidth-sdk' jar has been published to maven central.
    mavenLocal()       // Needed if the 'bandwidth-sdk' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "com.bandwidth.sdk:bandwidth-sdk:1.0.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

* `target/bandwidth-sdk-1.0.0.jar`
* `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

// Import classes:
import com.bandwidth.sdk.ApiClient;
import com.bandwidth.sdk.ApiException;
import com.bandwidth.sdk.Configuration;
import com.bandwidth.sdk.auth.*;
import com.bandwidth.sdk.model.*;
import com.bandwidth.sdk.api.CallsApi;

public class Example {
  public static void main(String[] args) {
    ApiClient defaultClient = Configuration.getDefaultApiClient();
    defaultClient.setBasePath("http://localhost");
    
    // Configure HTTP basic authorization: Basic
    HttpBasicAuth Basic = (HttpBasicAuth) defaultClient.getAuthentication("Basic");
    Basic.setUsername("YOUR USERNAME");
    Basic.setPassword("YOUR PASSWORD");

    // Configure OAuth2 access token for authorization: OAuth2
    OAuth OAuth2 = (OAuth) defaultClient.getAuthentication("OAuth2");
    OAuth2.setAccessToken("YOUR ACCESS TOKEN");

    CallsApi apiInstance = new CallsApi(defaultClient);
    // Or create the instance with a your clientId and clientSecret (for OAuth2):
    // CallsApi apiInstance = new CallsApi("YOUR_CLIENT_ID", "YOUR_CLIENT_SECRET", null);

    String accountId = "9900000"; // String | Your Bandwidth Account ID.
    CreateCall createCall = new CreateCall(); // CreateCall | JSON object containing information to create an outbound call
    try {
      CreateCallResponse result = apiInstance.createCall(accountId, createCall);
      System.out.println(result);
    } catch (ApiException e) {
      System.err.println("Exception when calling CallsApi#createCall");
      System.err.println("Status code: " + e.getCode());
      System.err.println("Reason: " + e.getResponseBody());
      System.err.println("Response headers: " + e.getResponseHeaders());
      e.printStackTrace();
    }
  }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CallsApi* | [**createCall**](docs/CallsApi.md#createCall) | **POST** /accounts/{accountId}/calls | Create Call
*CallsApi* | [**getCallState**](docs/CallsApi.md#getCallState) | **GET** /accounts/{accountId}/calls/{callId} | Get Call State Information
*CallsApi* | [**listCalls**](docs/CallsApi.md#listCalls) | **GET** /accounts/{accountId}/calls | Get Calls
*CallsApi* | [**updateCall**](docs/CallsApi.md#updateCall) | **POST** /accounts/{accountId}/calls/{callId} | Update Call
*CallsApi* | [**updateCallBxml**](docs/CallsApi.md#updateCallBxml) | **PUT** /accounts/{accountId}/calls/{callId}/bxml | Update Call BXML
*ConferencesApi* | [**downloadConferenceRecording**](docs/ConferencesApi.md#downloadConferenceRecording) | **GET** /accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId}/media | Download Conference Recording
*ConferencesApi* | [**getConference**](docs/ConferencesApi.md#getConference) | **GET** /accounts/{accountId}/conferences/{conferenceId} | Get Conference Information
*ConferencesApi* | [**getConferenceMember**](docs/ConferencesApi.md#getConferenceMember) | **GET** /accounts/{accountId}/conferences/{conferenceId}/members/{memberId} | Get Conference Member
*ConferencesApi* | [**getConferenceRecording**](docs/ConferencesApi.md#getConferenceRecording) | **GET** /accounts/{accountId}/conferences/{conferenceId}/recordings/{recordingId} | Get Conference Recording Information
*ConferencesApi* | [**listConferenceRecordings**](docs/ConferencesApi.md#listConferenceRecordings) | **GET** /accounts/{accountId}/conferences/{conferenceId}/recordings | Get Conference Recordings
*ConferencesApi* | [**listConferences**](docs/ConferencesApi.md#listConferences) | **GET** /accounts/{accountId}/conferences | Get Conferences
*ConferencesApi* | [**updateConference**](docs/ConferencesApi.md#updateConference) | **POST** /accounts/{accountId}/conferences/{conferenceId} | Update Conference
*ConferencesApi* | [**updateConferenceBxml**](docs/ConferencesApi.md#updateConferenceBxml) | **PUT** /accounts/{accountId}/conferences/{conferenceId}/bxml | Update Conference BXML
*ConferencesApi* | [**updateConferenceMember**](docs/ConferencesApi.md#updateConferenceMember) | **PUT** /accounts/{accountId}/conferences/{conferenceId}/members/{memberId} | Update Conference Member
*MediaApi* | [**deleteMedia**](docs/MediaApi.md#deleteMedia) | **DELETE** /users/{accountId}/media/{mediaId} | Delete Media
*MediaApi* | [**getMedia**](docs/MediaApi.md#getMedia) | **GET** /users/{accountId}/media/{mediaId} | Get Media
*MediaApi* | [**listMedia**](docs/MediaApi.md#listMedia) | **GET** /users/{accountId}/media | List Media
*MediaApi* | [**uploadMedia**](docs/MediaApi.md#uploadMedia) | **PUT** /users/{accountId}/media/{mediaId} | Upload Media
*MessagesApi* | [**createMessage**](docs/MessagesApi.md#createMessage) | **POST** /users/{accountId}/messages | Create Message
*MessagesApi* | [**listMessages**](docs/MessagesApi.md#listMessages) | **GET** /users/{accountId}/messages | List Messages
*MfaApi* | [**generateMessagingCode**](docs/MfaApi.md#generateMessagingCode) | **POST** /accounts/{accountId}/code/messaging | Messaging Authentication Code
*MfaApi* | [**generateVoiceCode**](docs/MfaApi.md#generateVoiceCode) | **POST** /accounts/{accountId}/code/voice | Voice Authentication Code
*MfaApi* | [**verifyCode**](docs/MfaApi.md#verifyCode) | **POST** /accounts/{accountId}/code/verify | Verify Authentication Code
*MultiChannelApi* | [**createMultiChannelMessage**](docs/MultiChannelApi.md#createMultiChannelMessage) | **POST** /users/{accountId}/messages/multiChannel | Create Multi-Channel Message
*PhoneNumberLookupApi* | [**createAsyncBulkLookup**](docs/PhoneNumberLookupApi.md#createAsyncBulkLookup) | **POST** /accounts/{accountId}/phoneNumberLookup/bulk | Create Asynchronous Bulk Number Lookup
*PhoneNumberLookupApi* | [**createSyncLookup**](docs/PhoneNumberLookupApi.md#createSyncLookup) | **POST** /accounts/{accountId}/phoneNumberLookup | Create Synchronous Number Lookup
*PhoneNumberLookupApi* | [**getAsyncBulkLookup**](docs/PhoneNumberLookupApi.md#getAsyncBulkLookup) | **GET** /accounts/{accountId}/phoneNumberLookup/bulk/{requestId} | Get Asynchronous Bulk Number Lookup
*RecordingsApi* | [**deleteRecording**](docs/RecordingsApi.md#deleteRecording) | **DELETE** /accounts/{accountId}/calls/{callId}/recordings/{recordingId} | Delete Recording
*RecordingsApi* | [**deleteRecordingMedia**](docs/RecordingsApi.md#deleteRecordingMedia) | **DELETE** /accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media | Delete Recording Media
*RecordingsApi* | [**deleteRecordingTranscription**](docs/RecordingsApi.md#deleteRecordingTranscription) | **DELETE** /accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription | Delete Transcription
*RecordingsApi* | [**downloadCallRecording**](docs/RecordingsApi.md#downloadCallRecording) | **GET** /accounts/{accountId}/calls/{callId}/recordings/{recordingId}/media | Download Recording
*RecordingsApi* | [**getCallRecording**](docs/RecordingsApi.md#getCallRecording) | **GET** /accounts/{accountId}/calls/{callId}/recordings/{recordingId} | Get Call Recording
*RecordingsApi* | [**getRecordingTranscription**](docs/RecordingsApi.md#getRecordingTranscription) | **GET** /accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription | Get Transcription
*RecordingsApi* | [**listAccountCallRecordings**](docs/RecordingsApi.md#listAccountCallRecordings) | **GET** /accounts/{accountId}/recordings | Get Call Recordings
*RecordingsApi* | [**listCallRecordings**](docs/RecordingsApi.md#listCallRecordings) | **GET** /accounts/{accountId}/calls/{callId}/recordings | List Call Recordings
*RecordingsApi* | [**transcribeCallRecording**](docs/RecordingsApi.md#transcribeCallRecording) | **POST** /accounts/{accountId}/calls/{callId}/recordings/{recordingId}/transcription | Create Transcription Request
*RecordingsApi* | [**updateCallRecordingState**](docs/RecordingsApi.md#updateCallRecordingState) | **PUT** /accounts/{accountId}/calls/{callId}/recording | Update Recording
*StatisticsApi* | [**getStatistics**](docs/StatisticsApi.md#getStatistics) | **GET** /accounts/{accountId}/statistics | Get Account Statistics
*TollFreeVerificationApi* | [**createWebhookSubscription**](docs/TollFreeVerificationApi.md#createWebhookSubscription) | **POST** /accounts/{accountId}/tollFreeVerification/webhooks/subscriptions | Create Webhook Subscription
*TollFreeVerificationApi* | [**deleteVerificationRequest**](docs/TollFreeVerificationApi.md#deleteVerificationRequest) | **DELETE** /accounts/{accountId}/phoneNumbers/{phoneNumber}/tollFreeVerification | Delete a Toll-Free Verification Submission
*TollFreeVerificationApi* | [**deleteWebhookSubscription**](docs/TollFreeVerificationApi.md#deleteWebhookSubscription) | **DELETE** /accounts/{accountId}/tollFreeVerification/webhooks/subscriptions/{id} | Delete Webhook Subscription
*TollFreeVerificationApi* | [**getTollFreeVerificationStatus**](docs/TollFreeVerificationApi.md#getTollFreeVerificationStatus) | **GET** /accounts/{accountId}/phoneNumbers/{phoneNumber}/tollFreeVerification | Get Toll-Free Verification Status
*TollFreeVerificationApi* | [**listTollFreeUseCases**](docs/TollFreeVerificationApi.md#listTollFreeUseCases) | **GET** /tollFreeVerification/useCases | List Toll-Free Use Cases
*TollFreeVerificationApi* | [**listWebhookSubscriptions**](docs/TollFreeVerificationApi.md#listWebhookSubscriptions) | **GET** /accounts/{accountId}/tollFreeVerification/webhooks/subscriptions | List Webhook Subscriptions
*TollFreeVerificationApi* | [**requestTollFreeVerification**](docs/TollFreeVerificationApi.md#requestTollFreeVerification) | **POST** /accounts/{accountId}/tollFreeVerification | Request Toll-Free Verification
*TollFreeVerificationApi* | [**updateTollFreeVerificationRequest**](docs/TollFreeVerificationApi.md#updateTollFreeVerificationRequest) | **PUT** /accounts/{accountId}/phoneNumbers/{phoneNumber}/tollFreeVerification | Update Toll-Free Verification Request
*TollFreeVerificationApi* | [**updateWebhookSubscription**](docs/TollFreeVerificationApi.md#updateWebhookSubscription) | **PUT** /accounts/{accountId}/tollFreeVerification/webhooks/subscriptions/{id} | Update Webhook Subscription
*TranscriptionsApi* | [**deleteRealTimeTranscription**](docs/TranscriptionsApi.md#deleteRealTimeTranscription) | **DELETE** /accounts/{accountId}/calls/{callId}/transcriptions/{transcriptionId} | Delete Real-time Transcription
*TranscriptionsApi* | [**getRealTimeTranscription**](docs/TranscriptionsApi.md#getRealTimeTranscription) | **GET** /accounts/{accountId}/calls/{callId}/transcriptions/{transcriptionId} | Get Real-time Transcription
*TranscriptionsApi* | [**listRealTimeTranscriptions**](docs/TranscriptionsApi.md#listRealTimeTranscriptions) | **GET** /accounts/{accountId}/calls/{callId}/transcriptions | List Real-time Transcriptions


## Documentation for Models

 - [AccountStatistics](docs/AccountStatistics.md)
 - [AdditionalDenialReason](docs/AdditionalDenialReason.md)
 - [Address](docs/Address.md)
 - [AnswerCallback](docs/AnswerCallback.md)
 - [AsyncLookupRequest](docs/AsyncLookupRequest.md)
 - [BlockedWebhook](docs/BlockedWebhook.md)
 - [BridgeCompleteCallback](docs/BridgeCompleteCallback.md)
 - [BridgeTargetCompleteCallback](docs/BridgeTargetCompleteCallback.md)
 - [BusinessEntityTypeEnum](docs/BusinessEntityTypeEnum.md)
 - [BusinessRegistrationTypeEnum](docs/BusinessRegistrationTypeEnum.md)
 - [CallDirectionEnum](docs/CallDirectionEnum.md)
 - [CallRecordingMetadata](docs/CallRecordingMetadata.md)
 - [CallState](docs/CallState.md)
 - [CallStateEnum](docs/CallStateEnum.md)
 - [CallTranscription](docs/CallTranscription.md)
 - [CallTranscriptionDetectedLanguageEnum](docs/CallTranscriptionDetectedLanguageEnum.md)
 - [CallTranscriptionMetadata](docs/CallTranscriptionMetadata.md)
 - [CallTranscriptionResponse](docs/CallTranscriptionResponse.md)
 - [CallTranscriptionTrackEnum](docs/CallTranscriptionTrackEnum.md)
 - [Callback](docs/Callback.md)
 - [CallbackMethodEnum](docs/CallbackMethodEnum.md)
 - [CardWidthEnum](docs/CardWidthEnum.md)
 - [CodeRequest](docs/CodeRequest.md)
 - [CompletedLookupStatusEnum](docs/CompletedLookupStatusEnum.md)
 - [Conference](docs/Conference.md)
 - [ConferenceCompletedCallback](docs/ConferenceCompletedCallback.md)
 - [ConferenceCreatedCallback](docs/ConferenceCreatedCallback.md)
 - [ConferenceMember](docs/ConferenceMember.md)
 - [ConferenceMemberExitCallback](docs/ConferenceMemberExitCallback.md)
 - [ConferenceMemberJoinCallback](docs/ConferenceMemberJoinCallback.md)
 - [ConferenceRecordingAvailableCallback](docs/ConferenceRecordingAvailableCallback.md)
 - [ConferenceRecordingMetadata](docs/ConferenceRecordingMetadata.md)
 - [ConferenceRedirectCallback](docs/ConferenceRedirectCallback.md)
 - [ConferenceStateEnum](docs/ConferenceStateEnum.md)
 - [Contact](docs/Contact.md)
 - [CreateAsyncBulkLookupResponse](docs/CreateAsyncBulkLookupResponse.md)
 - [CreateAsyncBulkLookupResponseData](docs/CreateAsyncBulkLookupResponseData.md)
 - [CreateCall](docs/CreateCall.md)
 - [CreateCallResponse](docs/CreateCallResponse.md)
 - [CreateMessageRequestError](docs/CreateMessageRequestError.md)
 - [CreateMultiChannelMessageResponse](docs/CreateMultiChannelMessageResponse.md)
 - [CreateSyncLookupResponse](docs/CreateSyncLookupResponse.md)
 - [CreateSyncLookupResponseData](docs/CreateSyncLookupResponseData.md)
 - [DeactivationEventEnum](docs/DeactivationEventEnum.md)
 - [DisconnectCallback](docs/DisconnectCallback.md)
 - [Diversion](docs/Diversion.md)
 - [DtmfCallback](docs/DtmfCallback.md)
 - [Error](docs/Error.md)
 - [ErrorObject](docs/ErrorObject.md)
 - [ErrorSource](docs/ErrorSource.md)
 - [FailureWebhook](docs/FailureWebhook.md)
 - [FieldError](docs/FieldError.md)
 - [FileFormatEnum](docs/FileFormatEnum.md)
 - [GatherCallback](docs/GatherCallback.md)
 - [GetAsyncBulkLookupResponse](docs/GetAsyncBulkLookupResponse.md)
 - [GetAsyncBulkLookupResponseData](docs/GetAsyncBulkLookupResponseData.md)
 - [InProgressLookupStatusEnum](docs/InProgressLookupStatusEnum.md)
 - [InboundCallback](docs/InboundCallback.md)
 - [InboundCallbackMessage](docs/InboundCallbackMessage.md)
 - [InboundCallbackTypeEnum](docs/InboundCallbackTypeEnum.md)
 - [InitiateCallback](docs/InitiateCallback.md)
 - [LatestMessageDeliveryStatusEnum](docs/LatestMessageDeliveryStatusEnum.md)
 - [LineTypeEnum](docs/LineTypeEnum.md)
 - [Link](docs/Link.md)
 - [LinkSchema](docs/LinkSchema.md)
 - [LinksObject](docs/LinksObject.md)
 - [ListMessageDirectionEnum](docs/ListMessageDirectionEnum.md)
 - [ListMessageItem](docs/ListMessageItem.md)
 - [LookupErrorResponse](docs/LookupErrorResponse.md)
 - [LookupErrorSchema](docs/LookupErrorSchema.md)
 - [LookupErrorSchemaMeta](docs/LookupErrorSchemaMeta.md)
 - [LookupResult](docs/LookupResult.md)
 - [MachineDetectionCompleteCallback](docs/MachineDetectionCompleteCallback.md)
 - [MachineDetectionConfiguration](docs/MachineDetectionConfiguration.md)
 - [MachineDetectionModeEnum](docs/MachineDetectionModeEnum.md)
 - [MachineDetectionResult](docs/MachineDetectionResult.md)
 - [Media](docs/Media.md)
 - [Message](docs/Message.md)
 - [MessageDirectionEnum](docs/MessageDirectionEnum.md)
 - [MessageRequest](docs/MessageRequest.md)
 - [MessageStatusEnum](docs/MessageStatusEnum.md)
 - [MessageTypeEnum](docs/MessageTypeEnum.md)
 - [MessagesList](docs/MessagesList.md)
 - [MessagingCodeResponse](docs/MessagingCodeResponse.md)
 - [MessagingRequestError](docs/MessagingRequestError.md)
 - [MfaForbiddenRequestError](docs/MfaForbiddenRequestError.md)
 - [MfaRequestError](docs/MfaRequestError.md)
 - [MfaUnauthorizedRequestError](docs/MfaUnauthorizedRequestError.md)
 - [MmsMessageContent](docs/MmsMessageContent.md)
 - [MmsMessageContentFile](docs/MmsMessageContentFile.md)
 - [MultiChannelAction](docs/MultiChannelAction.md)
 - [MultiChannelActionCalendarEvent](docs/MultiChannelActionCalendarEvent.md)
 - [MultiChannelChannelListMMSObject](docs/MultiChannelChannelListMMSObject.md)
 - [MultiChannelChannelListMMSResponseObject](docs/MultiChannelChannelListMMSResponseObject.md)
 - [MultiChannelChannelListObjectBase](docs/MultiChannelChannelListObjectBase.md)
 - [MultiChannelChannelListOwnerObject](docs/MultiChannelChannelListOwnerObject.md)
 - [MultiChannelChannelListRBMObject](docs/MultiChannelChannelListRBMObject.md)
 - [MultiChannelChannelListRBMObjectAllOfContent](docs/MultiChannelChannelListRBMObjectAllOfContent.md)
 - [MultiChannelChannelListRBMResponseObject](docs/MultiChannelChannelListRBMResponseObject.md)
 - [MultiChannelChannelListRequestObject](docs/MultiChannelChannelListRequestObject.md)
 - [MultiChannelChannelListResponseObject](docs/MultiChannelChannelListResponseObject.md)
 - [MultiChannelChannelListSMSObject](docs/MultiChannelChannelListSMSObject.md)
 - [MultiChannelChannelListSMSResponseObject](docs/MultiChannelChannelListSMSResponseObject.md)
 - [MultiChannelError](docs/MultiChannelError.md)
 - [MultiChannelMessageChannelEnum](docs/MultiChannelMessageChannelEnum.md)
 - [MultiChannelMessageContent](docs/MultiChannelMessageContent.md)
 - [MultiChannelMessageRequest](docs/MultiChannelMessageRequest.md)
 - [MultiChannelMessageResponseData](docs/MultiChannelMessageResponseData.md)
 - [OptInWorkflow](docs/OptInWorkflow.md)
 - [PageInfo](docs/PageInfo.md)
 - [PriorityEnum](docs/PriorityEnum.md)
 - [ProductTypeEnum](docs/ProductTypeEnum.md)
 - [RbmActionBase](docs/RbmActionBase.md)
 - [RbmActionDial](docs/RbmActionDial.md)
 - [RbmActionOpenUrl](docs/RbmActionOpenUrl.md)
 - [RbmActionTypeEnum](docs/RbmActionTypeEnum.md)
 - [RbmActionViewLocation](docs/RbmActionViewLocation.md)
 - [RbmCardContent](docs/RbmCardContent.md)
 - [RbmCardContentMedia](docs/RbmCardContentMedia.md)
 - [RbmLocationResponse](docs/RbmLocationResponse.md)
 - [RbmMediaHeightEnum](docs/RbmMediaHeightEnum.md)
 - [RbmMessageCarouselCard](docs/RbmMessageCarouselCard.md)
 - [RbmMessageContentFile](docs/RbmMessageContentFile.md)
 - [RbmMessageContentRichCard](docs/RbmMessageContentRichCard.md)
 - [RbmMessageContentText](docs/RbmMessageContentText.md)
 - [RbmMessageMedia](docs/RbmMessageMedia.md)
 - [RbmOpenUrlEnum](docs/RbmOpenUrlEnum.md)
 - [RbmStandaloneCard](docs/RbmStandaloneCard.md)
 - [RbmSuggestionResponse](docs/RbmSuggestionResponse.md)
 - [RbmWebViewEnum](docs/RbmWebViewEnum.md)
 - [RecordingAvailableCallback](docs/RecordingAvailableCallback.md)
 - [RecordingCompleteCallback](docs/RecordingCompleteCallback.md)
 - [RecordingStateEnum](docs/RecordingStateEnum.md)
 - [RecordingTranscriptionMetadata](docs/RecordingTranscriptionMetadata.md)
 - [RecordingTranscriptions](docs/RecordingTranscriptions.md)
 - [RedirectCallback](docs/RedirectCallback.md)
 - [RedirectMethodEnum](docs/RedirectMethodEnum.md)
 - [SmsMessageContent](docs/SmsMessageContent.md)
 - [StandaloneCardOrientationEnum](docs/StandaloneCardOrientationEnum.md)
 - [StatusCallback](docs/StatusCallback.md)
 - [StatusCallbackMessage](docs/StatusCallbackMessage.md)
 - [StatusCallbackTypeEnum](docs/StatusCallbackTypeEnum.md)
 - [StirShaken](docs/StirShaken.md)
 - [SyncLookupRequest](docs/SyncLookupRequest.md)
 - [TelephoneNumber](docs/TelephoneNumber.md)
 - [TfvBasicAuthentication](docs/TfvBasicAuthentication.md)
 - [TfvCallbackStatusEnum](docs/TfvCallbackStatusEnum.md)
 - [TfvError](docs/TfvError.md)
 - [TfvStatus](docs/TfvStatus.md)
 - [TfvStatusEnum](docs/TfvStatusEnum.md)
 - [TfvSubmissionInfo](docs/TfvSubmissionInfo.md)
 - [TfvSubmissionWrapper](docs/TfvSubmissionWrapper.md)
 - [ThumbnailAlignmentEnum](docs/ThumbnailAlignmentEnum.md)
 - [TranscribeRecording](docs/TranscribeRecording.md)
 - [Transcription](docs/Transcription.md)
 - [TranscriptionAvailableCallback](docs/TranscriptionAvailableCallback.md)
 - [TransferAnswerCallback](docs/TransferAnswerCallback.md)
 - [TransferCompleteCallback](docs/TransferCompleteCallback.md)
 - [TransferDisconnectCallback](docs/TransferDisconnectCallback.md)
 - [UpdateCall](docs/UpdateCall.md)
 - [UpdateCallRecording](docs/UpdateCallRecording.md)
 - [UpdateConference](docs/UpdateConference.md)
 - [UpdateConferenceMember](docs/UpdateConferenceMember.md)
 - [VerificationDenialWebhook](docs/VerificationDenialWebhook.md)
 - [VerificationRequest](docs/VerificationRequest.md)
 - [VerificationUpdateRequest](docs/VerificationUpdateRequest.md)
 - [VerificationWebhook](docs/VerificationWebhook.md)
 - [VerifyCodeRequest](docs/VerifyCodeRequest.md)
 - [VerifyCodeResponse](docs/VerifyCodeResponse.md)
 - [VoiceApiError](docs/VoiceApiError.md)
 - [VoiceCodeResponse](docs/VoiceCodeResponse.md)
 - [WebhookSubscription](docs/WebhookSubscription.md)
 - [WebhookSubscriptionBasicAuthentication](docs/WebhookSubscriptionBasicAuthentication.md)
 - [WebhookSubscriptionRequestSchema](docs/WebhookSubscriptionRequestSchema.md)
 - [WebhookSubscriptionTypeEnum](docs/WebhookSubscriptionTypeEnum.md)
 - [WebhookSubscriptionsListBody](docs/WebhookSubscriptionsListBody.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="Basic"></a>
### Basic

- **Type**: HTTP basic authentication

<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author

letstalk@bandwidth.com

