
/*
 *
 *  * The MIT License
 *  *
 *  * Copyright 2016 Shekhar Gulati <shekhargulati84@gmail.com>.
 *  *
 *  * Permission is hereby granted, free of charge, to any person obtaining a copy
 *  * of this software and associated documentation files (the "Software"), to deal
 *  * in the Software without restriction, including without limitation the rights
 *  * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  * copies of the Software, and to permit persons to whom the Software is
 *  * furnished to do so, subject to the following conditions:
 *  *
 *  * The above copyright notice and this permission notice shall be included in
 *  * all copies or substantial portions of the Software.
 *  *
 *  * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  * THE SOFTWARE.
 *
 */

package strman;

import java.util.HashMap;
import java.util.Map;

abstract class HtmlEntities {
    public static final Map<String, String> decodedEntities = new HashMap<String, String>() {
        {
            put("&AElig", "\u00C6");
            put("&AElig;", "\u00C6");
            put("&AMP", "\u0026");
            put("&AMP;", "\u0026");
            put("&Aacute", "\u00C1");
            put("&Aacute;", "\u00C1");
            put("&Abreve;", "\u0102");
            put("&Acirc", "\u00C2");
            put("&Acirc;", "\u00C2");
            put("&Acy;", "\u0410");
            put("&Afr;", "\uD835\uDD04");
            put("&Agrave", "\u00C0");
            put("&Agrave;", "\u00C0");
            put("&Alpha;", "\u0391");
            put("&Amacr;", "\u0100");
            put("&And;", "\u2A53");
            put("&Aogon;", "\u0104");
            put("&Aopf;", "\uD835\uDD38");
            put("&ApplyFunction;", "\u2061");
            put("&Aring", "\u00C5");
            put("&Aring;", "\u00C5");
            put("&Ascr;", "\uD835\uDC9C");
            put("&Assign;", "\u2254");
            put("&Atilde", "\u00C3");
            put("&Atilde;", "\u00C3");
            put("&Auml", "\u00C4");
            put("&Auml;", "\u00C4");
            put("&Backslash;", "\u2216");
            put("&Barv;", "\u2AE7");
            put("&Barwed;", "\u2306");
            put("&Bcy;", "\u0411");
            put("&Because;", "\u2235");
            put("&Bernoullis;", "\u212C");
            put("&Beta;", "\u0392");
            put("&Bfr;", "\uD835\uDD05");
            put("&Bopf;", "\uD835\uDD39");
            put("&Breve;", "\u02D8");
            put("&Bscr;", "\u212C");
            put("&Bumpeq;", "\u224E");
            put("&CHcy;", "\u0427");
            put("&COPY", "\u00A9");
            put("&COPY;", "\u00A9");
            put("&Cacute;", "\u0106");
            put("&Cap;", "\u22D2");
            put("&CapitalDifferentialD;", "\u2145");
            put("&Cayleys;", "\u212D");
            put("&Ccaron;", "\u010C");
            put("&Ccedil", "\u00C7");
            put("&Ccedil;", "\u00C7");
            put("&Ccirc;", "\u0108");
            put("&Cconint;", "\u2230");
            put("&Cdot;", "\u010A");
            put("&Cedilla;", "\u00B8");
            put("&CenterDot;", "\u00B7");
            put("&Cfr;", "\u212D");
            put("&Chi;", "\u03A7");
            put("&CircleDot;", "\u2299");
            put("&CircleMinus;", "\u2296");
            put("&CirclePlus;", "\u2295");
            put("&CircleTimes;", "\u2297");
            put("&ClockwiseContourIntegral;", "\u2232");
            put("&CloseCurlyDoubleQuote;", "\u201D");
            put("&CloseCurlyQuote;", "\u2019");
            put("&Colon;", "\u2237");
            put("&Colone;", "\u2A74");
            put("&Congruent;", "\u2261");
            put("&Conint;", "\u222F");
            put("&ContourIntegral;", "\u222E");
            put("&Copf;", "\u2102");
            put("&Coproduct;", "\u2210");
            put("&CounterClockwiseContourIntegral;", "\u2233");
            put("&Cross;", "\u2A2F");
            put("&Cscr;", "\uD835\uDC9E");
            put("&Cup;", "\u22D3");
            put("&CupCap;", "\u224D");
            put("&DD;", "\u2145");
            put("&DDotrahd;", "\u2911");
            put("&DJcy;", "\u0402");
            put("&DScy;", "\u0405");
            put("&DZcy;", "\u040F");
            put("&Dagger;", "\u2021");
            put("&Darr;", "\u21A1");
            put("&Dashv;", "\u2AE4");
            put("&Dcaron;", "\u010E");
            put("&Dcy;", "\u0414");
            put("&Del;", "\u2207");
            put("&Delta;", "\u0394");
            put("&Dfr;", "\uD835\uDD07");
            put("&DiacriticalAcute;", "\u00B4");
            put("&DiacriticalDot;", "\u02D9");
            put("&DiacriticalDoubleAcute;", "\u02DD");
            put("&DiacriticalGrave;", "\u0060");
            put("&DiacriticalTilde;", "\u02DC");
            put("&Diamond;", "\u22C4");
            put("&DifferentialD;", "\u2146");
            put("&Dopf;", "\uD835\uDD3B");
            put("&Dot;", "\u00A8");
            put("&DotDot;", "\u20DC");
            put("&DotEqual;", "\u2250");
            put("&DoubleContourIntegral;", "\u222F");
            put("&DoubleDot;", "\u00A8");
            put("&DoubleDownArrow;", "\u21D3");
            put("&DoubleLeftArrow;", "\u21D0");
            put("&DoubleLeftRightArrow;", "\u21D4");
            put("&DoubleLeftTee;", "\u2AE4");
            put("&DoubleLongLeftArrow;", "\u27F8");
            put("&DoubleLongLeftRightArrow;", "\u27FA");
            put("&DoubleLongRightArrow;", "\u27F9");
            put("&DoubleRightArrow;", "\u21D2");
            put("&DoubleRightTee;", "\u22A8");
            put("&DoubleUpArrow;", "\u21D1");
            put("&DoubleUpDownArrow;", "\u21D5");
            put("&DoubleVerticalBar;", "\u2225");
            put("&DownArrow;", "\u2193");
            put("&DownArrowBar;", "\u2913");
            put("&DownArrowUpArrow;", "\u21F5");
            put("&DownBreve;", "\u0311");
            put("&DownLeftRightVector;", "\u2950");
            put("&DownLeftTeeVector;", "\u295E");
            put("&DownLeftVector;", "\u21BD");
            put("&DownLeftVectorBar;", "\u2956");
            put("&DownRightTeeVector;", "\u295F");
            put("&DownRightVector;", "\u21C1");
            put("&DownRightVectorBar;", "\u2957");
            put("&DownTee;", "\u22A4");
            put("&DownTeeArrow;", "\u21A7");
            put("&Downarrow;", "\u21D3");
            put("&Dscr;", "\uD835\uDC9F");
            put("&Dstrok;", "\u0110");
            put("&ENG;", "\u014A");
            put("&ETH", "\u00D0");
            put("&ETH;", "\u00D0");
            put("&Eacute", "\u00C9");
            put("&Eacute;", "\u00C9");
            put("&Ecaron;", "\u011A");
            put("&Ecirc", "\u00CA");
            put("&Ecirc;", "\u00CA");
            put("&Ecy;", "\u042D");
            put("&Edot;", "\u0116");
            put("&Efr;", "\uD835\uDD08");
            put("&Egrave", "\u00C8");
            put("&Egrave;", "\u00C8");
            put("&Element;", "\u2208");
            put("&Emacr;", "\u0112");
            put("&EmptySmallSquare;", "\u25FB");
            put("&EmptyVerySmallSquare;", "\u25AB");
            put("&Eogon;", "\u0118");
            put("&Eopf;", "\uD835\uDD3C");
            put("&Epsilon;", "\u0395");
            put("&Equal;", "\u2A75");
            put("&EqualTilde;", "\u2242");
            put("&Equilibrium;", "\u21CC");
            put("&Escr;", "\u2130");
            put("&Esim;", "\u2A73");
            put("&Eta;", "\u0397");
            put("&Euml", "\u00CB");
            put("&Euml;", "\u00CB");
            put("&Exists;", "\u2203");
            put("&ExponentialE;", "\u2147");
            put("&Fcy;", "\u0424");
            put("&Ffr;", "\uD835\uDD09");
            put("&FilledSmallSquare;", "\u25FC");
            put("&FilledVerySmallSquare;", "\u25AA");
            put("&Fopf;", "\uD835\uDD3D");
            put("&ForAll;", "\u2200");
            put("&Fouriertrf;", "\u2131");
            put("&Fscr;", "\u2131");
            put("&GJcy;", "\u0403");
            put("&GT", "\u003E");
            put("&GT;", "\u003E");
            put("&Gamma;", "\u0393");
            put("&Gammad;", "\u03DC");
            put("&Gbreve;", "\u011E");
            put("&Gcedil;", "\u0122");
            put("&Gcirc;", "\u011C");
            put("&Gcy;", "\u0413");
            put("&Gdot;", "\u0120");
            put("&Gfr;", "\uD835\uDD0A");
            put("&Gg;", "\u22D9");
            put("&Gopf;", "\uD835\uDD3E");
            put("&GreaterEqual;", "\u2265");
            put("&GreaterEqualLess;", "\u22DB");
            put("&GreaterFullEqual;", "\u2267");
            put("&GreaterGreater;", "\u2AA2");
            put("&GreaterLess;", "\u2277");
            put("&GreaterSlantEqual;", "\u2A7E");
            put("&GreaterTilde;", "\u2273");
            put("&Gscr;", "\uD835\uDCA2");
            put("&Gt;", "\u226B");
            put("&HARDcy;", "\u042A");
            put("&Hacek;", "\u02C7");
            put("&Hat;", "\u005E");
            put("&Hcirc;", "\u0124");
            put("&Hfr;", "\u210C");
            put("&HilbertSpace;", "\u210B");
            put("&Hopf;", "\u210D");
            put("&HorizontalLine;", "\u2500");
            put("&Hscr;", "\u210B");
            put("&Hstrok;", "\u0126");
            put("&HumpDownHump;", "\u224E");
            put("&HumpEqual;", "\u224F");
            put("&IEcy;", "\u0415");
            put("&IJlig;", "\u0132");
            put("&IOcy;", "\u0401");
            put("&Iacute", "\u00CD");
            put("&Iacute;", "\u00CD");
            put("&Icirc", "\u00CE");
            put("&Icirc;", "\u00CE");
            put("&Icy;", "\u0418");
            put("&Idot;", "\u0130");
            put("&Ifr;", "\u2111");
            put("&Igrave", "\u00CC");
            put("&Igrave;", "\u00CC");
            put("&Im;", "\u2111");
            put("&Imacr;", "\u012A");
            put("&ImaginaryI;", "\u2148");
            put("&Implies;", "\u21D2");
            put("&Int;", "\u222C");
            put("&Integral;", "\u222B");
            put("&Intersection;", "\u22C2");
            put("&InvisibleComma;", "\u2063");
            put("&InvisibleTimes;", "\u2062");
            put("&Iogon;", "\u012E");
            put("&Iopf;", "\uD835\uDD40");
            put("&Iota;", "\u0399");
            put("&Iscr;", "\u2110");
            put("&Itilde;", "\u0128");
            put("&Iukcy;", "\u0406");
            put("&Iuml", "\u00CF");
            put("&Iuml;", "\u00CF");
            put("&Jcirc;", "\u0134");
            put("&Jcy;", "\u0419");
            put("&Jfr;", "\uD835\uDD0D");
            put("&Jopf;", "\uD835\uDD41");
            put("&Jscr;", "\uD835\uDCA5");
            put("&Jsercy;", "\u0408");
            put("&Jukcy;", "\u0404");
            put("&KHcy;", "\u0425");
            put("&KJcy;", "\u040C");
            put("&Kappa;", "\u039A");
            put("&Kcedil;", "\u0136");
            put("&Kcy;", "\u041A");
            put("&Kfr;", "\uD835\uDD0E");
            put("&Kopf;", "\uD835\uDD42");
            put("&Kscr;", "\uD835\uDCA6");
            put("&LJcy;", "\u0409");
            put("&LT", "\u003C");
            put("&LT;", "\u003C");
            put("&Lacute;", "\u0139");
            put("&Lambda;", "\u039B");
            put("&Lang;", "\u27EA");
            put("&Laplacetrf;", "\u2112");
            put("&Larr;", "\u219E");
            put("&Lcaron;", "\u013D");
            put("&Lcedil;", "\u013B");
            put("&Lcy;", "\u041B");
            put("&LeftAngleBracket;", "\u27E8");
            put("&LeftArrow;", "\u2190");
            put("&LeftArrowBar;", "\u21E4");
            put("&LeftArrowRightArrow;", "\u21C6");
            put("&LeftCeiling;", "\u2308");
            put("&LeftDoubleBracket;", "\u27E6");
            put("&LeftDownTeeVector;", "\u2961");
            put("&LeftDownVector;", "\u21C3");
            put("&LeftDownVectorBar;", "\u2959");
            put("&LeftFloor;", "\u230A");
            put("&LeftRightArrow;", "\u2194");
            put("&LeftRightVector;", "\u294E");
            put("&LeftTee;", "\u22A3");
            put("&LeftTeeArrow;", "\u21A4");
            put("&LeftTeeVector;", "\u295A");
            put("&LeftTriangle;", "\u22B2");
            put("&LeftTriangleBar;", "\u29CF");
            put("&LeftTriangleEqual;", "\u22B4");
            put("&LeftUpDownVector;", "\u2951");
            put("&LeftUpTeeVector;", "\u2960");
            put("&LeftUpVector;", "\u21BF");
            put("&LeftUpVectorBar;", "\u2958");
            put("&LeftVector;", "\u21BC");
            put("&LeftVectorBar;", "\u2952");
            put("&Leftarrow;", "\u21D0");
            put("&Leftrightarrow;", "\u21D4");
            put("&LessEqualGreater;", "\u22DA");
            put("&LessFullEqual;", "\u2266");
            put("&LessGreater;", "\u2276");
            put("&LessLess;", "\u2AA1");
            put("&LessSlantEqual;", "\u2A7D");
            put("&LessTilde;", "\u2272");
            put("&Lfr;", "\uD835\uDD0F");
            put("&Ll;", "\u22D8");
            put("&Lleftarrow;", "\u21DA");
            put("&Lmidot;", "\u013F");
            put("&LongLeftArrow;", "\u27F5");
            put("&LongLeftRightArrow;", "\u27F7");
            put("&LongRightArrow;", "\u27F6");
            put("&Longleftarrow;", "\u27F8");
            put("&Longleftrightarrow;", "\u27FA");
            put("&Longrightarrow;", "\u27F9");
            put("&Lopf;", "\uD835\uDD43");
            put("&LowerLeftArrow;", "\u2199");
            put("&LowerRightArrow;", "\u2198");
            put("&Lscr;", "\u2112");
            put("&Lsh;", "\u21B0");
            put("&Lstrok;", "\u0141");
            put("&Lt;", "\u226A");
            put("&Map;", "\u2905");
            put("&Mcy;", "\u041C");
            put("&MediumSpace;", "\u205F");
            put("&Mellintrf;", "\u2133");
            put("&Mfr;", "\uD835\uDD10");
            put("&MinusPlus;", "\u2213");
            put("&Mopf;", "\uD835\uDD44");
            put("&Mscr;", "\u2133");
            put("&Mu;", "\u039C");
            put("&NJcy;", "\u040A");
            put("&Nacute;", "\u0143");
            put("&Ncaron;", "\u0147");
            put("&Ncedil;", "\u0145");
            put("&Ncy;", "\u041D");
            put("&NegativeMediumSpace;", "\u200B");
            put("&NegativeThickSpace;", "\u200B");
            put("&NegativeThinSpace;", "\u200B");
            put("&NegativeVeryThinSpace;", "\u200B");
            put("&NestedGreaterGreater;", "\u226B");
            put("&NestedLessLess;", "\u226A");
            put("&NewLine;", "\\u000A");
            put("&Nfr;", "\uD835\uDD11");
            put("&NoBreak;", "\u2060");
            put("&NonBreakingSpace;", "\u00A0");
            put("&Nopf;", "\u2115");
            put("&Not;", "\u2AEC");
            put("&NotCongruent;", "\u2262");
            put("&NotCupCap;", "\u226D");
            put("&NotDoubleVerticalBar;", "\u2226");
            put("&NotElement;", "\u2209");
            put("&NotEqual;", "\u2260");
            put("&NotEqualTilde;", "\u2242\u0338");
            put("&NotExists;", "\u2204");
            put("&NotGreater;", "\u226F");
            put("&NotGreaterEqual;", "\u2271");
            put("&NotGreaterFullEqual;", "\u2267\u0338");
            put("&NotGreaterGreater;", "\u226B\u0338");
            put("&NotGreaterLess;", "\u2279");
            put("&NotGreaterSlantEqual;", "\u2A7E\u0338");
            put("&NotGreaterTilde;", "\u2275");
            put("&NotHumpDownHump;", "\u224E\u0338");
            put("&NotHumpEqual;", "\u224F\u0338");
            put("&NotLeftTriangle;", "\u22EA");
            put("&NotLeftTriangleBar;", "\u29CF\u0338");
            put("&NotLeftTriangleEqual;", "\u22EC");
            put("&NotLess;", "\u226E");
            put("&NotLessEqual;", "\u2270");
            put("&NotLessGreater;", "\u2278");
            put("&NotLessLess;", "\u226A\u0338");
            put("&NotLessSlantEqual;", "\u2A7D\u0338");
            put("&NotLessTilde;", "\u2274");
            put("&NotNestedGreaterGreater;", "\u2AA2\u0338");
            put("&NotNestedLessLess;", "\u2AA1\u0338");
            put("&NotPrecedes;", "\u2280");
            put("&NotPrecedesEqual;", "\u2AAF\u0338");
            put("&NotPrecedesSlantEqual;", "\u22E0");
            put("&NotReverseElement;", "\u220C");
            put("&NotRightTriangle;", "\u22EB");
            put("&NotRightTriangleBar;", "\u29D0\u0338");
            put("&NotRightTriangleEqual;", "\u22ED");
            put("&NotSquareSubset;", "\u228F\u0338");
            put("&NotSquareSubsetEqual;", "\u22E2");
            put("&NotSquareSuperset;", "\u2290\u0338");
            put("&NotSquareSupersetEqual;", "\u22E3");
            put("&NotSubset;", "\u2282\u20D2");
            put("&NotSubsetEqual;", "\u2288");
            put("&NotSucceeds;", "\u2281");
            put("&NotSucceedsEqual;", "\u2AB0\u0338");
            put("&NotSucceedsSlantEqual;", "\u22E1");
            put("&NotSucceedsTilde;", "\u227F\u0338");
            put("&NotSuperset;", "\u2283\u20D2");
            put("&NotSupersetEqual;", "\u2289");
            put("&NotTilde;", "\u2241");
            put("&NotTildeEqual;", "\u2244");
            put("&NotTildeFullEqual;", "\u2247");
            put("&NotTildeTilde;", "\u2249");
            put("&NotVerticalBar;", "\u2224");
            put("&Nscr;", "\uD835\uDCA9");
            put("&Ntilde", "\u00D1");
            put("&Ntilde;", "\u00D1");
            put("&Nu;", "\u039D");
            put("&OElig;", "\u0152");
            put("&Oacute", "\u00D3");
            put("&Oacute;", "\u00D3");
            put("&Ocirc", "\u00D4");
            put("&Ocirc;", "\u00D4");
            put("&Ocy;", "\u041E");
            put("&Odblac;", "\u0150");
            put("&Ofr;", "\uD835\uDD12");
            put("&Ograve", "\u00D2");
            put("&Ograve;", "\u00D2");
            put("&Omacr;", "\u014C");
            put("&Omega;", "\u03A9");
            put("&Omicron;", "\u039F");
            put("&Oopf;", "\uD835\uDD46");
            put("&OpenCurlyDoubleQuote;", "\u201C");
            put("&OpenCurlyQuote;", "\u2018");
            put("&Or;", "\u2A54");
            put("&Oscr;", "\uD835\uDCAA");
            put("&Oslash", "\u00D8");
            put("&Oslash;", "\u00D8");
            put("&Otilde", "\u00D5");
            put("&Otilde;", "\u00D5");
            put("&Otimes;", "\u2A37");
            put("&Ouml", "\u00D6");
            put("&Ouml;", "\u00D6");
            put("&OverBar;", "\u203E");
            put("&OverBrace;", "\u23DE");
            put("&OverBracket;", "\u23B4");
            put("&OverParenthesis;", "\u23DC");
            put("&PartialD;", "\u2202");
            put("&Pcy;", "\u041F");
            put("&Pfr;", "\uD835\uDD13");
            put("&Phi;", "\u03A6");
            put("&Pi;", "\u03A0");
            put("&PlusMinus;", "\u00B1");
            put("&Poincareplane;", "\u210C");
            put("&Popf;", "\u2119");
            put("&Pr;", "\u2ABB");
            put("&Precedes;", "\u227A");
            put("&PrecedesEqual;", "\u2AAF");
            put("&PrecedesSlantEqual;", "\u227C");
            put("&PrecedesTilde;", "\u227E");
            put("&Prime;", "\u2033");
            put("&Product;", "\u220F");
            put("&Proportion;", "\u2237");
            put("&Proportional;", "\u221D");
            put("&Pscr;", "\uD835\uDCAB");
            put("&Psi;", "\u03A8");
            put("&QUOT", "\\u0022");
            put("&QUOT;", "\\u0022");
            put("&Qfr;", "\uD835\uDD14");
            put("&Qopf;", "\u211A");
            put("&Qscr;", "\uD835\uDCAC");
            put("&RBarr;", "\u2910");
            put("&REG", "\u00AE");
            put("&REG;", "\u00AE");
            put("&Racute;", "\u0154");
            put("&Rang;", "\u27EB");
            put("&Rarr;", "\u21A0");
            put("&Rarrtl;", "\u2916");
            put("&Rcaron;", "\u0158");
            put("&Rcedil;", "\u0156");
            put("&Rcy;", "\u0420");
            put("&Re;", "\u211C");
            put("&ReverseElement;", "\u220B");
            put("&ReverseEquilibrium;", "\u21CB");
            put("&ReverseUpEquilibrium;", "\u296F");
            put("&Rfr;", "\u211C");
            put("&Rho;", "\u03A1");
            put("&RightAngleBracket;", "\u27E9");
            put("&RightArrow;", "\u2192");
            put("&RightArrowBar;", "\u21E5");
            put("&RightArrowLeftArrow;", "\u21C4");
            put("&RightCeiling;", "\u2309");
            put("&RightDoubleBracket;", "\u27E7");
            put("&RightDownTeeVector;", "\u295D");
            put("&RightDownVector;", "\u21C2");
            put("&RightDownVectorBar;", "\u2955");
            put("&RightFloor;", "\u230B");
            put("&RightTee;", "\u22A2");
            put("&RightTeeArrow;", "\u21A6");
            put("&RightTeeVector;", "\u295B");
            put("&RightTriangle;", "\u22B3");
            put("&RightTriangleBar;", "\u29D0");
            put("&RightTriangleEqual;", "\u22B5");
            put("&RightUpDownVector;", "\u294F");
            put("&RightUpTeeVector;", "\u295C");
            put("&RightUpVector;", "\u21BE");
            put("&RightUpVectorBar;", "\u2954");
            put("&RightVector;", "\u21C0");
            put("&RightVectorBar;", "\u2953");
            put("&Rightarrow;", "\u21D2");
            put("&Ropf;", "\u211D");
            put("&RoundImplies;", "\u2970");
            put("&Rrightarrow;", "\u21DB");
            put("&Rscr;", "\u211B");
            put("&Rsh;", "\u21B1");
            put("&RuleDelayed;", "\u29F4");
            put("&SHCHcy;", "\u0429");
            put("&SHcy;", "\u0428");
            put("&SOFTcy;", "\u042C");
            put("&Sacute;", "\u015A");
            put("&Sc;", "\u2ABC");
            put("&Scaron;", "\u0160");
            put("&Scedil;", "\u015E");
            put("&Scirc;", "\u015C");
            put("&Scy;", "\u0421");
            put("&Sfr;", "\uD835\uDD16");
            put("&ShortDownArrow;", "\u2193");
            put("&ShortLeftArrow;", "\u2190");
            put("&ShortRightArrow;", "\u2192");
            put("&ShortUpArrow;", "\u2191");
            put("&Sigma;", "\u03A3");
            put("&SmallCircle;", "\u2218");
            put("&Sopf;", "\uD835\uDD4A");
            put("&Sqrt;", "\u221A");
            put("&Square;", "\u25A1");
            put("&SquareIntersection;", "\u2293");
            put("&SquareSubset;", "\u228F");
            put("&SquareSubsetEqual;", "\u2291");
            put("&SquareSuperset;", "\u2290");
            put("&SquareSupersetEqual;", "\u2292");
            put("&SquareUnion;", "\u2294");
            put("&Sscr;", "\uD835\uDCAE");
            put("&Star;", "\u22C6");
            put("&Sub;", "\u22D0");
            put("&Subset;", "\u22D0");
            put("&SubsetEqual;", "\u2286");
            put("&Succeeds;", "\u227B");
            put("&SucceedsEqual;", "\u2AB0");
            put("&SucceedsSlantEqual;", "\u227D");
            put("&SucceedsTilde;", "\u227F");
            put("&SuchThat;", "\u220B");
            put("&Sum;", "\u2211");
            put("&Sup;", "\u22D1");
            put("&Superset;", "\u2283");
            put("&SupersetEqual;", "\u2287");
            put("&Supset;", "\u22D1");
            put("&THORN", "\u00DE");
            put("&THORN;", "\u00DE");
            put("&TRADE;", "\u2122");
            put("&TSHcy;", "\u040B");
            put("&TScy;", "\u0426");
            put("&Tab;", "\u0009");
            put("&Tau;", "\u03A4");
            put("&Tcaron;", "\u0164");
            put("&Tcedil;", "\u0162");
            put("&Tcy;", "\u0422");
            put("&Tfr;", "\uD835\uDD17");
            put("&Therefore;", "\u2234");
            put("&Theta;", "\u0398");
            put("&ThickSpace;", "\u205F\u200A");
            put("&ThinSpace;", "\u2009");
            put("&Tilde;", "\u223C");
            put("&TildeEqual;", "\u2243");
            put("&TildeFullEqual;", "\u2245");
            put("&TildeTilde;", "\u2248");
            put("&Topf;", "\uD835\uDD4B");
            put("&TripleDot;", "\u20DB");
            put("&Tscr;", "\uD835\uDCAF");
            put("&Tstrok;", "\u0166");
            put("&Uacute", "\u00DA");
            put("&Uacute;", "\u00DA");
            put("&Uarr;", "\u219F");
            put("&Uarrocir;", "\u2949");
            put("&Ubrcy;", "\u040E");
            put("&Ubreve;", "\u016C");
            put("&Ucirc", "\u00DB");
            put("&Ucirc;", "\u00DB");
            put("&Ucy;", "\u0423");
            put("&Udblac;", "\u0170");
            put("&Ufr;", "\uD835\uDD18");
            put("&Ugrave", "\u00D9");
            put("&Ugrave;", "\u00D9");
            put("&Umacr;", "\u016A");
            put("&UnderBar;", "\u005F");
            put("&UnderBrace;", "\u23DF");
            put("&UnderBracket;", "\u23B5");
            put("&UnderParenthesis;", "\u23DD");
            put("&Union;", "\u22C3");
            put("&UnionPlus;", "\u228E");
            put("&Uogon;", "\u0172");
            put("&Uopf;", "\uD835\uDD4C");
            put("&UpArrow;", "\u2191");
            put("&UpArrowBar;", "\u2912");
            put("&UpArrowDownArrow;", "\u21C5");
            put("&UpDownArrow;", "\u2195");
            put("&UpEquilibrium;", "\u296E");
            put("&UpTee;", "\u22A5");
            put("&UpTeeArrow;", "\u21A5");
            put("&Uparrow;", "\u21D1");
            put("&Updownarrow;", "\u21D5");
            put("&UpperLeftArrow;", "\u2196");
            put("&UpperRightArrow;", "\u2197");
            put("&Upsi;", "\u03D2");
            put("&Upsilon;", "\u03A5");
            put("&Uring;", "\u016E");
            put("&Uscr;", "\uD835\uDCB0");
            put("&Utilde;", "\u0168");
            put("&Uuml", "\u00DC");
            put("&Uuml;", "\u00DC");
            put("&VDash;", "\u22AB");
            put("&Vbar;", "\u2AEB");
            put("&Vcy;", "\u0412");
            put("&Vdash;", "\u22A9");
            put("&Vdashl;", "\u2AE6");
            put("&Vee;", "\u22C1");
            put("&Verbar;", "\u2016");
            put("&Vert;", "\u2016");
            put("&VerticalBar;", "\u2223");
            put("&VerticalLine;", "\u007C");
            put("&VerticalSeparator;", "\u2758");
            put("&VerticalTilde;", "\u2240");
            put("&VeryThinSpace;", "\u200A");
            put("&Vfr;", "\uD835\uDD19");
            put("&Vopf;", "\uD835\uDD4D");
            put("&Vscr;", "\uD835\uDCB1");
            put("&Vvdash;", "\u22AA");
            put("&Wcirc;", "\u0174");
            put("&Wedge;", "\u22C0");
            put("&Wfr;", "\uD835\uDD1A");
            put("&Wopf;", "\uD835\uDD4E");
            put("&Wscr;", "\uD835\uDCB2");
            put("&Xfr;", "\uD835\uDD1B");
            put("&Xi;", "\u039E");
            put("&Xopf;", "\uD835\uDD4F");
            put("&Xscr;", "\uD835\uDCB3");
            put("&YAcy;", "\u042F");
            put("&YIcy;", "\u0407");
            put("&YUcy;", "\u042E");
            put("&Yacute", "\u00DD");
            put("&Yacute;", "\u00DD");
            put("&Ycirc;", "\u0176");
            put("&Ycy;", "\u042B");
            put("&Yfr;", "\uD835\uDD1C");
            put("&Yopf;", "\uD835\uDD50");
            put("&Yscr;", "\uD835\uDCB4");
            put("&Yuml;", "\u0178");
            put("&ZHcy;", "\u0416");
            put("&Zacute;", "\u0179");
            put("&Zcaron;", "\u017D");
            put("&Zcy;", "\u0417");
            put("&Zdot;", "\u017B");
            put("&ZeroWidthSpace;", "\u200B");
            put("&Zeta;", "\u0396");
            put("&Zfr;", "\u2128");
            put("&Zopf;", "\u2124");
            put("&Zscr;", "\uD835\uDCB5");
            put("&aacute;", "\u00E1");
            put("&abreve;", "\u0103");
            put("&ac;", "\u223E");
            put("&acE;", "\u223E\u0333");
            put("&acd;", "\u223F");
            put("&acirc", "\u00E2");
            put("&acirc;", "\u00E2");
            put("&acute", "\u00B4");
            put("&acute;", "\u00B4");
            put("&acy;", "\u0430");
            put("&aelig", "\u00E6");
            put("&aelig;", "\u00E6");
            put("&af;", "\u2061");
            put("&afr;", "\uD835\uDD1E");
            put("&agrave", "\u00E0");
            put("&agrave;", "\u00E0");
            put("&alefsym;", "\u2135");
            put("&aleph;", "\u2135");
            put("&alpha;", "\u03B1");
            put("&amacr;", "\u0101");
            put("&amalg;", "\u2A3F");
            put("&amp", "\u0026");
            put("&amp;", "\u0026");
            put("&and;", "\u2227");
            put("&andand;", "\u2A55");
            put("&andd;", "\u2A5C");
            put("&andslope;", "\u2A58");
            put("&andv;", "\u2A5A");
            put("&ang;", "\u2220");
            put("&ange;", "\u29A4");
            put("&angle;", "\u2220");
            put("&angmsd;", "\u2221");
            put("&angmsdaa;", "\u29A8");
            put("&angmsdab;", "\u29A9");
            put("&angmsdac;", "\u29AA");
            put("&angmsdad;", "\u29AB");
            put("&angmsdae;", "\u29AC");
            put("&angmsdaf;", "\u29AD");
            put("&angmsdag;", "\u29AE");
            put("&angmsdah;", "\u29AF");
            put("&angrt;", "\u221F");
            put("&angrtvb;", "\u22BE");
            put("&angrtvbd;", "\u299D");
            put("&angsph;", "\u2222");
            put("&angst;", "\u00C5");
            put("&angzarr;", "\u237C");
            put("&aogon;", "\u0105");
            put("&aopf;", "\uD835\uDD52");
            put("&ap;", "\u2248");
            put("&apE;", "\u2A70");
            put("&apacir;", "\u2A6F");
            put("&ape;", "\u224A");
            put("&apid;", "\u224B");
            put("&apos;", "\u0027");
            put("&approx;", "\u2248");
            put("&approxeq;", "\u224A");
            put("&aring", "\u00E5");
            put("&aring;", "\u00E5");
            put("&ascr;", "\uD835\uDCB6");
            put("&ast;", "\u002A");
            put("&asymp;", "\u2248");
            put("&asympeq;", "\u224D");
            put("&atilde", "\u00E3");
            put("&atilde;", "\u00E3");
            put("&auml", "\u00E4");
            put("&auml;", "\u00E4");
            put("&awconint;", "\u2233");
            put("&awint;", "\u2A11");
            put("&bNot;", "\u2AED");
            put("&backcong;", "\u224C");
            put("&backepsilon;", "\u03F6");
            put("&backprime;", "\u2035");
            put("&backsim;", "\u223D");
            put("&backsimeq;", "\u22CD");
            put("&barvee;", "\u22BD");
            put("&barwed;", "\u2305");
            put("&barwedge;", "\u2305");
            put("&bbrk;", "\u23B5");
            put("&bbrktbrk;", "\u23B6");
            put("&bcong;", "\u224C");
            put("&bcy;", "\u0431");
            put("&bdquo;", "\u201E");
            put("&becaus;", "\u2235");
            put("&because;", "\u2235");
            put("&bemptyv;", "\u29B0");
            put("&bepsi;", "\u03F6");
            put("&bernou;", "\u212C");
            put("&beta;", "\u03B2");
            put("&beth;", "\u2136");
            put("&between;", "\u226C");
            put("&bfr;", "\uD835\uDD1F");
            put("&bigcap;", "\u22C2");
            put("&bigcirc;", "\u25EF");
            put("&bigcup;", "\u22C3");
            put("&bigodot;", "\u2A00");
            put("&bigoplus;", "\u2A01");
            put("&bigotimes;", "\u2A02");
            put("&bigsqcup;", "\u2A06");
            put("&bigstar;", "\u2605");
            put("&bigtriangledown;", "\u25BD");
            put("&bigtriangleup;", "\u25B3");
            put("&biguplus;", "\u2A04");
            put("&bigvee;", "\u22C1");
            put("&bigwedge;", "\u22C0");
            put("&bkarow;", "\u290D");
            put("&blacklozenge;", "\u29EB");
            put("&blacksquare;", "\u25AA");
            put("&blacktriangle;", "\u25B4");
            put("&blacktriangledown;", "\u25BE");
            put("&blacktriangleleft;", "\u25C2");
            put("&blacktriangleright;", "\u25B8");
            put("&blank;", "\u2423");
            put("&blk12;", "\u2592");
            put("&blk14;", "\u2591");
            put("&blk34;", "\u2593");
            put("&block;", "\u2588");
            put("&bne;", "\u003D\u20E5");
            put("&bnequiv;", "\u2261\u20E5");
            put("&bnot;", "\u2310");
            put("&bopf;", "\uD835\uDD53");
            put("&bot;", "\u22A5");
            put("&bottom;", "\u22A5");
            put("&bowtie;", "\u22C8");
            put("&boxDL;", "\u2557");
            put("&boxDR;", "\u2554");
            put("&boxDl;", "\u2556");
            put("&boxDr;", "\u2553");
            put("&boxH;", "\u2550");
            put("&boxHD;", "\u2566");
            put("&boxHU;", "\u2569");
            put("&boxHd;", "\u2564");
            put("&boxHu;", "\u2567");
            put("&boxUL;", "\u255D");
            put("&boxUR;", "\u255A");
            put("&boxUl;", "\u255C");
            put("&boxUr;", "\u2559");
            put("&boxV;", "\u2551");
            put("&boxVH;", "\u256C");
            put("&boxVL;", "\u2563");
            put("&boxVR;", "\u2560");
            put("&boxVh;", "\u256B");
            put("&boxVl;", "\u2562");
            put("&boxVr;", "\u255F");
            put("&boxbox;", "\u29C9");
            put("&boxdL;", "\u2555");
            put("&boxdR;", "\u2552");
            put("&boxdl;", "\u2510");
            put("&boxdr;", "\u250C");
            put("&boxh;", "\u2500");
            put("&boxhD;", "\u2565");
            put("&boxhU;", "\u2568");
            put("&boxhd;", "\u252C");
            put("&boxhu;", "\u2534");
            put("&boxminus;", "\u229F");
            put("&boxplus;", "\u229E");
            put("&boxtimes;", "\u22A0");
            put("&boxuL;", "\u255B");
            put("&boxuR;", "\u2558");
            put("&boxul;", "\u2518");
            put("&boxur;", "\u2514");
            put("&boxv;", "\u2502");
            put("&boxvH;", "\u256A");
            put("&boxvL;", "\u2561");
            put("&boxvR;", "\u255E");
            put("&boxvh;", "\u253C");
            put("&boxvl;", "\u2524");
            put("&boxvr;", "\u251C");
            put("&bprime;", "\u2035");
            put("&breve;", "\u02D8");
            put("&brvbar", "\u00A6");
            put("&brvbar;", "\u00A6");
            put("&bscr;", "\uD835\uDCB7");
            put("&bsemi;", "\u204F");
            put("&bsim;", "\u223D");
            put("&bsime;", "\u22CD");
            put("&bsol;", "\\u005C");
            put("&bsolb;", "\u29C5");
            put("&bsolhsub;", "\u27C8");
            put("&bull;", "\u2022");
            put("&bullet;", "\u2022");
            put("&bump;", "\u224E");
            put("&bumpE;", "\u2AAE");
            put("&bumpe;", "\u224F");
            put("&bumpeq;", "\u224F");
            put("&cacute;", "\u0107");
            put("&cap;", "\u2229");
            put("&capand;", "\u2A44");
            put("&capbrcup;", "\u2A49");
            put("&capcap;", "\u2A4B");
            put("&capcup;", "\u2A47");
            put("&capdot;", "\u2A40");
            put("&caps;", "\u2229\uFE00");
            put("&caret;", "\u2041");
            put("&caron;", "\u02C7");
            put("&ccaps;", "\u2A4D");
            put("&ccaron;", "\u010D");
            put("&ccedil", "\u00E7");
            put("&ccedil;", "\u00E7");
            put("&ccirc;", "\u0109");
            put("&ccups;", "\u2A4C");
            put("&ccupssm;", "\u2A50");
            put("&cdot;", "\u010B");
            put("&cedil", "\u00B8");
            put("&cedil;", "\u00B8");
            put("&cemptyv;", "\u29B2");
            put("&cent", "\u00A2");
            put("&cent;", "\u00A2");
            put("&centerdot;", "\u00B7");
            put("&cfr;", "\uD835\uDD20");
            put("&chcy;", "\u0447");
            put("&check;", "\u2713");
            put("&checkmark;", "\u2713");
            put("&chi;", "\u03C7");
            put("&cir;", "\u25CB");
            put("&cirE;", "\u29C3");
            put("&circ;", "\u02C6");
            put("&circeq;", "\u2257");
            put("&circlearrowleft;", "\u21BA");
            put("&circlearrowright;", "\u21BB");
            put("&circledR;", "\u00AE");
            put("&circledS;", "\u24C8");
            put("&circledast;", "\u229B");
            put("&circledcirc;", "\u229A");
            put("&circleddash;", "\u229D");
            put("&cire;", "\u2257");
            put("&cirfnint;", "\u2A10");
            put("&cirmid;", "\u2AEF");
            put("&cirscir;", "\u29C2");
            put("&clubs;", "\u2663");
            put("&clubsuit;", "\u2663");
            put("&colon;", "\u003A");
            put("&colone;", "\u2254");
            put("&coloneq;", "\u2254");
            put("&comma;", "\u002C");
            put("&commat;", "\u0040");
            put("&comp;", "\u2201");
            put("&compfn;", "\u2218");
            put("&complement;", "\u2201");
            put("&complexes;", "\u2102");
            put("&cong;", "\u2245");
            put("&congdot;", "\u2A6D");
            put("&conint;", "\u222E");
            put("&copf;", "\uD835\uDD54");
            put("&coprod;", "\u2210");
            put("&copy", "\u00A9");
            put("&copy;", "\u00A9");
            put("&copysr;", "\u2117");
            put("&crarr;", "\u21B5");
            put("&cross;", "\u2717");
            put("&cscr;", "\uD835\uDCB8");
            put("&csub;", "\u2ACF");
            put("&csube;", "\u2AD1");
            put("&csup;", "\u2AD0");
            put("&csupe;", "\u2AD2");
            put("&ctdot;", "\u22EF");
            put("&cudarrl;", "\u2938");
            put("&cudarrr;", "\u2935");
            put("&cuepr;", "\u22DE");
            put("&cuesc;", "\u22DF");
            put("&cularr;", "\u21B6");
            put("&cularrp;", "\u293D");
            put("&cup;", "\u222A");
            put("&cupbrcap;", "\u2A48");
            put("&cupcap;", "\u2A46");
            put("&cupcup;", "\u2A4A");
            put("&cupdot;", "\u228D");
            put("&cupor;", "\u2A45");
            put("&cups;", "\u222A\uFE00");
            put("&curarr;", "\u21B7");
            put("&curarrm;", "\u293C");
            put("&curlyeqprec;", "\u22DE");
            put("&curlyeqsucc;", "\u22DF");
            put("&curlyvee;", "\u22CE");
            put("&curlywedge;", "\u22CF");
            put("&curren", "\u00A4");
            put("&curren;", "\u00A4");
            put("&curvearrowleft;", "\u21B6");
            put("&curvearrowright;", "\u21B7");
            put("&cuvee;", "\u22CE");
            put("&cuwed;", "\u22CF");
            put("&cwconint;", "\u2232");
            put("&cwint;", "\u2231");
            put("&cylcty;", "\u232D");
            put("&dArr;", "\u21D3");
            put("&dHar;", "\u2965");
            put("&dagger;", "\u2020");
            put("&daleth;", "\u2138");
            put("&darr;", "\u2193");
            put("&dash;", "\u2010");
            put("&dashv;", "\u22A3");
            put("&dbkarow;", "\u290F");
            put("&dblac;", "\u02DD");
            put("&dcaron;", "\u010F");
            put("&dcy;", "\u0434");
            put("&dd;", "\u2146");
            put("&ddagger;", "\u2021");
            put("&ddarr;", "\u21CA");
            put("&ddotseq;", "\u2A77");
            put("&deg", "\u00B0");
            put("&deg;", "\u00B0");
            put("&delta;", "\u03B4");
            put("&demptyv;", "\u29B1");
            put("&dfisht;", "\u297F");
            put("&dfr;", "\uD835\uDD21");
            put("&dharl;", "\u21C3");
            put("&dharr;", "\u21C2");
            put("&diam;", "\u22C4");
            put("&diamond;", "\u22C4");
            put("&diamondsuit;", "\u2666");
            put("&diams;", "\u2666");
            put("&die;", "\u00A8");
            put("&digamma;", "\u03DD");
            put("&disin;", "\u22F2");
            put("&div;", "\u00F7");
            put("&divide", "\u00F7");
            put("&divide;", "\u00F7");
            put("&divideontimes;", "\u22C7");
            put("&divonx;", "\u22C7");
            put("&djcy;", "\u0452");
            put("&dlcorn;", "\u231E");
            put("&dlcrop;", "\u230D");
            put("&dollar;", "\u0024");
            put("&dopf;", "\uD835\uDD55");
            put("&dot;", "\u02D9");
            put("&doteq;", "\u2250");
            put("&doteqdot;", "\u2251");
            put("&dotminus;", "\u2238");
            put("&dotplus;", "\u2214");
            put("&dotsquare;", "\u22A1");
            put("&doublebarwedge;", "\u2306");
            put("&downarrow;", "\u2193");
            put("&downdownarrows;", "\u21CA");
            put("&downharpoonleft;", "\u21C3");
            put("&downharpoonright;", "\u21C2");
            put("&drbkarow;", "\u2910");
            put("&drcorn;", "\u231F");
            put("&drcrop;", "\u230C");
            put("&dscr;", "\uD835\uDCB9");
            put("&dscy;", "\u0455");
            put("&dsol;", "\u29F6");
            put("&dstrok;", "\u0111");
            put("&dtdot;", "\u22F1");
            put("&dtri;", "\u25BF");
            put("&dtrif;", "\u25BE");
            put("&duarr;", "\u21F5");
            put("&duhar;", "\u296F");
            put("&dwangle;", "\u29A6");
            put("&dzcy;", "\u045F");
            put("&dzigrarr;", "\u27FF");
            put("&eDDot;", "\u2A77");
            put("&eDot;", "\u2251");
            put("&eacute;", "\u00E9");
            put("&easter;", "\u2A6E");
            put("&ecaron;", "\u011B");
            put("&ecir;", "\u2256");
            put("&ecirc", "\u00EA");
            put("&ecirc;", "\u00EA");
            put("&ecolon;", "\u2255");
            put("&ecy;", "\u044D");
            put("&edot;", "\u0117");
            put("&ee;", "\u2147");
            put("&efDot;", "\u2252");
            put("&efr;", "\uD835\uDD22");
            put("&eg;", "\u2A9A");
            put("&egrave", "\u00E8");
            put("&egrave;", "\u00E8");
            put("&egs;", "\u2A96");
            put("&egsdot;", "\u2A98");
            put("&el;", "\u2A99");
            put("&elinters;", "\u23E7");
            put("&ell;", "\u2113");
            put("&els;", "\u2A95");
            put("&elsdot;", "\u2A97");
            put("&emacr;", "\u0113");
            put("&empty;", "\u2205");
            put("&emptyset;", "\u2205");
            put("&emptyv;", "\u2205");
            put("&emsp13;", "\u2004");
            put("&emsp14;", "\u2005");
            put("&emsp;", "\u2003");
            put("&eng;", "\u014B");
            put("&ensp;", "\u2002");
            put("&eogon;", "\u0119");
            put("&eopf;", "\uD835\uDD56");
            put("&epar;", "\u22D5");
            put("&eparsl;", "\u29E3");
            put("&eplus;", "\u2A71");
            put("&epsi;", "\u03B5");
            put("&epsilon;", "\u03B5");
            put("&epsiv;", "\u03F5");
            put("&eqcirc;", "\u2256");
            put("&eqcolon;", "\u2255");
            put("&eqsim;", "\u2242");
            put("&eqslantgtr;", "\u2A96");
            put("&eqslantless;", "\u2A95");
            put("&equals;", "\u003D");
            put("&equest;", "\u225F");
            put("&equiv;", "\u2261");
            put("&equivDD;", "\u2A78");
            put("&eqvparsl;", "\u29E5");
            put("&erDot;", "\u2253");
            put("&erarr;", "\u2971");
            put("&escr;", "\u212F");
            put("&esdot;", "\u2250");
            put("&esim;", "\u2242");
            put("&eta;", "\u03B7");
            put("&eth", "\u00F0");
            put("&eth;", "\u00F0");
            put("&euml", "\u00EB");
            put("&euml;", "\u00EB");
            put("&euro;", "\u20AC");
            put("&excl;", "\u0021");
            put("&exist;", "\u2203");
            put("&expectation;", "\u2130");
            put("&exponentiale;", "\u2147");
            put("&fallingdotseq;", "\u2252");
            put("&fcy;", "\u0444");
            put("&female;", "\u2640");
            put("&ffilig;", "\uFB03");
            put("&fflig;", "\uFB00");
            put("&ffllig;", "\uFB04");
            put("&ffr;", "\uD835\uDD23");
            put("&filig;", "\uFB01");
            put("&fjlig;", "\u0066\u006A");
            put("&flat;", "\u266D");
            put("&fllig;", "\uFB02");
            put("&fltns;", "\u25B1");
            put("&fnof;", "\u0192");
            put("&fopf;", "\uD835\uDD57");
            put("&forall;", "\u2200");
            put("&fork;", "\u22D4");
            put("&forkv;", "\u2AD9");
            put("&fpartint;", "\u2A0D");
            put("&frac12", "\u00BD");
            put("&frac12;", "\u00BD");
            put("&frac13;", "\u2153");
            put("&frac14", "\u00BC");
            put("&frac14;", "\u00BC");
            put("&frac15;", "\u2155");
            put("&frac16;", "\u2159");
            put("&frac18;", "\u215B");
            put("&frac23;", "\u2154");
            put("&frac25;", "\u2156");
            put("&frac34", "\u00BE");
            put("&frac34;", "\u00BE");
            put("&frac35;", "\u2157");
            put("&frac38;", "\u215C");
            put("&frac45;", "\u2158");
            put("&frac56;", "\u215A");
            put("&frac58;", "\u215D");
            put("&frac78;", "\u215E");
            put("&frasl;", "\u2044");
            put("&frown;", "\u2322");
            put("&fscr;", "\uD835\uDCBB");
            put("&gE;", "\u2267");
            put("&gEl;", "\u2A8C");
            put("&gacute;", "\u01F5");
            put("&gamma;", "\u03B3");
            put("&gammad;", "\u03DD");
            put("&gap;", "\u2A86");
            put("&gbreve;", "\u011F");
            put("&gcirc;", "\u011D");
            put("&gcy;", "\u0433");
            put("&gdot;", "\u0121");
            put("&ge;", "\u2265");
            put("&gel;", "\u22DB");
            put("&geq;", "\u2265");
            put("&geqq;", "\u2267");
            put("&geqslant;", "\u2A7E");
            put("&ges;", "\u2A7E");
            put("&gescc;", "\u2AA9");
            put("&gesdot;", "\u2A80");
            put("&gesdoto;", "\u2A82");
            put("&gesdotol;", "\u2A84");
            put("&gesl;", "\u22DB\uFE00");
            put("&gesles;", "\u2A94");
            put("&gfr;", "\uD835\uDD24");
            put("&gg;", "\u226B");
            put("&ggg;", "\u22D9");
            put("&gimel;", "\u2137");
            put("&gjcy;", "\u0453");
            put("&gl;", "\u2277");
            put("&glE;", "\u2A92");
            put("&gla;", "\u2AA5");
            put("&glj;", "\u2AA4");
            put("&gnE;", "\u2269");
            put("&gnap;", "\u2A8A");
            put("&gnapprox;", "\u2A8A");
            put("&gne;", "\u2A88");
            put("&gneq;", "\u2A88");
            put("&gneqq;", "\u2269");
            put("&gnsim;", "\u22E7");
            put("&gopf;", "\uD835\uDD58");
            put("&grave;", "\u0060");
            put("&gscr;", "\u210A");
            put("&gsim;", "\u2273");
            put("&gsime;", "\u2A8E");
            put("&gsiml;", "\u2A90");
            put("&gt", "\u003E");
            put("&gt;", "\u003E");
            put("&gtcc;", "\u2AA7");
            put("&gtcir;", "\u2A7A");
            put("&gtdot;", "\u22D7");
            put("&gtlPar;", "\u2995");
            put("&gtquest;", "\u2A7C");
            put("&gtrapprox;", "\u2A86");
            put("&gtrarr;", "\u2978");
            put("&gtrdot;", "\u22D7");
            put("&gtreqless;", "\u22DB");
            put("&gtreqqless;", "\u2A8C");
            put("&gtrless;", "\u2277");
            put("&gtrsim;", "\u2273");
            put("&gvertneqq;", "\u2269\uFE00");
            put("&gvnE;", "\u2269\uFE00");
            put("&hArr;", "\u21D4");
            put("&hairsp;", "\u200A");
            put("&half;", "\u00BD");
            put("&hamilt;", "\u210B");
            put("&hardcy;", "\u044A");
            put("&harr;", "\u2194");
            put("&harrcir;", "\u2948");
            put("&harrw;", "\u21AD");
            put("&hbar;", "\u210F");
            put("&hcirc;", "\u0125");
            put("&hearts;", "\u2665");
            put("&heartsuit;", "\u2665");
            put("&hellip;", "\u2026");
            put("&hercon;", "\u22B9");
            put("&hfr;", "\uD835\uDD25");
            put("&hksearow;", "\u2925");
            put("&hkswarow;", "\u2926");
            put("&hoarr;", "\u21FF");
            put("&homtht;", "\u223B");
            put("&hookleftarrow;", "\u21A9");
            put("&hookrightarrow;", "\u21AA");
            put("&hopf;", "\uD835\uDD59");
            put("&horbar;", "\u2015");
            put("&hscr;", "\uD835\uDCBD");
            put("&hslash;", "\u210F");
            put("&hstrok;", "\u0127");
            put("&hybull;", "\u2043");
            put("&hyphen;", "\u2010");
            put("&iacute", "\u00ED");
            put("&iacute;", "\u00ED");
            put("&ic;", "\u2063");
            put("&icirc", "\u00EE");
            put("&icirc;", "\u00EE");
            put("&icy;", "\u0438");
            put("&iecy;", "\u0435");
            put("&iexcl", "\u00A1");
            put("&iexcl;", "\u00A1");
            put("&iff;", "\u21D4");
            put("&ifr;", "\uD835\uDD26");
            put("&igrave", "\u00EC");
            put("&igrave;", "\u00EC");
            put("&ii;", "\u2148");
            put("&iiiint;", "\u2A0C");
            put("&iiint;", "\u222D");
            put("&iinfin;", "\u29DC");
            put("&iiota;", "\u2129");
            put("&ijlig;", "\u0133");
            put("&imacr;", "\u012B");
            put("&image;", "\u2111");
            put("&imagline;", "\u2110");
            put("&imagpart;", "\u2111");
            put("&imath;", "\u0131");
            put("&imof;", "\u22B7");
            put("&imped;", "\u01B5");
            put("&in;", "\u2208");
            put("&incare;", "\u2105");
            put("&infin;", "\u221E");
            put("&infintie;", "\u29DD");
            put("&inodot;", "\u0131");
            put("&int;", "\u222B");
            put("&intcal;", "\u22BA");
            put("&integers;", "\u2124");
            put("&intercal;", "\u22BA");
            put("&intlarhk;", "\u2A17");
            put("&intprod;", "\u2A3C");
            put("&iocy;", "\u0451");
            put("&iogon;", "\u012F");
            put("&iopf;", "\uD835\uDD5A");
            put("&iota;", "\u03B9");
            put("&iprod;", "\u2A3C");
            put("&iquest", "\u00BF");
            put("&iquest;", "\u00BF");
            put("&iscr;", "\uD835\uDCBE");
            put("&isin;", "\u2208");
            put("&isinE;", "\u22F9");
            put("&isindot;", "\u22F5");
            put("&isins;", "\u22F4");
            put("&isinsv;", "\u22F3");
            put("&isinv;", "\u2208");
            put("&it;", "\u2062");
            put("&itilde;", "\u0129");
            put("&iukcy;", "\u0456");
            put("&iuml", "\u00EF");
            put("&iuml;", "\u00EF");
            put("&jcirc;", "\u0135");
            put("&jcy;", "\u0439");
            put("&jfr;", "\uD835\uDD27");
            put("&jmath;", "\u0237");
            put("&jopf;", "\uD835\uDD5B");
            put("&jscr;", "\uD835\uDCBF");
            put("&jsercy;", "\u0458");
            put("&jukcy;", "\u0454");
            put("&kappa;", "\u03BA");
            put("&kappav;", "\u03F0");
            put("&kcedil;", "\u0137");
            put("&kcy;", "\u043A");
            put("&kfr;", "\uD835\uDD28");
            put("&kgreen;", "\u0138");
            put("&khcy;", "\u0445");
            put("&kjcy;", "\u045C");
            put("&kopf;", "\uD835\uDD5C");
            put("&kscr;", "\uD835\uDCC0");
            put("&lAarr;", "\u21DA");
            put("&lArr;", "\u21D0");
            put("&lAtail;", "\u291B");
            put("&lBarr;", "\u290E");
            put("&lE;", "\u2266");
            put("&lEg;", "\u2A8B");
            put("&lHar;", "\u2962");
            put("&lacute;", "\u013A");
            put("&laemptyv;", "\u29B4");
            put("&lagran;", "\u2112");
            put("&lambda;", "\u03BB");
            put("&lang;", "\u27E8");
            put("&langd;", "\u2991");
            put("&langle;", "\u27E8");
            put("&lap;", "\u2A85");
            put("&laquo", "\u00AB");
            put("&laquo;", "\u00AB");
            put("&larr;", "\u2190");
            put("&larrb;", "\u21E4");
            put("&larrbfs;", "\u291F");
            put("&larrfs;", "\u291D");
            put("&larrhk;", "\u21A9");
            put("&larrlp;", "\u21AB");
            put("&larrpl;", "\u2939");
            put("&larrsim;", "\u2973");
            put("&larrtl;", "\u21A2");
            put("&lat;", "\u2AAB");
            put("&latail;", "\u2919");
            put("&late;", "\u2AAD");
            put("&lates;", "\u2AAD\uFE00");
            put("&lbarr;", "\u290C");
            put("&lbbrk;", "\u2772");
            put("&lbrace;", "\u007B");
            put("&lbrack;", "\u005B");
            put("&lbrke;", "\u298B");
            put("&lbrksld;", "\u298F");
            put("&lbrkslu;", "\u298D");
            put("&lcaron;", "\u013E");
            put("&lcedil;", "\u013C");
            put("&lceil;", "\u2308");
            put("&lcub;", "\u007B");
            put("&lcy;", "\u043B");
            put("&ldca;", "\u2936");
            put("&ldquo;", "\u201C");
            put("&ldquor;", "\u201E");
            put("&ldrdhar;", "\u2967");
            put("&ldrushar;", "\u294B");
            put("&ldsh;", "\u21B2");
            put("&le;", "\u2264");
            put("&leftarrow;", "\u2190");
            put("&leftarrowtail;", "\u21A2");
            put("&leftharpoondown;", "\u21BD");
            put("&leftharpoonup;", "\u21BC");
            put("&leftleftarrows;", "\u21C7");
            put("&leftrightarrow;", "\u2194");
            put("&leftrightarrows;", "\u21C6");
            put("&leftrightharpoons;", "\u21CB");
            put("&leftrightsquigarrow;", "\u21AD");
            put("&leftthreetimes;", "\u22CB");
            put("&leg;", "\u22DA");
            put("&leq;", "\u2264");
            put("&leqq;", "\u2266");
            put("&leqslant;", "\u2A7D");
            put("&les;", "\u2A7D");
            put("&lescc;", "\u2AA8");
            put("&lesdot;", "\u2A7F");
            put("&lesdoto;", "\u2A81");
            put("&lesdotor;", "\u2A83");
            put("&lesg;", "\u22DA\uFE00");
            put("&lesges;", "\u2A93");
            put("&lessapprox;", "\u2A85");
            put("&lessdot;", "\u22D6");
            put("&lesseqgtr;", "\u22DA");
            put("&lesseqqgtr;", "\u2A8B");
            put("&lessgtr;", "\u2276");
            put("&lesssim;", "\u2272");
            put("&lfisht;", "\u297C");
            put("&lfloor;", "\u230A");
            put("&lfr;", "\uD835\uDD29");
            put("&lg;", "\u2276");
            put("&lgE;", "\u2A91");
            put("&lhard;", "\u21BD");
            put("&lharu;", "\u21BC");
            put("&lharul;", "\u296A");
            put("&lhblk;", "\u2584");
            put("&ljcy;", "\u0459");
            put("&ll;", "\u226A");
            put("&llarr;", "\u21C7");
            put("&llcorner;", "\u231E");
            put("&llhard;", "\u296B");
            put("&lltri;", "\u25FA");
            put("&lmidot;", "\u0140");
            put("&lmoust;", "\u23B0");
            put("&lmoustache;", "\u23B0");
            put("&lnE;", "\u2268");
            put("&lnap;", "\u2A89");
            put("&lnapprox;", "\u2A89");
            put("&lne;", "\u2A87");
            put("&lneq;", "\u2A87");
            put("&lneqq;", "\u2268");
            put("&lnsim;", "\u22E6");
            put("&loang;", "\u27EC");
            put("&loarr;", "\u21FD");
            put("&lobrk;", "\u27E6");
            put("&longleftarrow;", "\u27F5");
            put("&longleftrightarrow;", "\u27F7");
            put("&longmapsto;", "\u27FC");
            put("&longrightarrow;", "\u27F6");
            put("&looparrowleft;", "\u21AB");
            put("&looparrowright;", "\u21AC");
            put("&lopar;", "\u2985");
            put("&lopf;", "\uD835\uDD5D");
            put("&loplus;", "\u2A2D");
            put("&lotimes;", "\u2A34");
            put("&lowast;", "\u2217");
            put("&lowbar;", "\u005F");
            put("&loz;", "\u25CA");
            put("&lozenge;", "\u25CA");
            put("&lozf;", "\u29EB");
            put("&lpar;", "\u0028");
            put("&lparlt;", "\u2993");
            put("&lrarr;", "\u21C6");
            put("&lrcorner;", "\u231F");
            put("&lrhar;", "\u21CB");
            put("&lrhard;", "\u296D");
            put("&lrm;", "\u200E");
            put("&lrtri;", "\u22BF");
            put("&lsaquo;", "\u2039");
            put("&lscr;", "\uD835\uDCC1");
            put("&lsh;", "\u21B0");
            put("&lsim;", "\u2272");
            put("&lsime;", "\u2A8D");
            put("&lsimg;", "\u2A8F");
            put("&lsqb;", "\u005B");
            put("&lsquo;", "\u2018");
            put("&lsquor;", "\u201A");
            put("&lstrok;", "\u0142");
            put("&lt", "\u003C");
            put("&lt;", "\u003C");
            put("&ltcc;", "\u2AA6");
            put("&ltcir;", "\u2A79");
            put("&ltdot;", "\u22D6");
            put("&lthree;", "\u22CB");
            put("&ltimes;", "\u22C9");
            put("&ltlarr;", "\u2976");
            put("&ltquest;", "\u2A7B");
            put("&ltrPar;", "\u2996");
            put("&ltri;", "\u25C3");
            put("&ltrie;", "\u22B4");
            put("&ltrif;", "\u25C2");
            put("&lurdshar;", "\u294A");
            put("&luruhar;", "\u2966");
            put("&lvertneqq;", "\u2268\uFE00");
            put("&lvnE;", "\u2268\uFE00");
            put("&mDDot;", "\u223A");
            put("&macr", "\u00AF");
            put("&macr;", "\u00AF");
            put("&male;", "\u2642");
            put("&malt;", "\u2720");
            put("&maltese;", "\u2720");
            put("&map;", "\u21A6");
            put("&mapsto;", "\u21A6");
            put("&mapstodown;", "\u21A7");
            put("&mapstoleft;", "\u21A4");
            put("&mapstoup;", "\u21A5");
            put("&marker;", "\u25AE");
            put("&mcomma;", "\u2A29");
            put("&mcy;", "\u043C");
            put("&mdash;", "\u2014");
            put("&measuredangle;", "\u2221");
            put("&mfr;", "\uD835\uDD2A");
            put("&mho;", "\u2127");
            put("&micro", "\u00B5");
            put("&micro;", "\u00B5");
            put("&mid;", "\u2223");
            put("&midast;", "\u002A");
            put("&midcir;", "\u2AF0");
            put("&middot", "\u00B7");
            put("&middot;", "\u00B7");
            put("&minus;", "\u2212");
            put("&minusb;", "\u229F");
            put("&minusd;", "\u2238");
            put("&minusdu;", "\u2A2A");
            put("&mlcp;", "\u2ADB");
            put("&mldr;", "\u2026");
            put("&mnplus;", "\u2213");
            put("&models;", "\u22A7");
            put("&mopf;", "\uD835\uDD5E");
            put("&mp;", "\u2213");
            put("&mscr;", "\uD835\uDCC2");
            put("&mstpos;", "\u223E");
            put("&mu;", "\u03BC");
            put("&multimap;", "\u22B8");
            put("&mumap;", "\u22B8");
            put("&nGg;", "\u22D9\u0338");
            put("&nGt;", "\u226B\u20D2");
            put("&nGtv;", "\u226B\u0338");
            put("&nLeftarrow;", "\u21CD");
            put("&nLeftrightarrow;", "\u21CE");
            put("&nLl;", "\u22D8\u0338");
            put("&nLt;", "\u226A\u20D2");
            put("&nLtv;", "\u226A\u0338");
            put("&nRightarrow;", "\u21CF");
            put("&nVDash;", "\u22AF");
            put("&nVdash;", "\u22AE");
            put("&nabla;", "\u2207");
            put("&nacute;", "\u0144");
            put("&nang;", "\u2220\u20D2");
            put("&nap;", "\u2249");
            put("&napE;", "\u2A70\u0338");
            put("&napid;", "\u224B\u0338");
            put("&napos;", "\u0149");
            put("&napprox;", "\u2249");
            put("&natur;", "\u266E");
            put("&natural;", "\u266E");
            put("&naturals;", "\u2115");
            put("&nbsp", "\u00A0");
            put("&nbsp;", "\u00A0");
            put("&nbump;", "\u224E\u0338");
            put("&nbumpe;", "\u224F\u0338");
            put("&ncap;", "\u2A43");
            put("&ncaron;", "\u0148");
            put("&ncedil;", "\u0146");
            put("&ncong;", "\u2247");
            put("&ncongdot;", "\u2A6D\u0338");
            put("&ncup;", "\u2A42");
            put("&ncy;", "\u043D");
            put("&ndash;", "\u2013");
            put("&ne;", "\u2260");
            put("&neArr;", "\u21D7");
            put("&nearhk;", "\u2924");
            put("&nearr;", "\u2197");
            put("&nearrow;", "\u2197");
            put("&nedot;", "\u2250\u0338");
            put("&nequiv;", "\u2262");
            put("&nesear;", "\u2928");
            put("&nesim;", "\u2242\u0338");
            put("&nexist;", "\u2204");
            put("&nexists;", "\u2204");
            put("&nfr;", "\uD835\uDD2B");
            put("&ngE;", "\u2267\u0338");
            put("&nge;", "\u2271");
            put("&ngeq;", "\u2271");
            put("&ngeqq;", "\u2267\u0338");
            put("&ngeqslant;", "\u2A7E\u0338");
            put("&nges;", "\u2A7E\u0338");
            put("&ngsim;", "\u2275");
            put("&ngt;", "\u226F");
            put("&ngtr;", "\u226F");
            put("&nhArr;", "\u21CE");
            put("&nharr;", "\u21AE");
            put("&nhpar;", "\u2AF2");
            put("&ni;", "\u220B");
            put("&nis;", "\u22FC");
            put("&nisd;", "\u22FA");
            put("&niv;", "\u220B");
            put("&njcy;", "\u045A");
            put("&nlArr;", "\u21CD");
            put("&nlE;", "\u2266\u0338");
            put("&nlarr;", "\u219A");
            put("&nldr;", "\u2025");
            put("&nle;", "\u2270");
            put("&nleftarrow;", "\u219A");
            put("&nleftrightarrow;", "\u21AE");
            put("&nleq;", "\u2270");
            put("&nleqq;", "\u2266\u0338");
            put("&nleqslant;", "\u2A7D\u0338");
            put("&nles;", "\u2A7D\u0338");
            put("&nless;", "\u226E");
            put("&nlsim;", "\u2274");
            put("&nlt;", "\u226E");
            put("&nltri;", "\u22EA");
            put("&nltrie;", "\u22EC");
            put("&nmid;", "\u2224");
            put("&nopf;", "\uD835\uDD5F");
            put("&not", "\u00AC");
            put("&not;", "\u00AC");
            put("&notin;", "\u2209");
            put("&notinE;", "\u22F9\u0338");
            put("&notindot;", "\u22F5\u0338");
            put("&notinva;", "\u2209");
            put("&notinvb;", "\u22F7");
            put("&notinvc;", "\u22F6");
            put("&notni;", "\u220C");
            put("&notniva;", "\u220C");
            put("&notnivb;", "\u22FE");
            put("&notnivc;", "\u22FD");
            put("&npar;", "\u2226");
            put("&nparallel;", "\u2226");
            put("&nparsl;", "\u2AFD\u20E5");
            put("&npart;", "\u2202\u0338");
            put("&npolint;", "\u2A14");
            put("&npr;", "\u2280");
            put("&nprcue;", "\u22E0");
            put("&npre;", "\u2AAF\u0338");
            put("&nprec;", "\u2280");
            put("&npreceq;", "\u2AAF\u0338");
            put("&nrArr;", "\u21CF");
            put("&nrarr;", "\u219B");
            put("&nrarrc;", "\u2933\u0338");
            put("&nrarrw;", "\u219D\u0338");
            put("&nrightarrow;", "\u219B");
            put("&nrtri;", "\u22EB");
            put("&nrtrie;", "\u22ED");
            put("&nsc;", "\u2281");
            put("&nsccue;", "\u22E1");
            put("&nsce;", "\u2AB0\u0338");
            put("&nscr;", "\uD835\uDCC3");
            put("&nshortmid;", "\u2224");
            put("&nshortparallel;", "\u2226");
            put("&nsim;", "\u2241");
            put("&nsime;", "\u2244");
            put("&nsimeq;", "\u2244");
            put("&nsmid;", "\u2224");
            put("&nspar;", "\u2226");
            put("&nsqsube;", "\u22E2");
            put("&nsqsupe;", "\u22E3");
            put("&nsub;", "\u2284");
            put("&nsubE;", "\u2AC5\u0338");
            put("&nsube;", "\u2288");
            put("&nsubset;", "\u2282\u20D2");
            put("&nsubseteq;", "\u2288");
            put("&nsubseteqq;", "\u2AC5\u0338");
            put("&nsucc;", "\u2281");
            put("&nsucceq;", "\u2AB0\u0338");
            put("&nsup;", "\u2285");
            put("&nsupE;", "\u2AC6\u0338");
            put("&nsupe;", "\u2289");
            put("&nsupset;", "\u2283\u20D2");
            put("&nsupseteq;", "\u2289");
            put("&nsupseteqq;", "\u2AC6\u0338");
            put("&ntgl;", "\u2279");
            put("&ntilde", "\u00F1");
            put("&ntilde;", "\u00F1");
            put("&ntlg;", "\u2278");
            put("&ntriangleleft;", "\u22EA");
            put("&ntrianglelefteq;", "\u22EC");
            put("&ntriangleright;", "\u22EB");
            put("&ntrianglerighteq;", "\u22ED");
            put("&nu;", "\u03BD");
            put("&num;", "\u0023");
            put("&numero;", "\u2116");
            put("&numsp;", "\u2007");
            put("&nvDash;", "\u22AD");
            put("&nvHarr;", "\u2904");
            put("&nvap;", "\u224D\u20D2");
            put("&nvdash;", "\u22AC");
            put("&nvge;", "\u2265\u20D2");
            put("&nvgt;", "\u003E\u20D2");
            put("&nvinfin;", "\u29DE");
            put("&nvlArr;", "\u2902");
            put("&nvle;", "\u2264\u20D2");
            put("&nvlt;", "\u003C\u20D2");
            put("&nvltrie;", "\u22B4\u20D2");
            put("&nvrArr;", "\u2903");
            put("&nvrtrie;", "\u22B5\u20D2");
            put("&nvsim;", "\u223C\u20D2");
            put("&nwArr;", "\u21D6");
            put("&nwarhk;", "\u2923");
            put("&nwarr;", "\u2196");
            put("&nwarrow;", "\u2196");
            put("&nwnear;", "\u2927");
            put("&oS;", "\u24C8");
            put("&oacute", "\u00F3");
            put("&oacute;", "\u00F3");
            put("&oast;", "\u229B");
            put("&ocir;", "\u229A");
            put("&ocirc", "\u00F4");
            put("&ocirc;", "\u00F4");
            put("&ocy;", "\u043E");
            put("&odash;", "\u229D");
            put("&odblac;", "\u0151");
            put("&odiv;", "\u2A38");
            put("&odot;", "\u2299");
            put("&odsold;", "\u29BC");
            put("&oelig;", "\u0153");
            put("&ofcir;", "\u29BF");
            put("&ofr;", "\uD835\uDD2C");
            put("&ogon;", "\u02DB");
            put("&ograve", "\u00F2");
            put("&ograve;", "\u00F2");
            put("&ogt;", "\u29C1");
            put("&ohbar;", "\u29B5");
            put("&ohm;", "\u03A9");
            put("&oint;", "\u222E");
            put("&olarr;", "\u21BA");
            put("&olcir;", "\u29BE");
            put("&olcross;", "\u29BB");
            put("&oline;", "\u203E");
            put("&olt;", "\u29C0");
            put("&omacr;", "\u014D");
            put("&omega;", "\u03C9");
            put("&omicron;", "\u03BF");
            put("&omid;", "\u29B6");
            put("&ominus;", "\u2296");
            put("&oopf;", "\uD835\uDD60");
            put("&opar;", "\u29B7");
            put("&operp;", "\u29B9");
            put("&oplus;", "\u2295");
            put("&or;", "\u2228");
            put("&orarr;", "\u21BB");
            put("&ord;", "\u2A5D");
            put("&order;", "\u2134");
            put("&orderof;", "\u2134");
            put("&ordf", "\u00AA");
            put("&ordf;", "\u00AA");
            put("&ordm", "\u00BA");
            put("&ordm;", "\u00BA");
            put("&origof;", "\u22B6");
            put("&oror;", "\u2A56");
            put("&orslope;", "\u2A57");
            put("&orv;", "\u2A5B");
            put("&oscr;", "\u2134");
            put("&oslash", "\u00F8");
            put("&oslash;", "\u00F8");
            put("&osol;", "\u2298");
            put("&otilde", "\u00F5");
            put("&otilde;", "\u00F5");
            put("&otimes;", "\u2297");
            put("&otimesas;", "\u2A36");
            put("&ouml", "\u00F6");
            put("&ouml;", "\u00F6");
            put("&ovbar;", "\u233D");
            put("&par;", "\u2225");
            put("&para", "\u00B6");
            put("&para;", "\u00B6");
            put("&parallel;", "\u2225");
            put("&parsim;", "\u2AF3");
            put("&parsl;", "\u2AFD");
            put("&part;", "\u2202");
            put("&pcy;", "\u043F");
            put("&percnt;", "\u0025");
            put("&period;", "\u002E");
            put("&permil;", "\u2030");
            put("&perp;", "\u22A5");
            put("&pertenk;", "\u2031");
            put("&pfr;", "\uD835\uDD2D");
            put("&phi;", "\u03C6");
            put("&phiv;", "\u03D5");
            put("&phmmat;", "\u2133");
            put("&phone;", "\u260E");
            put("&pi;", "\u03C0");
            put("&pitchfork;", "\u22D4");
            put("&piv;", "\u03D6");
            put("&planck;", "\u210F");
            put("&planckh;", "\u210E");
            put("&plankv;", "\u210F");
            put("&plus;", "\u002B");
            put("&plusacir;", "\u2A23");
            put("&plusb;", "\u229E");
            put("&pluscir;", "\u2A22");
            put("&plusdo;", "\u2214");
            put("&plusdu;", "\u2A25");
            put("&pluse;", "\u2A72");
            put("&plusmn", "\u00B1");
            put("&plusmn;", "\u00B1");
            put("&plussim;", "\u2A26");
            put("&plustwo;", "\u2A27");
            put("&pm;", "\u00B1");
            put("&pointint;", "\u2A15");
            put("&popf;", "\uD835\uDD61");
            put("&pound", "\u00A3");
            put("&pound;", "\u00A3");
            put("&pr;", "\u227A");
            put("&prE;", "\u2AB3");
            put("&prap;", "\u2AB7");
            put("&prcue;", "\u227C");
            put("&pre;", "\u2AAF");
            put("&prec;", "\u227A");
            put("&precapprox;", "\u2AB7");
            put("&preccurlyeq;", "\u227C");
            put("&preceq;", "\u2AAF");
            put("&precnapprox;", "\u2AB9");
            put("&precneqq;", "\u2AB5");
            put("&precnsim;", "\u22E8");
            put("&precsim;", "\u227E");
            put("&prime;", "\u2032");
            put("&primes;", "\u2119");
            put("&prnE;", "\u2AB5");
            put("&prnap;", "\u2AB9");
            put("&prnsim;", "\u22E8");
            put("&prod;", "\u220F");
            put("&profalar;", "\u232E");
            put("&profline;", "\u2312");
            put("&profsurf;", "\u2313");
            put("&prop;", "\u221D");
            put("&propto;", "\u221D");
            put("&prsim;", "\u227E");
            put("&prurel;", "\u22B0");
            put("&pscr;", "\uD835\uDCC5");
            put("&psi;", "\u03C8");
            put("&puncsp;", "\u2008");
            put("&qfr;", "\uD835\uDD2E");
            put("&qint;", "\u2A0C");
            put("&qopf;", "\uD835\uDD62");
            put("&qprime;", "\u2057");
            put("&qscr;", "\uD835\uDCC6");
            put("&quaternions;", "\u210D");
            put("&quatint;", "\u2A16");
            put("&quest;", "\u003F");
            put("&questeq;", "\u225F");
            put("&quot", "\\u0022");
            put("&quot;", "\\u0022");
            put("&rAarr;", "\u21DB");
            put("&rArr;", "\u21D2");
            put("&rAtail;", "\u291C");
            put("&rBarr;", "\u290F");
            put("&rHar;", "\u2964");
            put("&race;", "\u223D\u0331");
            put("&racute;", "\u0155");
            put("&radic;", "\u221A");
            put("&raemptyv;", "\u29B3");
            put("&rang;", "\u27E9");
            put("&rangd;", "\u2992");
            put("&range;", "\u29A5");
            put("&rangle;", "\u27E9");
            put("&raquo", "\u00BB");
            put("&raquo;", "\u00BB");
            put("&rarr;", "\u2192");
            put("&rarrap;", "\u2975");
            put("&rarrb;", "\u21E5");
            put("&rarrbfs;", "\u2920");
            put("&rarrc;", "\u2933");
            put("&rarrfs;", "\u291E");
            put("&rarrhk;", "\u21AA");
            put("&rarrlp;", "\u21AC");
            put("&rarrpl;", "\u2945");
            put("&rarrsim;", "\u2974");
            put("&rarrtl;", "\u21A3");
            put("&rarrw;", "\u219D");
            put("&ratail;", "\u291A");
            put("&ratio;", "\u2236");
            put("&rationals;", "\u211A");
            put("&rbarr;", "\u290D");
            put("&rbbrk;", "\u2773");
            put("&rbrace;", "\u007D");
            put("&rbrack;", "\u005D");
            put("&rbrke;", "\u298C");
            put("&rbrksld;", "\u298E");
            put("&rbrkslu;", "\u2990");
            put("&rcaron;", "\u0159");
            put("&rcedil;", "\u0157");
            put("&rceil;", "\u2309");
            put("&rcub;", "\u007D");
            put("&rcy;", "\u0440");
            put("&rdca;", "\u2937");
            put("&rdldhar;", "\u2969");
            put("&rdquo;", "\u201D");
            put("&rdquor;", "\u201D");
            put("&rdsh;", "\u21B3");
            put("&real;", "\u211C");
            put("&realine;", "\u211B");
            put("&realpart;", "\u211C");
            put("&reals;", "\u211D");
            put("&rect;", "\u25AD");
            put("&reg", "\u00AE");
            put("&reg;", "\u00AE");
            put("&rfisht;", "\u297D");
            put("&rfloor;", "\u230B");
            put("&rfr;", "\uD835\uDD2F");
            put("&rhard;", "\u21C1");
            put("&rharu;", "\u21C0");
            put("&rharul;", "\u296C");
            put("&rho;", "\u03C1");
            put("&rhov;", "\u03F1");
            put("&rightarrow;", "\u2192");
            put("&rightarrowtail;", "\u21A3");
            put("&rightharpoondown;", "\u21C1");
            put("&rightharpoonup;", "\u21C0");
            put("&rightleftarrows;", "\u21C4");
            put("&rightleftharpoons;", "\u21CC");
            put("&rightrightarrows;", "\u21C9");
            put("&rightsquigarrow;", "\u219D");
            put("&rightthreetimes;", "\u22CC");
            put("&ring;", "\u02DA");
            put("&risingdotseq;", "\u2253");
            put("&rlarr;", "\u21C4");
            put("&rlhar;", "\u21CC");
            put("&rlm;", "\u200F");
            put("&rmoust;", "\u23B1");
            put("&rmoustache;", "\u23B1");
            put("&rnmid;", "\u2AEE");
            put("&roang;", "\u27ED");
            put("&roarr;", "\u21FE");
            put("&robrk;", "\u27E7");
            put("&ropar;", "\u2986");
            put("&ropf;", "\uD835\uDD63");
            put("&roplus;", "\u2A2E");
            put("&rotimes;", "\u2A35");
            put("&rpar;", "\u0029");
            put("&rpargt;", "\u2994");
            put("&rppolint;", "\u2A12");
            put("&rrarr;", "\u21C9");
            put("&rsaquo;", "\u203A");
            put("&rscr;", "\uD835\uDCC7");
            put("&rsh;", "\u21B1");
            put("&rsqb;", "\u005D");
            put("&rsquo;", "\u2019");
            put("&rsquor;", "\u2019");
            put("&rthree;", "\u22CC");
            put("&rtimes;", "\u22CA");
            put("&rtri;", "\u25B9");
            put("&rtrie;", "\u22B5");
            put("&rtrif;", "\u25B8");
            put("&rtriltri;", "\u29CE");
            put("&ruluhar;", "\u2968");
            put("&rx;", "\u211E");
            put("&sacute;", "\u015B");
            put("&sbquo;", "\u201A");
            put("&sc;", "\u227B");
            put("&scE;", "\u2AB4");
            put("&scap;", "\u2AB8");
            put("&scaron;", "\u0161");
            put("&sccue;", "\u227D");
            put("&sce;", "\u2AB0");
            put("&scedil;", "\u015F");
            put("&scirc;", "\u015D");
            put("&scnE;", "\u2AB6");
            put("&scnap;", "\u2ABA");
            put("&scnsim;", "\u22E9");
            put("&scpolint;", "\u2A13");
            put("&scsim;", "\u227F");
            put("&scy;", "\u0441");
            put("&sdot;", "\u22C5");
            put("&sdotb;", "\u22A1");
            put("&sdote;", "\u2A66");
            put("&seArr;", "\u21D8");
            put("&searhk;", "\u2925");
            put("&searr;", "\u2198");
            put("&searrow;", "\u2198");
            put("&sect", "\u00A7");
            put("&sect;", "\u00A7");
            put("&semi;", "\u003B");
            put("&seswar;", "\u2929");
            put("&setminus;", "\u2216");
            put("&setmn;", "\u2216");
            put("&sext;", "\u2736");
            put("&sfr;", "\uD835\uDD30");
            put("&sfrown;", "\u2322");
            put("&sharp;", "\u266F");
            put("&shchcy;", "\u0449");
            put("&shcy;", "\u0448");
            put("&shortmid;", "\u2223");
            put("&shortparallel;", "\u2225");
            put("&shy", "\u00AD");
            put("&shy;", "\u00AD");
            put("&sigma;", "\u03C3");
            put("&sigmaf;", "\u03C2");
            put("&sigmav;", "\u03C2");
            put("&sim;", "\u223C");
            put("&simdot;", "\u2A6A");
            put("&sime;", "\u2243");
            put("&simeq;", "\u2243");
            put("&simg;", "\u2A9E");
            put("&simgE;", "\u2AA0");
            put("&siml;", "\u2A9D");
            put("&simlE;", "\u2A9F");
            put("&simne;", "\u2246");
            put("&simplus;", "\u2A24");
            put("&simrarr;", "\u2972");
            put("&slarr;", "\u2190");
            put("&smallsetminus;", "\u2216");
            put("&smashp;", "\u2A33");
            put("&smeparsl;", "\u29E4");
            put("&smid;", "\u2223");
            put("&smile;", "\u2323");
            put("&smt;", "\u2AAA");
            put("&smte;", "\u2AAC");
            put("&smtes;", "\u2AAC\uFE00");
            put("&softcy;", "\u044C");
            put("&sol;", "\u002F");
            put("&solb;", "\u29C4");
            put("&solbar;", "\u233F");
            put("&sopf;", "\uD835\uDD64");
            put("&spades;", "\u2660");
            put("&spadesuit;", "\u2660");
            put("&spar;", "\u2225");
            put("&sqcap;", "\u2293");
            put("&sqcaps;", "\u2293\uFE00");
            put("&sqcup;", "\u2294");
            put("&sqcups;", "\u2294\uFE00");
            put("&sqsub;", "\u228F");
            put("&sqsube;", "\u2291");
            put("&sqsubset;", "\u228F");
            put("&sqsubseteq;", "\u2291");
            put("&sqsup;", "\u2290");
            put("&sqsupe;", "\u2292");
            put("&sqsupset;", "\u2290");
            put("&sqsupseteq;", "\u2292");
            put("&squ;", "\u25A1");
            put("&square;", "\u25A1");
            put("&squarf;", "\u25AA");
            put("&squf;", "\u25AA");
            put("&srarr;", "\u2192");
            put("&sscr;", "\uD835\uDCC8");
            put("&ssetmn;", "\u2216");
            put("&ssmile;", "\u2323");
            put("&sstarf;", "\u22C6");
            put("&star;", "\u2606");
            put("&starf;", "\u2605");
            put("&straightepsilon;", "\u03F5");
            put("&straightphi;", "\u03D5");
            put("&strns;", "\u00AF");
            put("&sub;", "\u2282");
            put("&subE;", "\u2AC5");
            put("&subdot;", "\u2ABD");
            put("&sube;", "\u2286");
            put("&subedot;", "\u2AC3");
            put("&submult;", "\u2AC1");
            put("&subnE;", "\u2ACB");
            put("&subne;", "\u228A");
            put("&subplus;", "\u2ABF");
            put("&subrarr;", "\u2979");
            put("&subset;", "\u2282");
            put("&subseteq;", "\u2286");
            put("&subseteqq;", "\u2AC5");
            put("&subsetneq;", "\u228A");
            put("&subsetneqq;", "\u2ACB");
            put("&subsim;", "\u2AC7");
            put("&subsub;", "\u2AD5");
            put("&subsup;", "\u2AD3");
            put("&succ;", "\u227B");
            put("&succapprox;", "\u2AB8");
            put("&succcurlyeq;", "\u227D");
            put("&succeq;", "\u2AB0");
            put("&succnapprox;", "\u2ABA");
            put("&succneqq;", "\u2AB6");
            put("&succnsim;", "\u22E9");
            put("&succsim;", "\u227F");
            put("&sum;", "\u2211");
            put("&sung;", "\u266A");
            put("&sup1", "\u00B9");
            put("&sup1;", "\u00B9");
            put("&sup2", "\u00B2");
            put("&sup2;", "\u00B2");
            put("&sup3", "\u00B3");
            put("&sup3;", "\u00B3");
            put("&sup;", "\u2283");
            put("&supE;", "\u2AC6");
            put("&supdot;", "\u2ABE");
            put("&supdsub;", "\u2AD8");
            put("&supe;", "\u2287");
            put("&supedot;", "\u2AC4");
            put("&suphsol;", "\u27C9");
            put("&suphsub;", "\u2AD7");
            put("&suplarr;", "\u297B");
            put("&supmult;", "\u2AC2");
            put("&supnE;", "\u2ACC");
            put("&supne;", "\u228B");
            put("&supplus;", "\u2AC0");
            put("&supset;", "\u2283");
            put("&supseteq;", "\u2287");
            put("&supseteqq;", "\u2AC6");
            put("&supsetneq;", "\u228B");
            put("&supsetneqq;", "\u2ACC");
            put("&supsim;", "\u2AC8");
            put("&supsub;", "\u2AD4");
            put("&supsup;", "\u2AD6");
            put("&swArr;", "\u21D9");
            put("&swarhk;", "\u2926");
            put("&swarr;", "\u2199");
            put("&swarrow;", "\u2199");
            put("&swnwar;", "\u292A");
            put("&szlig", "\u00DF");
            put("&szlig;", "\u00DF");
            put("&target;", "\u2316");
            put("&tau;", "\u03C4");
            put("&tbrk;", "\u23B4");
            put("&tcaron;", "\u0165");
            put("&tcedil;", "\u0163");
            put("&tcy;", "\u0442");
            put("&tdot;", "\u20DB");
            put("&telrec;", "\u2315");
            put("&tfr;", "\uD835\uDD31");
            put("&there4;", "\u2234");
            put("&therefore;", "\u2234");
            put("&theta;", "\u03B8");
            put("&thetasym;", "\u03D1");
            put("&thetav;", "\u03D1");
            put("&thickapprox;", "\u2248");
            put("&thicksim;", "\u223C");
            put("&thinsp;", "\u2009");
            put("&thkap;", "\u2248");
            put("&thksim;", "\u223C");
            put("&thorn", "\u00FE");
            put("&thorn;", "\u00FE");
            put("&tilde;", "\u02DC");
            put("&times", "\u00D7");
            put("&times;", "\u00D7");
            put("&timesb;", "\u22A0");
            put("&timesbar;", "\u2A31");
            put("&timesd;", "\u2A30");
            put("&tint;", "\u222D");
            put("&toea;", "\u2928");
            put("&top;", "\u22A4");
            put("&topbot;", "\u2336");
            put("&topcir;", "\u2AF1");
            put("&topf;", "\uD835\uDD65");
            put("&topfork;", "\u2ADA");
            put("&tosa;", "\u2929");
            put("&tprime;", "\u2034");
            put("&trade;", "\u2122");
            put("&triangle;", "\u25B5");
            put("&triangledown;", "\u25BF");
            put("&triangleleft;", "\u25C3");
            put("&trianglelefteq;", "\u22B4");
            put("&triangleq;", "\u225C");
            put("&triangleright;", "\u25B9");
            put("&trianglerighteq;", "\u22B5");
            put("&tridot;", "\u25EC");
            put("&trie;", "\u225C");
            put("&triminus;", "\u2A3A");
            put("&triplus;", "\u2A39");
            put("&trisb;", "\u29CD");
            put("&tritime;", "\u2A3B");
            put("&trpezium;", "\u23E2");
            put("&tscr;", "\uD835\uDCC9");
            put("&tscy;", "\u0446");
            put("&tshcy;", "\u045B");
            put("&tstrok;", "\u0167");
            put("&twixt;", "\u226C");
            put("&twoheadleftarrow;", "\u219E");
            put("&twoheadrightarrow;", "\u21A0");
            put("&uArr;", "\u21D1");
            put("&uHar;", "\u2963");
            put("&uacute", "\u00FA");
            put("&uacute;", "\u00FA");
            put("&uarr;", "\u2191");
            put("&ubrcy;", "\u045E");
            put("&ubreve;", "\u016D");
            put("&ucirc", "\u00FB");
            put("&ucirc;", "\u00FB");
            put("&ucy;", "\u0443");
            put("&udarr;", "\u21C5");
            put("&udblac;", "\u0171");
            put("&udhar;", "\u296E");
            put("&ufisht;", "\u297E");
            put("&ufr;", "\uD835\uDD32");
            put("&ugrave", "\u00F9");
            put("&ugrave;", "\u00F9");
            put("&uharl;", "\u21BF");
            put("&uharr;", "\u21BE");
            put("&uhblk;", "\u2580");
            put("&ulcorn;", "\u231C");
            put("&ulcorner;", "\u231C");
            put("&ulcrop;", "\u230F");
            put("&ultri;", "\u25F8");
            put("&umacr;", "\u016B");
            put("&uml", "\u00A8");
            put("&uml;", "\u00A8");
            put("&uogon;", "\u0173");
            put("&uopf;", "\uD835\uDD66");
            put("&uparrow;", "\u2191");
            put("&updownarrow;", "\u2195");
            put("&upharpoonleft;", "\u21BF");
            put("&upharpoonright;", "\u21BE");
            put("&uplus;", "\u228E");
            put("&upsi;", "\u03C5");
            put("&upsih;", "\u03D2");
            put("&upsilon;", "\u03C5");
            put("&upuparrows;", "\u21C8");
            put("&urcorn;", "\u231D");
            put("&urcorner;", "\u231D");
            put("&urcrop;", "\u230E");
            put("&uring;", "\u016F");
            put("&urtri;", "\u25F9");
            put("&uscr;", "\uD835\uDCCA");
            put("&utdot;", "\u22F0");
            put("&utilde;", "\u0169");
            put("&utri;", "\u25B5");
            put("&utrif;", "\u25B4");
            put("&uuarr;", "\u21C8");
            put("&uuml", "\u00FC");
            put("&uuml;", "\u00FC");
            put("&uwangle;", "\u29A7");
            put("&vArr;", "\u21D5");
            put("&vBar;", "\u2AE8");
            put("&vBarv;", "\u2AE9");
            put("&vDash;", "\u22A8");
            put("&vangrt;", "\u299C");
            put("&varepsilon;", "\u03F5");
            put("&varkappa;", "\u03F0");
            put("&varnothing;", "\u2205");
            put("&varphi;", "\u03D5");
            put("&varpi;", "\u03D6");
            put("&varpropto;", "\u221D");
            put("&varr;", "\u2195");
            put("&varrho;", "\u03F1");
            put("&varsigma;", "\u03C2");
            put("&varsubsetneq;", "\u228A\uFE00");
            put("&varsubsetneqq;", "\u2ACB\uFE00");
            put("&varsupsetneq;", "\u228B\uFE00");
            put("&varsupsetneqq;", "\u2ACC\uFE00");
            put("&vartheta;", "\u03D1");
            put("&vartriangleleft;", "\u22B2");
            put("&vartriangleright;", "\u22B3");
            put("&vcy;", "\u0432");
            put("&vdash;", "\u22A2");
            put("&vee;", "\u2228");
            put("&veebar;", "\u22BB");
            put("&veeeq;", "\u225A");
            put("&vellip;", "\u22EE");
            put("&verbar;", "\u007C");
            put("&vert;", "\u007C");
            put("&vfr;", "\uD835\uDD33");
            put("&vltri;", "\u22B2");
            put("&vnsub;", "\u2282\u20D2");
            put("&vnsup;", "\u2283\u20D2");
            put("&vopf;", "\uD835\uDD67");
            put("&vprop;", "\u221D");
            put("&vrtri;", "\u22B3");
            put("&vscr;", "\uD835\uDCCB");
            put("&vsubnE;", "\u2ACB\uFE00");
            put("&vsubne;", "\u228A\uFE00");
            put("&vsupnE;", "\u2ACC\uFE00");
            put("&vsupne;", "\u228B\uFE00");
            put("&vzigzag;", "\u299A");
            put("&wcirc;", "\u0175");
            put("&wedbar;", "\u2A5F");
            put("&wedge;", "\u2227");
            put("&wedgeq;", "\u2259");
            put("&weierp;", "\u2118");
            put("&wfr;", "\uD835\uDD34");
            put("&wopf;", "\uD835\uDD68");
            put("&wp;", "\u2118");
            put("&wr;", "\u2240");
            put("&wreath;", "\u2240");
            put("&wscr;", "\uD835\uDCCC");
            put("&xcap;", "\u22C2");
            put("&xcirc;", "\u25EF");
            put("&xcup;", "\u22C3");
            put("&xdtri;", "\u25BD");
            put("&xfr;", "\uD835\uDD35");
            put("&xhArr;", "\u27FA");
            put("&xharr;", "\u27F7");
            put("&xi;", "\u03BE");
            put("&xlArr;", "\u27F8");
            put("&xlarr;", "\u27F5");
            put("&xmap;", "\u27FC");
            put("&xnis;", "\u22FB");
            put("&xodot;", "\u2A00");
            put("&xopf;", "\uD835\uDD69");
            put("&xoplus;", "\u2A01");
            put("&xotime;", "\u2A02");
            put("&xrArr;", "\u27F9");
            put("&xrarr;", "\u27F6");
            put("&xscr;", "\uD835\uDCCD");
            put("&xsqcup;", "\u2A06");
            put("&xuplus;", "\u2A04");
            put("&xutri;", "\u25B3");
            put("&xvee;", "\u22C1");
            put("&xwedge;", "\u22C0");
            put("&yacute", "\u00FD");
            put("&yacute;", "\u00FD");
            put("&yacy;", "\u044F");
            put("&ycirc;", "\u0177");
            put("&ycy;", "\u044B");
            put("&yen", "\u00A5");
            put("&yen;", "\u00A5");
            put("&yfr;", "\uD835\uDD36");
            put("&yicy;", "\u0457");
            put("&yopf;", "\uD835\uDD6A");
            put("&yscr;", "\uD835\uDCCE");
            put("&yucy;", "\u044E");
            put("&yuml", "\u00FF");
            put("&yuml;", "\u00FF");
            put("&zacute;", "\u017A");
            put("&zcaron;", "\u017E");
            put("&zcy;", "\u0437");
            put("&zdot;", "\u017C");
            put("&zeetrf;", "\u2128");
            put("&zeta;", "\u03B6");
            put("&zfr;", "\uD835\uDD37");
            put("&zhcy;", "\u0436");
            put("&zigrarr;", "\u21DD");
            put("&zopf;", "\uD835\uDD6B");
            put("&zscr;", "\uD835\uDCCF");
            put("&zwj;", "\u200D");
            put("&zwnj;", "\u200C");
        }


    };

    public static final Map<String, String> encodedEntities = new HashMap<String, String>() {{
        put("\\u00C6", "&AElig;");
        put("\\u0026", "&AMP;");
        put("\\u00C1", "&Aacute;");
        put("\\u0102", "&Abreve;");
        put("\\u00C2", "&Acirc;");
        put("\\u0410", "&Acy;");
        put("\\uD835\\uDD04", "&Afr;");
        put("\\u00C0", "&Agrave;");
        put("\\u0391", "&Alpha;");
        put("\\u0100", "&Amacr;");
        put("\\u2A53", "&And;");
        put("\\u0104", "&Aogon;");
        put("\\uD835\\uDD38", "&Aopf;");
        put("\\u2061", "&ApplyFunction;");
        put("\\u00C5", "&Aring;");
        put("\\uD835\\uDC9C", "&Ascr;");
        put("\\u2254", "&Assign;");
        put("\\u00C3", "&Atilde;");
        put("\\u00C4", "&Auml;");
        put("\\u2216", "&Backslash;");
        put("\\u2AE7", "&Barv;");
        put("\\u2306", "&Barwed;");
        put("\\u0411", "&Bcy;");
        put("\\u2235", "&Because;");
        put("\\u212C", "&Bernoullis;");
        put("\\u0392", "&Beta;");
        put("\\uD835\\uDD05", "&Bfr;");
        put("\\uD835\\uDD39", "&Bopf;");
        put("\\u02D8", "&Breve;");
        put("\\u224E", "&Bumpeq;");
        put("\\u0427", "&CHcy;");
        put("\\u00A9", "&COPY;");
        put("\\u0106", "&Cacute;");
        put("\\u22D2", "&Cap;");
        put("\\u2145", "&CapitalDifferentialD;");
        put("\\u212D", "&Cayleys;");
        put("\\u010C", "&Ccaron;");
        put("\\u00C7", "&Ccedil;");
        put("\\u0108", "&Ccirc;");
        put("\\u2230", "&Cconint;");
        put("\\u010A", "&Cdot;");
        put("\\u00B8", "&Cedilla;");
        put("\\u00B7", "&CenterDot;");
        put("\\u03A7", "&Chi;");
        put("\\u2299", "&CircleDot;");
        put("\\u2296", "&CircleMinus;");
        put("\\u2295", "&CirclePlus;");
        put("\\u2297", "&CircleTimes;");
        put("\\u2232", "&ClockwiseContourIntegral;");
        put("\\u201D", "&CloseCurlyDoubleQuote;");
        put("\\u2019", "&CloseCurlyQuote;");
        put("\\u2237", "&Colon;");
        put("\\u2A74", "&Colone;");
        put("\\u2261", "&Congruent;");
        put("\\u222F", "&Conint;");
        put("\\u222E", "&ContourIntegral;");
        put("\\u2102", "&Copf;");
        put("\\u2210", "&Coproduct;");
        put("\\u2233", "&CounterClockwiseContourIntegral;");
        put("\\u2A2F", "&Cross;");
        put("\\uD835\\uDC9E", "&Cscr;");
        put("\\u22D3", "&Cup;");
        put("\\u224D", "&CupCap;");
        put("\\u2911", "&DDotrahd;");
        put("\\u0402", "&DJcy;");
        put("\\u0405", "&DScy;");
        put("\\u040F", "&DZcy;");
        put("\\u2021", "&Dagger;");
        put("\\u21A1", "&Darr;");
        put("\\u2AE4", "&Dashv;");
        put("\\u010E", "&Dcaron;");
        put("\\u0414", "&Dcy;");
        put("\\u2207", "&Del;");
        put("\\u0394", "&Delta;");
        put("\\uD835\\uDD07", "&Dfr;");
        put("\\u00B4", "&DiacriticalAcute;");
        put("\\u02D9", "&DiacriticalDot;");
        put("\\u02DD", "&DiacriticalDoubleAcute;");
        put("\\u0060", "&DiacriticalGrave;");
        put("\\u02DC", "&DiacriticalTilde;");
        put("\\u22C4", "&Diamond;");
        put("\\u2146", "&DifferentialD;");
        put("\\uD835\\uDD3B", "&Dopf;");
        put("\\u00A8", "&Dot;");
        put("\\u20DC", "&DotDot;");
        put("\\u2250", "&DotEqual;");
        put("\\u21D3", "&DoubleDownArrow;");
        put("\\u21D0", "&DoubleLeftArrow;");
        put("\\u21D4", "&DoubleLeftRightArrow;");
        put("\\u27F8", "&DoubleLongLeftArrow;");
        put("\\u27FA", "&DoubleLongLeftRightArrow;");
        put("\\u27F9", "&DoubleLongRightArrow;");
        put("\\u21D2", "&DoubleRightArrow;");
        put("\\u22A8", "&DoubleRightTee;");
        put("\\u21D1", "&DoubleUpArrow;");
        put("\\u21D5", "&DoubleUpDownArrow;");
        put("\\u2225", "&DoubleVerticalBar;");
        put("\\u2193", "&DownArrow;");
        put("\\u2913", "&DownArrowBar;");
        put("\\u21F5", "&DownArrowUpArrow;");
        put("\\u0311", "&DownBreve;");
        put("\\u2950", "&DownLeftRightVector;");
        put("\\u295E", "&DownLeftTeeVector;");
        put("\\u21BD", "&DownLeftVector;");
        put("\\u2956", "&DownLeftVectorBar;");
        put("\\u295F", "&DownRightTeeVector;");
        put("\\u21C1", "&DownRightVector;");
        put("\\u2957", "&DownRightVectorBar;");
        put("\\u22A4", "&DownTee;");
        put("\\u21A7", "&DownTeeArrow;");
        put("\\uD835\\uDC9F", "&Dscr;");
        put("\\u0110", "&Dstrok;");
        put("\\u014A", "&ENG;");
        put("\\u00D0", "&ETH;");
        put("\\u00C9", "&Eacute;");
        put("\\u011A", "&Ecaron;");
        put("\\u00CA", "&Ecirc;");
        put("\\u042D", "&Ecy;");
        put("\\u0116", "&Edot;");
        put("\\uD835\\uDD08", "&Efr;");
        put("\\u00C8", "&Egrave;");
        put("\\u2208", "&Element;");
        put("\\u0112", "&Emacr;");
        put("\\u25FB", "&EmptySmallSquare;");
        put("\\u25AB", "&EmptyVerySmallSquare;");
        put("\\u0118", "&Eogon;");
        put("\\uD835\\uDD3C", "&Eopf;");
        put("\\u0395", "&Epsilon;");
        put("\\u2A75", "&Equal;");
        put("\\u2242", "&EqualTilde;");
        put("\\u21CC", "&Equilibrium;");
        put("\\u2130", "&Escr;");
        put("\\u2A73", "&Esim;");
        put("\\u0397", "&Eta;");
        put("\\u00CB", "&Euml;");
        put("\\u2203", "&Exists;");
        put("\\u2147", "&ExponentialE;");
        put("\\u0424", "&Fcy;");
        put("\\uD835\\uDD09", "&Ffr;");
        put("\\u25FC", "&FilledSmallSquare;");
        put("\\u25AA", "&FilledVerySmallSquare;");
        put("\\uD835\\uDD3D", "&Fopf;");
        put("\\u2200", "&ForAll;");
        put("\\u2131", "&Fouriertrf;");
        put("\\u0403", "&GJcy;");
        put("\\u003E", "&GT;");
        put("\\u0393", "&Gamma;");
        put("\\u03DC", "&Gammad;");
        put("\\u011E", "&Gbreve;");
        put("\\u0122", "&Gcedil;");
        put("\\u011C", "&Gcirc;");
        put("\\u0413", "&Gcy;");
        put("\\u0120", "&Gdot;");
        put("\\uD835\\uDD0A", "&Gfr;");
        put("\\u22D9", "&Gg;");
        put("\\uD835\\uDD3E", "&Gopf;");
        put("\\u2265", "&GreaterEqual;");
        put("\\u22DB", "&GreaterEqualLess;");
        put("\\u2267", "&GreaterFullEqual;");
        put("\\u2AA2", "&GreaterGreater;");
        put("\\u2277", "&GreaterLess;");
        put("\\u2A7E", "&GreaterSlantEqual;");
        put("\\u2273", "&GreaterTilde;");
        put("\\uD835\\uDCA2", "&Gscr;");
        put("\\u226B", "&Gt;");
        put("\\u042A", "&HARDcy;");
        put("\\u02C7", "&Hacek;");
        put("\\u005E", "&Hat;");
        put("\\u0124", "&Hcirc;");
        put("\\u210C", "&Hfr;");
        put("\\u210B", "&HilbertSpace;");
        put("\\u210D", "&Hopf;");
        put("\\u2500", "&HorizontalLine;");
        put("\\u0126", "&Hstrok;");
        put("\\u224F", "&HumpEqual;");
        put("\\u0415", "&IEcy;");
        put("\\u0132", "&IJlig;");
        put("\\u0401", "&IOcy;");
        put("\\u00CD", "&Iacute;");
        put("\\u00CE", "&Icirc;");
        put("\\u0418", "&Icy;");
        put("\\u0130", "&Idot;");
        put("\\u2111", "&Ifr;");
        put("\\u00CC", "&Igrave;");
        put("\\u012A", "&Imacr;");
        put("\\u2148", "&ImaginaryI;");
        put("\\u222C", "&Int;");
        put("\\u222B", "&Integral;");
        put("\\u22C2", "&Intersection;");
        put("\\u2063", "&InvisibleComma;");
        put("\\u2062", "&InvisibleTimes;");
        put("\\u012E", "&Iogon;");
        put("\\uD835\\uDD40", "&Iopf;");
        put("\\u0399", "&Iota;");
        put("\\u2110", "&Iscr;");
        put("\\u0128", "&Itilde;");
        put("\\u0406", "&Iukcy;");
        put("\\u00CF", "&Iuml;");
        put("\\u0134", "&Jcirc;");
        put("\\u0419", "&Jcy;");
        put("\\uD835\\uDD0D", "&Jfr;");
        put("\\uD835\\uDD41", "&Jopf;");
        put("\\uD835\\uDCA5", "&Jscr;");
        put("\\u0408", "&Jsercy;");
        put("\\u0404", "&Jukcy;");
        put("\\u0425", "&KHcy;");
        put("\\u040C", "&KJcy;");
        put("\\u039A", "&Kappa;");
        put("\\u0136", "&Kcedil;");
        put("\\u041A", "&Kcy;");
        put("\\uD835\\uDD0E", "&Kfr;");
        put("\\uD835\\uDD42", "&Kopf;");
        put("\\uD835\\uDCA6", "&Kscr;");
        put("\\u0409", "&LJcy;");
        put("\\u003C", "&LT;");
        put("\\u0139", "&Lacute;");
        put("\\u039B", "&Lambda;");
        put("\\u27EA", "&Lang;");
        put("\\u2112", "&Laplacetrf;");
        put("\\u219E", "&Larr;");
        put("\\u013D", "&Lcaron;");
        put("\\u013B", "&Lcedil;");
        put("\\u041B", "&Lcy;");
        put("\\u27E8", "&LeftAngleBracket;");
        put("\\u2190", "&LeftArrow;");
        put("\\u21E4", "&LeftArrowBar;");
        put("\\u21C6", "&LeftArrowRightArrow;");
        put("\\u2308", "&LeftCeiling;");
        put("\\u27E6", "&LeftDoubleBracket;");
        put("\\u2961", "&LeftDownTeeVector;");
        put("\\u21C3", "&LeftDownVector;");
        put("\\u2959", "&LeftDownVectorBar;");
        put("\\u230A", "&LeftFloor;");
        put("\\u2194", "&LeftRightArrow;");
        put("\\u294E", "&LeftRightVector;");
        put("\\u22A3", "&LeftTee;");
        put("\\u21A4", "&LeftTeeArrow;");
        put("\\u295A", "&LeftTeeVector;");
        put("\\u22B2", "&LeftTriangle;");
        put("\\u29CF", "&LeftTriangleBar;");
        put("\\u22B4", "&LeftTriangleEqual;");
        put("\\u2951", "&LeftUpDownVector;");
        put("\\u2960", "&LeftUpTeeVector;");
        put("\\u21BF", "&LeftUpVector;");
        put("\\u2958", "&LeftUpVectorBar;");
        put("\\u21BC", "&LeftVector;");
        put("\\u2952", "&LeftVectorBar;");
        put("\\u22DA", "&LessEqualGreater;");
        put("\\u2266", "&LessFullEqual;");
        put("\\u2276", "&LessGreater;");
        put("\\u2AA1", "&LessLess;");
        put("\\u2A7D", "&LessSlantEqual;");
        put("\\u2272", "&LessTilde;");
        put("\\uD835\\uDD0F", "&Lfr;");
        put("\\u22D8", "&Ll;");
        put("\\u21DA", "&Lleftarrow;");
        put("\\u013F", "&Lmidot;");
        put("\\u27F5", "&LongLeftArrow;");
        put("\\u27F7", "&LongLeftRightArrow;");
        put("\\u27F6", "&LongRightArrow;");
        put("\\uD835\\uDD43", "&Lopf;");
        put("\\u2199", "&LowerLeftArrow;");
        put("\\u2198", "&LowerRightArrow;");
        put("\\u21B0", "&Lsh;");
        put("\\u0141", "&Lstrok;");
        put("\\u226A", "&Lt;");
        put("\\u2905", "&Map;");
        put("\\u041C", "&Mcy;");
        put("\\u205F", "&MediumSpace;");
        put("\\u2133", "&Mellintrf;");
        put("\\uD835\\uDD10", "&Mfr;");
        put("\\u2213", "&MinusPlus;");
        put("\\uD835\\uDD44", "&Mopf;");
        put("\\u039C", "&Mu;");
        put("\\u040A", "&NJcy;");
        put("\\u0143", "&Nacute;");
        put("\\u0147", "&Ncaron;");
        put("\\u0145", "&Ncedil;");
        put("\\u041D", "&Ncy;");
        put("\\u200B", "&NegativeMediumSpace;");
        put("\\u000A", "&NewLine;");
        put("\\uD835\\uDD11", "&Nfr;");
        put("\\u2060", "&NoBreak;");
        put("\\u00A0", "&NonBreakingSpace;");
        put("\\u2115", "&Nopf;");
        put("\\u2AEC", "&Not;");
        put("\\u2262", "&NotCongruent;");
        put("\\u226D", "&NotCupCap;");
        put("\\u2226", "&NotDoubleVerticalBar;");
        put("\\u2209", "&NotElement;");
        put("\\u2260", "&NotEqual;");
        put("\\u2242\\u0338", "&NotEqualTilde;");
        put("\\u2204", "&NotExists;");
        put("\\u226F", "&NotGreater;");
        put("\\u2271", "&NotGreaterEqual;");
        put("\\u2267\\u0338", "&NotGreaterFullEqual;");
        put("\\u226B\\u0338", "&NotGreaterGreater;");
        put("\\u2279", "&NotGreaterLess;");
        put("\\u2A7E\\u0338", "&NotGreaterSlantEqual;");
        put("\\u2275", "&NotGreaterTilde;");
        put("\\u224E\\u0338", "&NotHumpDownHump;");
        put("\\u224F\\u0338", "&NotHumpEqual;");
        put("\\u22EA", "&NotLeftTriangle;");
        put("\\u29CF\\u0338", "&NotLeftTriangleBar;");
        put("\\u22EC", "&NotLeftTriangleEqual;");
        put("\\u226E", "&NotLess;");
        put("\\u2270", "&NotLessEqual;");
        put("\\u2278", "&NotLessGreater;");
        put("\\u226A\\u0338", "&NotLessLess;");
        put("\\u2A7D\\u0338", "&NotLessSlantEqual;");
        put("\\u2274", "&NotLessTilde;");
        put("\\u2AA2\\u0338", "&NotNestedGreaterGreater;");
        put("\\u2AA1\\u0338", "&NotNestedLessLess;");
        put("\\u2280", "&NotPrecedes;");
        put("\\u2AAF\\u0338", "&NotPrecedesEqual;");
        put("\\u22E0", "&NotPrecedesSlantEqual;");
        put("\\u220C", "&NotReverseElement;");
        put("\\u22EB", "&NotRightTriangle;");
        put("\\u29D0\\u0338", "&NotRightTriangleBar;");
        put("\\u22ED", "&NotRightTriangleEqual;");
        put("\\u228F\\u0338", "&NotSquareSubset;");
        put("\\u22E2", "&NotSquareSubsetEqual;");
        put("\\u2290\\u0338", "&NotSquareSuperset;");
        put("\\u22E3", "&NotSquareSupersetEqual;");
        put("\\u2282\\u20D2", "&NotSubset;");
        put("\\u2288", "&NotSubsetEqual;");
        put("\\u2281", "&NotSucceeds;");
        put("\\u2AB0\\u0338", "&NotSucceedsEqual;");
        put("\\u22E1", "&NotSucceedsSlantEqual;");
        put("\\u227F\\u0338", "&NotSucceedsTilde;");
        put("\\u2283\\u20D2", "&NotSuperset;");
        put("\\u2289", "&NotSupersetEqual;");
        put("\\u2241", "&NotTilde;");
        put("\\u2244", "&NotTildeEqual;");
        put("\\u2247", "&NotTildeFullEqual;");
        put("\\u2249", "&NotTildeTilde;");
        put("\\u2224", "&NotVerticalBar;");
        put("\\uD835\\uDCA9", "&Nscr;");
        put("\\u00D1", "&Ntilde;");
        put("\\u039D", "&Nu;");
        put("\\u0152", "&OElig;");
        put("\\u00D3", "&Oacute;");
        put("\\u00D4", "&Ocirc;");
        put("\\u041E", "&Ocy;");
        put("\\u0150", "&Odblac;");
        put("\\uD835\\uDD12", "&Ofr;");
        put("\\u00D2", "&Ograve;");
        put("\\u014C", "&Omacr;");
        put("\\u03A9", "&Omega;");
        put("\\u039F", "&Omicron;");
        put("\\uD835\\uDD46", "&Oopf;");
        put("\\u201C", "&OpenCurlyDoubleQuote;");
        put("\\u2018", "&OpenCurlyQuote;");
        put("\\u2A54", "&Or;");
        put("\\uD835\\uDCAA", "&Oscr;");
        put("\\u00D8", "&Oslash;");
        put("\\u00D5", "&Otilde;");
        put("\\u2A37", "&Otimes;");
        put("\\u00D6", "&Ouml;");
        put("\\u203E", "&OverBar;");
        put("\\u23DE", "&OverBrace;");
        put("\\u23B4", "&OverBracket;");
        put("\\u23DC", "&OverParenthesis;");
        put("\\u2202", "&PartialD;");
        put("\\u041F", "&Pcy;");
        put("\\uD835\\uDD13", "&Pfr;");
        put("\\u03A6", "&Phi;");
        put("\\u03A0", "&Pi;");
        put("\\u00B1", "&PlusMinus;");
        put("\\u2119", "&Popf;");
        put("\\u2ABB", "&Pr;");
        put("\\u227A", "&Precedes;");
        put("\\u2AAF", "&PrecedesEqual;");
        put("\\u227C", "&PrecedesSlantEqual;");
        put("\\u227E", "&PrecedesTilde;");
        put("\\u2033", "&Prime;");
        put("\\u220F", "&Product;");
        put("\\u221D", "&Proportional;");
        put("\\uD835\\uDCAB", "&Pscr;");
        put("\\u03A8", "&Psi;");
        put("\\u0022", "&QUOT;");
        put("\\uD835\\uDD14", "&Qfr;");
        put("\\u211A", "&Qopf;");
        put("\\uD835\\uDCAC", "&Qscr;");
        put("\\u2910", "&RBarr;");
        put("\\u00AE", "&REG;");
        put("\\u0154", "&Racute;");
        put("\\u27EB", "&Rang;");
        put("\\u21A0", "&Rarr;");
        put("\\u2916", "&Rarrtl;");
        put("\\u0158", "&Rcaron;");
        put("\\u0156", "&Rcedil;");
        put("\\u0420", "&Rcy;");
        put("\\u211C", "&Re;");
        put("\\u220B", "&ReverseElement;");
        put("\\u21CB", "&ReverseEquilibrium;");
        put("\\u296F", "&ReverseUpEquilibrium;");
        put("\\u03A1", "&Rho;");
        put("\\u27E9", "&RightAngleBracket;");
        put("\\u2192", "&RightArrow;");
        put("\\u21E5", "&RightArrowBar;");
        put("\\u21C4", "&RightArrowLeftArrow;");
        put("\\u2309", "&RightCeiling;");
        put("\\u27E7", "&RightDoubleBracket;");
        put("\\u295D", "&RightDownTeeVector;");
        put("\\u21C2", "&RightDownVector;");
        put("\\u2955", "&RightDownVectorBar;");
        put("\\u230B", "&RightFloor;");
        put("\\u22A2", "&RightTee;");
        put("\\u21A6", "&RightTeeArrow;");
        put("\\u295B", "&RightTeeVector;");
        put("\\u22B3", "&RightTriangle;");
        put("\\u29D0", "&RightTriangleBar;");
        put("\\u22B5", "&RightTriangleEqual;");
        put("\\u294F", "&RightUpDownVector;");
        put("\\u295C", "&RightUpTeeVector;");
        put("\\u21BE", "&RightUpVector;");
        put("\\u2954", "&RightUpVectorBar;");
        put("\\u21C0", "&RightVector;");
        put("\\u2953", "&RightVectorBar;");
        put("\\u211D", "&Ropf;");
        put("\\u2970", "&RoundImplies;");
        put("\\u21DB", "&Rrightarrow;");
        put("\\u211B", "&Rscr;");
        put("\\u21B1", "&Rsh;");
        put("\\u29F4", "&RuleDelayed;");
        put("\\u0429", "&SHCHcy;");
        put("\\u0428", "&SHcy;");
        put("\\u042C", "&SOFTcy;");
        put("\\u015A", "&Sacute;");
        put("\\u2ABC", "&Sc;");
        put("\\u0160", "&Scaron;");
        put("\\u015E", "&Scedil;");
        put("\\u015C", "&Scirc;");
        put("\\u0421", "&Scy;");
        put("\\uD835\\uDD16", "&Sfr;");
        put("\\u2191", "&ShortUpArrow;");
        put("\\u03A3", "&Sigma;");
        put("\\u2218", "&SmallCircle;");
        put("\\uD835\\uDD4A", "&Sopf;");
        put("\\u221A", "&Sqrt;");
        put("\\u25A1", "&Square;");
        put("\\u2293", "&SquareIntersection;");
        put("\\u228F", "&SquareSubset;");
        put("\\u2291", "&SquareSubsetEqual;");
        put("\\u2290", "&SquareSuperset;");
        put("\\u2292", "&SquareSupersetEqual;");
        put("\\u2294", "&SquareUnion;");
        put("\\uD835\\uDCAE", "&Sscr;");
        put("\\u22C6", "&Star;");
        put("\\u22D0", "&Sub;");
        put("\\u2286", "&SubsetEqual;");
        put("\\u227B", "&Succeeds;");
        put("\\u2AB0", "&SucceedsEqual;");
        put("\\u227D", "&SucceedsSlantEqual;");
        put("\\u227F", "&SucceedsTilde;");
        put("\\u2211", "&Sum;");
        put("\\u22D1", "&Sup;");
        put("\\u2283", "&Superset;");
        put("\\u2287", "&SupersetEqual;");
        put("\\u00DE", "&THORN;");
        put("\\u2122", "&TRADE;");
        put("\\u040B", "&TSHcy;");
        put("\\u0426", "&TScy;");
        put("\\u0009", "&Tab;");
        put("\\u03A4", "&Tau;");
        put("\\u0164", "&Tcaron;");
        put("\\u0162", "&Tcedil;");
        put("\\u0422", "&Tcy;");
        put("\\uD835\\uDD17", "&Tfr;");
        put("\\u2234", "&Therefore;");
        put("\\u0398", "&Theta;");
        put("\\u205F\\u200A", "&ThickSpace;");
        put("\\u2009", "&ThinSpace;");
        put("\\u223C", "&Tilde;");
        put("\\u2243", "&TildeEqual;");
        put("\\u2245", "&TildeFullEqual;");
        put("\\u2248", "&TildeTilde;");
        put("\\uD835\\uDD4B", "&Topf;");
        put("\\u20DB", "&TripleDot;");
        put("\\uD835\\uDCAF", "&Tscr;");
        put("\\u0166", "&Tstrok;");
        put("\\u00DA", "&Uacute;");
        put("\\u219F", "&Uarr;");
        put("\\u2949", "&Uarrocir;");
        put("\\u040E", "&Ubrcy;");
        put("\\u016C", "&Ubreve;");
        put("\\u00DB", "&Ucirc;");
        put("\\u0423", "&Ucy;");
        put("\\u0170", "&Udblac;");
        put("\\uD835\\uDD18", "&Ufr;");
        put("\\u00D9", "&Ugrave;");
        put("\\u016A", "&Umacr;");
        put("\\u005F", "&UnderBar;");
        put("\\u23DF", "&UnderBrace;");
        put("\\u23B5", "&UnderBracket;");
        put("\\u23DD", "&UnderParenthesis;");
        put("\\u22C3", "&Union;");
        put("\\u228E", "&UnionPlus;");
        put("\\u0172", "&Uogon;");
        put("\\uD835\\uDD4C", "&Uopf;");
        put("\\u2912", "&UpArrowBar;");
        put("\\u21C5", "&UpArrowDownArrow;");
        put("\\u2195", "&UpDownArrow;");
        put("\\u296E", "&UpEquilibrium;");
        put("\\u22A5", "&UpTee;");
        put("\\u21A5", "&UpTeeArrow;");
        put("\\u2196", "&UpperLeftArrow;");
        put("\\u2197", "&UpperRightArrow;");
        put("\\u03D2", "&Upsi;");
        put("\\u03A5", "&Upsilon;");
        put("\\u016E", "&Uring;");
        put("\\uD835\\uDCB0", "&Uscr;");
        put("\\u0168", "&Utilde;");
        put("\\u00DC", "&Uuml;");
        put("\\u22AB", "&VDash;");
        put("\\u2AEB", "&Vbar;");
        put("\\u0412", "&Vcy;");
        put("\\u22A9", "&Vdash;");
        put("\\u2AE6", "&Vdashl;");
        put("\\u22C1", "&Vee;");
        put("\\u2016", "&Verbar;");
        put("\\u2223", "&VerticalBar;");
        put("\\u007C", "&VerticalLine;");
        put("\\u2758", "&VerticalSeparator;");
        put("\\u2240", "&VerticalTilde;");
        put("\\u200A", "&VeryThinSpace;");
        put("\\uD835\\uDD19", "&Vfr;");
        put("\\uD835\\uDD4D", "&Vopf;");
        put("\\uD835\\uDCB1", "&Vscr;");
        put("\\u22AA", "&Vvdash;");
        put("\\u0174", "&Wcirc;");
        put("\\u22C0", "&Wedge;");
        put("\\uD835\\uDD1A", "&Wfr;");
        put("\\uD835\\uDD4E", "&Wopf;");
        put("\\uD835\\uDCB2", "&Wscr;");
        put("\\uD835\\uDD1B", "&Xfr;");
        put("\\u039E", "&Xi;");
        put("\\uD835\\uDD4F", "&Xopf;");
        put("\\uD835\\uDCB3", "&Xscr;");
        put("\\u042F", "&YAcy;");
        put("\\u0407", "&YIcy;");
        put("\\u042E", "&YUcy;");
        put("\\u00DD", "&Yacute;");
        put("\\u0176", "&Ycirc;");
        put("\\u042B", "&Ycy;");
        put("\\uD835\\uDD1C", "&Yfr;");
        put("\\uD835\\uDD50", "&Yopf;");
        put("\\uD835\\uDCB4", "&Yscr;");
        put("\\u0178", "&Yuml;");
        put("\\u0416", "&ZHcy;");
        put("\\u0179", "&Zacute;");
        put("\\u017D", "&Zcaron;");
        put("\\u0417", "&Zcy;");
        put("\\u017B", "&Zdot;");
        put("\\u0396", "&Zeta;");
        put("\\u2128", "&Zfr;");
        put("\\u2124", "&Zopf;");
        put("\\uD835\\uDCB5", "&Zscr;");
        put("\\u00E1", "&aacute;");
        put("\\u0103", "&abreve;");
        put("\\u223E", "&ac;");
        put("\\u223E\\u0333", "&acE;");
        put("\\u223F", "&acd;");
        put("\\u00E2", "&acirc;");
        put("\\u0430", "&acy;");
        put("\\u00E6", "&aelig;");
        put("\\uD835\\uDD1E", "&afr;");
        put("\\u00E0", "&agrave;");
        put("\\u2135", "&alefsym;");
        put("\\u03B1", "&alpha;");
        put("\\u0101", "&amacr;");
        put("\\u2A3F", "&amalg;");
        put("\\u2227", "&and;");
        put("\\u2A55", "&andand;");
        put("\\u2A5C", "&andd;");
        put("\\u2A58", "&andslope;");
        put("\\u2A5A", "&andv;");
        put("\\u2220", "&ang;");
        put("\\u29A4", "&ange;");
        put("\\u2221", "&angmsd;");
        put("\\u29A8", "&angmsdaa;");
        put("\\u29A9", "&angmsdab;");
        put("\\u29AA", "&angmsdac;");
        put("\\u29AB", "&angmsdad;");
        put("\\u29AC", "&angmsdae;");
        put("\\u29AD", "&angmsdaf;");
        put("\\u29AE", "&angmsdag;");
        put("\\u29AF", "&angmsdah;");
        put("\\u221F", "&angrt;");
        put("\\u22BE", "&angrtvb;");
        put("\\u299D", "&angrtvbd;");
        put("\\u2222", "&angsph;");
        put("\\u237C", "&angzarr;");
        put("\\u0105", "&aogon;");
        put("\\uD835\\uDD52", "&aopf;");
        put("\\u2A70", "&apE;");
        put("\\u2A6F", "&apacir;");
        put("\\u224A", "&ape;");
        put("\\u224B", "&apid;");
        put("\\u0027", "&apos;");
        put("\\u00E5", "&aring;");
        put("\\uD835\\uDCB6", "&ascr;");
        put("\\u002A", "&ast;");
        put("\\u00E3", "&atilde;");
        put("\\u00E4", "&auml;");
        put("\\u2A11", "&awint;");
        put("\\u2AED", "&bNot;");
        put("\\u224C", "&backcong;");
        put("\\u03F6", "&backepsilon;");
        put("\\u2035", "&backprime;");
        put("\\u223D", "&backsim;");
        put("\\u22CD", "&backsimeq;");
        put("\\u22BD", "&barvee;");
        put("\\u2305", "&barwed;");
        put("\\u23B6", "&bbrktbrk;");
        put("\\u0431", "&bcy;");
        put("\\u201E", "&bdquo;");
        put("\\u29B0", "&bemptyv;");
        put("\\u03B2", "&beta;");
        put("\\u2136", "&beth;");
        put("\\u226C", "&between;");
        put("\\uD835\\uDD1F", "&bfr;");
        put("\\u25EF", "&bigcirc;");
        put("\\u2A00", "&bigodot;");
        put("\\u2A01", "&bigoplus;");
        put("\\u2A02", "&bigotimes;");
        put("\\u2A06", "&bigsqcup;");
        put("\\u2605", "&bigstar;");
        put("\\u25BD", "&bigtriangledown;");
        put("\\u25B3", "&bigtriangleup;");
        put("\\u2A04", "&biguplus;");
        put("\\u290D", "&bkarow;");
        put("\\u29EB", "&blacklozenge;");
        put("\\u25B4", "&blacktriangle;");
        put("\\u25BE", "&blacktriangledown;");
        put("\\u25C2", "&blacktriangleleft;");
        put("\\u25B8", "&blacktriangleright;");
        put("\\u2423", "&blank;");
        put("\\u2592", "&blk12;");
        put("\\u2591", "&blk14;");
        put("\\u2593", "&blk34;");
        put("\\u2588", "&block;");
        put("\\u003D\\u20E5", "&bne;");
        put("\\u2261\\u20E5", "&bnequiv;");
        put("\\u2310", "&bnot;");
        put("\\uD835\\uDD53", "&bopf;");
        put("\\u22C8", "&bowtie;");
        put("\\u2557", "&boxDL;");
        put("\\u2554", "&boxDR;");
        put("\\u2556", "&boxDl;");
        put("\\u2553", "&boxDr;");
        put("\\u2550", "&boxH;");
        put("\\u2566", "&boxHD;");
        put("\\u2569", "&boxHU;");
        put("\\u2564", "&boxHd;");
        put("\\u2567", "&boxHu;");
        put("\\u255D", "&boxUL;");
        put("\\u255A", "&boxUR;");
        put("\\u255C", "&boxUl;");
        put("\\u2559", "&boxUr;");
        put("\\u2551", "&boxV;");
        put("\\u256C", "&boxVH;");
        put("\\u2563", "&boxVL;");
        put("\\u2560", "&boxVR;");
        put("\\u256B", "&boxVh;");
        put("\\u2562", "&boxVl;");
        put("\\u255F", "&boxVr;");
        put("\\u29C9", "&boxbox;");
        put("\\u2555", "&boxdL;");
        put("\\u2552", "&boxdR;");
        put("\\u2510", "&boxdl;");
        put("\\u250C", "&boxdr;");
        put("\\u2565", "&boxhD;");
        put("\\u2568", "&boxhU;");
        put("\\u252C", "&boxhd;");
        put("\\u2534", "&boxhu;");
        put("\\u229F", "&boxminus;");
        put("\\u229E", "&boxplus;");
        put("\\u22A0", "&boxtimes;");
        put("\\u255B", "&boxuL;");
        put("\\u2558", "&boxuR;");
        put("\\u2518", "&boxul;");
        put("\\u2514", "&boxur;");
        put("\\u2502", "&boxv;");
        put("\\u256A", "&boxvH;");
        put("\\u2561", "&boxvL;");
        put("\\u255E", "&boxvR;");
        put("\\u253C", "&boxvh;");
        put("\\u2524", "&boxvl;");
        put("\\u251C", "&boxvr;");
        put("\\u00A6", "&brvbar;");
        put("\\uD835\\uDCB7", "&bscr;");
        put("\\u204F", "&bsemi;");
        put("\\u005C", "&bsol;");
        put("\\u29C5", "&bsolb;");
        put("\\u27C8", "&bsolhsub;");
        put("\\u2022", "&bull;");
        put("\\u2AAE", "&bumpE;");
        put("\\u0107", "&cacute;");
        put("\\u2229", "&cap;");
        put("\\u2A44", "&capand;");
        put("\\u2A49", "&capbrcup;");
        put("\\u2A4B", "&capcap;");
        put("\\u2A47", "&capcup;");
        put("\\u2A40", "&capdot;");
        put("\\u2229\\uFE00", "&caps;");
        put("\\u2041", "&caret;");
        put("\\u2A4D", "&ccaps;");
        put("\\u010D", "&ccaron;");
        put("\\u00E7", "&ccedil;");
        put("\\u0109", "&ccirc;");
        put("\\u2A4C", "&ccups;");
        put("\\u2A50", "&ccupssm;");
        put("\\u010B", "&cdot;");
        put("\\u29B2", "&cemptyv;");
        put("\\u00A2", "&cent;");
        put("\\uD835\\uDD20", "&cfr;");
        put("\\u0447", "&chcy;");
        put("\\u2713", "&check;");
        put("\\u03C7", "&chi;");
        put("\\u25CB", "&cir;");
        put("\\u29C3", "&cirE;");
        put("\\u02C6", "&circ;");
        put("\\u2257", "&circeq;");
        put("\\u21BA", "&circlearrowleft;");
        put("\\u21BB", "&circlearrowright;");
        put("\\u24C8", "&circledS;");
        put("\\u229B", "&circledast;");
        put("\\u229A", "&circledcirc;");
        put("\\u229D", "&circleddash;");
        put("\\u2A10", "&cirfnint;");
        put("\\u2AEF", "&cirmid;");
        put("\\u29C2", "&cirscir;");
        put("\\u2663", "&clubs;");
        put("\\u003A", "&colon;");
        put("\\u002C", "&comma;");
        put("\\u0040", "&commat;");
        put("\\u2201", "&comp;");
        put("\\u2A6D", "&congdot;");
        put("\\uD835\\uDD54", "&copf;");
        put("\\u2117", "&copysr;");
        put("\\u21B5", "&crarr;");
        put("\\u2717", "&cross;");
        put("\\uD835\\uDCB8", "&cscr;");
        put("\\u2ACF", "&csub;");
        put("\\u2AD1", "&csube;");
        put("\\u2AD0", "&csup;");
        put("\\u2AD2", "&csupe;");
        put("\\u22EF", "&ctdot;");
        put("\\u2938", "&cudarrl;");
        put("\\u2935", "&cudarrr;");
        put("\\u22DE", "&cuepr;");
        put("\\u22DF", "&cuesc;");
        put("\\u21B6", "&cularr;");
        put("\\u293D", "&cularrp;");
        put("\\u222A", "&cup;");
        put("\\u2A48", "&cupbrcap;");
        put("\\u2A46", "&cupcap;");
        put("\\u2A4A", "&cupcup;");
        put("\\u228D", "&cupdot;");
        put("\\u2A45", "&cupor;");
        put("\\u222A\\uFE00", "&cups;");
        put("\\u21B7", "&curarr;");
        put("\\u293C", "&curarrm;");
        put("\\u22CE", "&curlyvee;");
        put("\\u22CF", "&curlywedge;");
        put("\\u00A4", "&curren;");
        put("\\u2231", "&cwint;");
        put("\\u232D", "&cylcty;");
        put("\\u2965", "&dHar;");
        put("\\u2020", "&dagger;");
        put("\\u2138", "&daleth;");
        put("\\u2010", "&dash;");
        put("\\u290F", "&dbkarow;");
        put("\\u010F", "&dcaron;");
        put("\\u0434", "&dcy;");
        put("\\u21CA", "&ddarr;");
        put("\\u2A77", "&ddotseq;");
        put("\\u00B0", "&deg;");
        put("\\u03B4", "&delta;");
        put("\\u29B1", "&demptyv;");
        put("\\u297F", "&dfisht;");
        put("\\uD835\\uDD21", "&dfr;");
        put("\\u2666", "&diamondsuit;");
        put("\\u03DD", "&digamma;");
        put("\\u22F2", "&disin;");
        put("\\u00F7", "&div;");
        put("\\u22C7", "&divideontimes;");
        put("\\u0452", "&djcy;");
        put("\\u231E", "&dlcorn;");
        put("\\u230D", "&dlcrop;");
        put("\\u0024", "&dollar;");
        put("\\uD835\\uDD55", "&dopf;");
        put("\\u2251", "&doteqdot;");
        put("\\u2238", "&dotminus;");
        put("\\u2214", "&dotplus;");
        put("\\u22A1", "&dotsquare;");
        put("\\u231F", "&drcorn;");
        put("\\u230C", "&drcrop;");
        put("\\uD835\\uDCB9", "&dscr;");
        put("\\u0455", "&dscy;");
        put("\\u29F6", "&dsol;");
        put("\\u0111", "&dstrok;");
        put("\\u22F1", "&dtdot;");
        put("\\u29A6", "&dwangle;");
        put("\\u045F", "&dzcy;");
        put("\\u2A6E", "&easter;");
        put("\\u011B", "&ecaron;");
        put("\\u2256", "&ecir;");
        put("\\u2255", "&ecolon;");
        put("\\u044D", "&ecy;");
        put("\\u2252", "&efDot;");
        put("\\uD835\\uDD22", "&efr;");
        put("\\u2A9A", "&eg;");
        put("\\u2A96", "&egs;");
        put("\\u2A98", "&egsdot;");
        put("\\u2A99", "&el;");
        put("\\u23E7", "&elinters;");
        put("\\u2113", "&ell;");
        put("\\u2A95", "&els;");
        put("\\u2A97", "&elsdot;");
        put("\\u0113", "&emacr;");
        put("\\u2004", "&emsp13;");
        put("\\u2005", "&emsp14;");
        put("\\u2003", "&emsp;");
        put("\\u014B", "&eng;");
        put("\\u2002", "&ensp;");
        put("\\u0119", "&eogon;");
        put("\\uD835\\uDD56", "&eopf;");
        put("\\u22D5", "&epar;");
        put("\\u29E3", "&eparsl;");
        put("\\u2A71", "&eplus;");
        put("\\u03B5", "&epsi;");
        put("\\u03F5", "&epsiv;");
        put("\\u003D", "&equals;");
        put("\\u225F", "&equest;");
        put("\\u2A78", "&equivDD;");
        put("\\u29E5", "&eqvparsl;");
        put("\\u2253", "&erDot;");
        put("\\u2971", "&erarr;");
        put("\\u212F", "&escr;");
        put("\\u03B7", "&eta;");
        put("\\u00F0", "&eth;");
        put("\\u00EB", "&euml;");
        put("\\u20AC", "&euro;");
        put("\\u0021", "&excl;");
        put("\\u0444", "&fcy;");
        put("\\u2640", "&female;");
        put("\\uFB03", "&ffilig;");
        put("\\uFB00", "&fflig;");
        put("\\uFB04", "&ffllig;");
        put("\\uD835\\uDD23", "&ffr;");
        put("\\uFB01", "&filig;");
        put("\\u0066\\u006A", "&fjlig;");
        put("\\u266D", "&flat;");
        put("\\uFB02", "&fllig;");
        put("\\u25B1", "&fltns;");
        put("\\u0192", "&fnof;");
        put("\\uD835\\uDD57", "&fopf;");
        put("\\u22D4", "&fork;");
        put("\\u2AD9", "&forkv;");
        put("\\u2A0D", "&fpartint;");
        put("\\u00BD", "&frac12;");
        put("\\u2153", "&frac13;");
        put("\\u00BC", "&frac14;");
        put("\\u2155", "&frac15;");
        put("\\u2159", "&frac16;");
        put("\\u215B", "&frac18;");
        put("\\u2154", "&frac23;");
        put("\\u2156", "&frac25;");
        put("\\u00BE", "&frac34;");
        put("\\u2157", "&frac35;");
        put("\\u215C", "&frac38;");
        put("\\u2158", "&frac45;");
        put("\\u215A", "&frac56;");
        put("\\u215D", "&frac58;");
        put("\\u215E", "&frac78;");
        put("\\u2044", "&frasl;");
        put("\\u2322", "&frown;");
        put("\\uD835\\uDCBB", "&fscr;");
        put("\\u00E9", "&eacute;");
        put("\\u2A8C", "&gEl;");
        put("\\u01F5", "&gacute;");
        put("\\u03B3", "&gamma;");
        put("\\u2A86", "&gap;");
        put("\\u011F", "&gbreve;");
        put("\\u011D", "&gcirc;");
        put("\\u0433", "&gcy;");
        put("\\u0121", "&gdot;");
        put("\\u2AA9", "&gescc;");
        put("\\u2A80", "&gesdot;");
        put("\\u2A82", "&gesdoto;");
        put("\\u2A84", "&gesdotol;");
        put("\\u22DB\\uFE00", "&gesl;");
        put("\\u2A94", "&gesles;");
        put("\\uD835\\uDD24", "&gfr;");
        put("\\u2137", "&gimel;");
        put("\\u0453", "&gjcy;");
        put("\\u2A92", "&glE;");
        put("\\u2AA5", "&gla;");
        put("\\u2AA4", "&glj;");
        put("\\u2269", "&gnE;");
        put("\\u2A8A", "&gnap;");
        put("\\u2A88", "&gne;");
        put("\\u22E7", "&gnsim;");
        put("\\uD835\\uDD58", "&gopf;");
        put("\\u210A", "&gscr;");
        put("\\u2A8E", "&gsime;");
        put("\\u2A90", "&gsiml;");
        put("\\u2AA7", "&gtcc;");
        put("\\u2A7A", "&gtcir;");
        put("\\u22D7", "&gtdot;");
        put("\\u2995", "&gtlPar;");
        put("\\u2A7C", "&gtquest;");
        put("\\u2978", "&gtrarr;");
        put("\\u2269\\uFE00", "&gvertneqq;");
        put("\\u044A", "&hardcy;");
        put("\\u2948", "&harrcir;");
        put("\\u21AD", "&harrw;");
        put("\\u210F", "&hbar;");
        put("\\u0125", "&hcirc;");
        put("\\u2665", "&hearts;");
        put("\\u2026", "&hellip;");
        put("\\u22B9", "&hercon;");
        put("\\uD835\\uDD25", "&hfr;");
        put("\\u2925", "&hksearow;");
        put("\\u2926", "&hkswarow;");
        put("\\u21FF", "&hoarr;");
        put("\\u223B", "&homtht;");
        put("\\u21A9", "&hookleftarrow;");
        put("\\u21AA", "&hookrightarrow;");
        put("\\uD835\\uDD59", "&hopf;");
        put("\\u2015", "&horbar;");
        put("\\uD835\\uDCBD", "&hscr;");
        put("\\u0127", "&hstrok;");
        put("\\u2043", "&hybull;");
        put("\\u00ED", "&iacute;");
        put("\\u00EE", "&icirc;");
        put("\\u0438", "&icy;");
        put("\\u0435", "&iecy;");
        put("\\u00A1", "&iexcl;");
        put("\\uD835\\uDD26", "&ifr;");
        put("\\u00EC", "&igrave;");
        put("\\u2A0C", "&iiiint;");
        put("\\u222D", "&iiint;");
        put("\\u29DC", "&iinfin;");
        put("\\u2129", "&iiota;");
        put("\\u0133", "&ijlig;");
        put("\\u012B", "&imacr;");
        put("\\u0131", "&imath;");
        put("\\u22B7", "&imof;");
        put("\\u01B5", "&imped;");
        put("\\u2105", "&incare;");
        put("\\u221E", "&infin;");
        put("\\u29DD", "&infintie;");
        put("\\u22BA", "&intcal;");
        put("\\u2A17", "&intlarhk;");
        put("\\u2A3C", "&intprod;");
        put("\\u0451", "&iocy;");
        put("\\u012F", "&iogon;");
        put("\\uD835\\uDD5A", "&iopf;");
        put("\\u03B9", "&iota;");
        put("\\u00BF", "&iquest;");
        put("\\uD835\\uDCBE", "&iscr;");
        put("\\u22F9", "&isinE;");
        put("\\u22F5", "&isindot;");
        put("\\u22F4", "&isins;");
        put("\\u22F3", "&isinsv;");
        put("\\u0129", "&itilde;");
        put("\\u0456", "&iukcy;");
        put("\\u00EF", "&iuml;");
        put("\\u0135", "&jcirc;");
        put("\\u0439", "&jcy;");
        put("\\uD835\\uDD27", "&jfr;");
        put("\\u0237", "&jmath;");
        put("\\uD835\\uDD5B", "&jopf;");
        put("\\uD835\\uDCBF", "&jscr;");
        put("\\u0458", "&jsercy;");
        put("\\u0454", "&jukcy;");
        put("\\u03BA", "&kappa;");
        put("\\u03F0", "&kappav;");
        put("\\u0137", "&kcedil;");
        put("\\u043A", "&kcy;");
        put("\\uD835\\uDD28", "&kfr;");
        put("\\u0138", "&kgreen;");
        put("\\u0445", "&khcy;");
        put("\\u045C", "&kjcy;");
        put("\\uD835\\uDD5C", "&kopf;");
        put("\\uD835\\uDCC0", "&kscr;");
        put("\\u291B", "&lAtail;");
        put("\\u290E", "&lBarr;");
        put("\\u2A8B", "&lEg;");
        put("\\u2962", "&lHar;");
        put("\\u013A", "&lacute;");
        put("\\u29B4", "&laemptyv;");
        put("\\u03BB", "&lambda;");
        put("\\u2991", "&langd;");
        put("\\u2A85", "&lap;");
        put("\\u00AB", "&laquo;");
        put("\\u291F", "&larrbfs;");
        put("\\u291D", "&larrfs;");
        put("\\u21AB", "&larrlp;");
        put("\\u2939", "&larrpl;");
        put("\\u2973", "&larrsim;");
        put("\\u21A2", "&larrtl;");
        put("\\u2AAB", "&lat;");
        put("\\u2919", "&latail;");
        put("\\u2AAD", "&late;");
        put("\\u2AAD\\uFE00", "&lates;");
        put("\\u290C", "&lbarr;");
        put("\\u2772", "&lbbrk;");
        put("\\u007B", "&lbrace;");
        put("\\u005B", "&lbrack;");
        put("\\u298B", "&lbrke;");
        put("\\u298F", "&lbrksld;");
        put("\\u298D", "&lbrkslu;");
        put("\\u013E", "&lcaron;");
        put("\\u013C", "&lcedil;");
        put("\\u043B", "&lcy;");
        put("\\u2936", "&ldca;");
        put("\\u2967", "&ldrdhar;");
        put("\\u294B", "&ldrushar;");
        put("\\u21B2", "&ldsh;");
        put("\\u2264", "&le;");
        put("\\u21C7", "&leftleftarrows;");
        put("\\u22CB", "&leftthreetimes;");
        put("\\u2AA8", "&lescc;");
        put("\\u2A7F", "&lesdot;");
        put("\\u2A81", "&lesdoto;");
        put("\\u2A83", "&lesdotor;");
        put("\\u22DA\\uFE00", "&lesg;");
        put("\\u2A93", "&lesges;");
        put("\\u22D6", "&lessdot;");
        put("\\u297C", "&lfisht;");
        put("\\uD835\\uDD29", "&lfr;");
        put("\\u2A91", "&lgE;");
        put("\\u296A", "&lharul;");
        put("\\u2584", "&lhblk;");
        put("\\u0459", "&ljcy;");
        put("\\u296B", "&llhard;");
        put("\\u25FA", "&lltri;");
        put("\\u0140", "&lmidot;");
        put("\\u23B0", "&lmoust;");
        put("\\u2268", "&lnE;");
        put("\\u2A89", "&lnap;");
        put("\\u2A87", "&lne;");
        put("\\u22E6", "&lnsim;");
        put("\\u27EC", "&loang;");
        put("\\u21FD", "&loarr;");
        put("\\u21AC", "&looparrowright;");
        put("\\u2985", "&lopar;");
        put("\\uD835\\uDD5D", "&lopf;");
        put("\\u2A2D", "&loplus;");
        put("\\u2A34", "&lotimes;");
        put("\\u2217", "&lowast;");
        put("\\u25CA", "&loz;");
        put("\\u0028", "&lpar;");
        put("\\u2993", "&lparlt;");
        put("\\u296D", "&lrhard;");
        put("\\u200E", "&lrm;");
        put("\\u22BF", "&lrtri;");
        put("\\u2039", "&lsaquo;");
        put("\\uD835\\uDCC1", "&lscr;");
        put("\\u2A8D", "&lsime;");
        put("\\u2A8F", "&lsimg;");
        put("\\u201A", "&lsquor;");
        put("\\u0142", "&lstrok;");
        put("\\u2AA6", "&ltcc;");
        put("\\u2A79", "&ltcir;");
        put("\\u22C9", "&ltimes;");
        put("\\u2976", "&ltlarr;");
        put("\\u2A7B", "&ltquest;");
        put("\\u2996", "&ltrPar;");
        put("\\u25C3", "&ltri;");
        put("\\u294A", "&lurdshar;");
        put("\\u2966", "&luruhar;");
        put("\\u2268\\uFE00", "&lvertneqq;");
        put("\\u223A", "&mDDot;");
        put("\\u00AF", "&macr;");
        put("\\u2642", "&male;");
        put("\\u2720", "&malt;");
        put("\\u25AE", "&marker;");
        put("\\u2A29", "&mcomma;");
        put("\\u043C", "&mcy;");
        put("\\u2014", "&mdash;");
        put("\\uD835\\uDD2A", "&mfr;");
        put("\\u2127", "&mho;");
        put("\\u00B5", "&micro;");
        put("\\u2AF0", "&midcir;");
        put("\\u2212", "&minus;");
        put("\\u2A2A", "&minusdu;");
        put("\\u2ADB", "&mlcp;");
        put("\\u22A7", "&models;");
        put("\\uD835\\uDD5E", "&mopf;");
        put("\\uD835\\uDCC2", "&mscr;");
        put("\\u03BC", "&mu;");
        put("\\u22B8", "&multimap;");
        put("\\u22D9\\u0338", "&nGg;");
        put("\\u226B\\u20D2", "&nGt;");
        put("\\u21CD", "&nLeftarrow;");
        put("\\u21CE", "&nLeftrightarrow;");
        put("\\u22D8\\u0338", "&nLl;");
        put("\\u226A\\u20D2", "&nLt;");
        put("\\u21CF", "&nRightarrow;");
        put("\\u22AF", "&nVDash;");
        put("\\u22AE", "&nVdash;");
        put("\\u0144", "&nacute;");
        put("\\u2220\\u20D2", "&nang;");
        put("\\u2A70\\u0338", "&napE;");
        put("\\u224B\\u0338", "&napid;");
        put("\\u0149", "&napos;");
        put("\\u266E", "&natur;");
        put("\\u2A43", "&ncap;");
        put("\\u0148", "&ncaron;");
        put("\\u0146", "&ncedil;");
        put("\\u2A6D\\u0338", "&ncongdot;");
        put("\\u2A42", "&ncup;");
        put("\\u043D", "&ncy;");
        put("\\u2013", "&ndash;");
        put("\\u21D7", "&neArr;");
        put("\\u2924", "&nearhk;");
        put("\\u2250\\u0338", "&nedot;");
        put("\\u2928", "&nesear;");
        put("\\uD835\\uDD2B", "&nfr;");
        put("\\u21AE", "&nharr;");
        put("\\u2AF2", "&nhpar;");
        put("\\u22FC", "&nis;");
        put("\\u22FA", "&nisd;");
        put("\\u045A", "&njcy;");
        put("\\u2266\\u0338", "&nlE;");
        put("\\u219A", "&nlarr;");
        put("\\u2025", "&nldr;");
        put("\\uD835\\uDD5F", "&nopf;");
        put("\\u00AC", "&not;");
        put("\\u22F9\\u0338", "&notinE;");
        put("\\u22F5\\u0338", "&notindot;");
        put("\\u22F7", "&notinvb;");
        put("\\u22F6", "&notinvc;");
        put("\\u22FE", "&notnivb;");
        put("\\u22FD", "&notnivc;");
        put("\\u2AFD\\u20E5", "&nparsl;");
        put("\\u2202\\u0338", "&npart;");
        put("\\u2A14", "&npolint;");
        put("\\u219B", "&nrarr;");
        put("\\u2933\\u0338", "&nrarrc;");
        put("\\u219D\\u0338", "&nrarrw;");
        put("\\uD835\\uDCC3", "&nscr;");
        put("\\u2284", "&nsub;");
        put("\\u2AC5\\u0338", "&nsubE;");
        put("\\u2285", "&nsup;");
        put("\\u2AC6\\u0338", "&nsupE;");
        put("\\u03BD", "&nu;");
        put("\\u0023", "&num;");
        put("\\u2116", "&numero;");
        put("\\u2007", "&numsp;");
        put("\\u22AD", "&nvDash;");
        put("\\u2904", "&nvHarr;");
        put("\\u224D\\u20D2", "&nvap;");
        put("\\u22AC", "&nvdash;");
        put("\\u2265\\u20D2", "&nvge;");
        put("\\u003E\\u20D2", "&nvgt;");
        put("\\u29DE", "&nvinfin;");
        put("\\u2902", "&nvlArr;");
        put("\\u2264\\u20D2", "&nvle;");
        put("\\u003C\\u20D2", "&nvlt;");
        put("\\u22B4\\u20D2", "&nvltrie;");
        put("\\u2903", "&nvrArr;");
        put("\\u22B5\\u20D2", "&nvrtrie;");
        put("\\u223C\\u20D2", "&nvsim;");
        put("\\u21D6", "&nwArr;");
        put("\\u2923", "&nwarhk;");
        put("\\u2927", "&nwnear;");
        put("\\u00F3", "&oacute;");
        put("\\u00F4", "&ocirc;");
        put("\\u043E", "&ocy;");
        put("\\u0151", "&odblac;");
        put("\\u2A38", "&odiv;");
        put("\\u29BC", "&odsold;");
        put("\\u0153", "&oelig;");
        put("\\u29BF", "&ofcir;");
        put("\\uD835\\uDD2C", "&ofr;");
        put("\\u02DB", "&ogon;");
        put("\\u00F2", "&ograve;");
        put("\\u29C1", "&ogt;");
        put("\\u29B5", "&ohbar;");
        put("\\u29BE", "&olcir;");
        put("\\u29BB", "&olcross;");
        put("\\u29C0", "&olt;");
        put("\\u014D", "&omacr;");
        put("\\u03C9", "&omega;");
        put("\\u03BF", "&omicron;");
        put("\\u29B6", "&omid;");
        put("\\uD835\\uDD60", "&oopf;");
        put("\\u29B7", "&opar;");
        put("\\u29B9", "&operp;");
        put("\\u2228", "&or;");
        put("\\u2A5D", "&ord;");
        put("\\u2134", "&order;");
        put("\\u00AA", "&ordf;");
        put("\\u00BA", "&ordm;");
        put("\\u22B6", "&origof;");
        put("\\u2A56", "&oror;");
        put("\\u2A57", "&orslope;");
        put("\\u2298", "&osol;");
        put("\\u2A36", "&otimesas;");
        put("\\u2AF3", "&parsim;");
        put("\\u043F", "&pcy;");
        put("\\u0025", "&percnt;");
        put("\\u002E", "&period;");
        put("\\u2031", "&pertenk;");
        put("\\uD835\\uDD2D", "&pfr;");
        put("\\u03C6", "&phi;");
        put("\\u260E", "&phone;");
        put("\\u002B", "&plus;");
        put("\\u2A25", "&plusdu;");
        put("\\u2A72", "&pluse;");
        put("\\u2A26", "&plussim;");
        put("\\u2A27", "&plustwo;");
        put("\\u2A15", "&pointint;");
        put("\\uD835\\uDD61", "&popf;");
        put("\\u00A3", "&pound;");
        put("\\u2AB3", "&prE;");
        put("\\u2AB7", "&prap;");
        put("\\u2AB9", "&precnapprox;");
        put("\\u2AB5", "&precneqq;");
        put("\\u22E8", "&precnsim;");
        put("\\u2032", "&prime;");
        put("\\u232E", "&profalar;");
        put("\\u2312", "&profline;");
        put("\\u2313", "&profsurf;");
        put("\\u22B0", "&prurel;");
        put("\\uD835\\uDCC5", "&pscr;");
        put("\\u03C8", "&psi;");
        put("\\u2008", "&puncsp;");
        put("\\uD835\\uDD2E", "&qfr;");
        put("\\uD835\\uDD62", "&qopf;");
        put("\\u2057", "&qprime;");
        put("\\uD835\\uDCC6", "&qscr;");
        put("\\u2A16", "&quatint;");
        put("\\u003F", "&quest;");
        put("\\u291C", "&rAtail;");
        put("\\u2964", "&rHar;");
        put("\\u223D\\u0331", "&race;");
        put("\\u0155", "&racute;");
        put("\\u29B3", "&raemptyv;");
        put("\\u2992", "&rangd;");
        put("\\u29A5", "&range;");
        put("\\u00BB", "&raquo;");
        put("\\u2975", "&rarrap;");
        put("\\u2920", "&rarrbfs;");
        put("\\u2933", "&rarrc;");
        put("\\u291E", "&rarrfs;");
        put("\\u2945", "&rarrpl;");
        put("\\u2974", "&rarrsim;");
        put("\\u21A3", "&rarrtl;");
        put("\\u219D", "&rarrw;");
        put("\\u291A", "&ratail;");
        put("\\u2236", "&ratio;");
        put("\\u2773", "&rbbrk;");
        put("\\u007D", "&rbrace;");
        put("\\u005D", "&rbrack;");
        put("\\u298C", "&rbrke;");
        put("\\u298E", "&rbrksld;");
        put("\\u2990", "&rbrkslu;");
        put("\\u0159", "&rcaron;");
        put("\\u0157", "&rcedil;");
        put("\\u0440", "&rcy;");
        put("\\u2937", "&rdca;");
        put("\\u2969", "&rdldhar;");
        put("\\u21B3", "&rdsh;");
        put("\\u25AD", "&rect;");
        put("\\u297D", "&rfisht;");
        put("\\uD835\\uDD2F", "&rfr;");
        put("\\u296C", "&rharul;");
        put("\\u03C1", "&rho;");
        put("\\u03F1", "&rhov;");
        put("\\u21C9", "&rightrightarrows;");
        put("\\u22CC", "&rightthreetimes;");
        put("\\u02DA", "&ring;");
        put("\\u200F", "&rlm;");
        put("\\u23B1", "&rmoust;");
        put("\\u2AEE", "&rnmid;");
        put("\\u27ED", "&roang;");
        put("\\u21FE", "&roarr;");
        put("\\u2986", "&ropar;");
        put("\\uD835\\uDD63", "&ropf;");
        put("\\u2A2E", "&roplus;");
        put("\\u27FC", "&longmapsto;");
        put("\\u2A35", "&rotimes;");
        put("\\u0029", "&rpar;");
        put("\\u2994", "&rpargt;");
        put("\\u2A12", "&rppolint;");
        put("\\u203A", "&rsaquo;");
        put("\\uD835\\uDCC7", "&rscr;");
        put("\\u22CA", "&rtimes;");
        put("\\u25B9", "&rtri;");
        put("\\u29CE", "&rtriltri;");
        put("\\u2968", "&ruluhar;");
        put("\\u211E", "&rx;");
        put("\\u015B", "&sacute;");
        put("\\u2AB4", "&scE;");
        put("\\u2AB8", "&scap;");
        put("\\u0161", "&scaron;");
        put("\\u015F", "&scedil;");
        put("\\u015D", "&scirc;");
        put("\\u2AB6", "&scnE;");
        put("\\u2ABA", "&scnap;");
        put("\\u22E9", "&scnsim;");
        put("\\u2A13", "&scpolint;");
        put("\\u0441", "&scy;");
        put("\\u22C5", "&sdot;");
        put("\\u2A66", "&sdote;");
        put("\\u21D8", "&seArr;");
        put("\\u00A7", "&sect;");
        put("\\u003B", "&semi;");
        put("\\u2929", "&seswar;");
        put("\\u2736", "&sext;");
        put("\\uD835\\uDD30", "&sfr;");
        put("\\u266F", "&sharp;");
        put("\\u0449", "&shchcy;");
        put("\\u0448", "&shcy;");
        put("\\u00AD", "&shy;");
        put("\\u03C3", "&sigma;");
        put("\\u03C2", "&sigmaf;");
        put("\\u2A6A", "&simdot;");
        put("\\u2A9E", "&simg;");
        put("\\u2AA0", "&simgE;");
        put("\\u2A9D", "&siml;");
        put("\\u2A9F", "&simlE;");
        put("\\u2246", "&simne;");
        put("\\u2A24", "&simplus;");
        put("\\u2972", "&simrarr;");
        put("\\u2A33", "&smashp;");
        put("\\u29E4", "&smeparsl;");
        put("\\u2323", "&smile;");
        put("\\u2AAA", "&smt;");
        put("\\u2AAC", "&smte;");
        put("\\u2AAC\\uFE00", "&smtes;");
        put("\\u044C", "&softcy;");
        put("\\u002F", "&sol;");
        put("\\u29C4", "&solb;");
        put("\\u233F", "&solbar;");
        put("\\uD835\\uDD64", "&sopf;");
        put("\\u2660", "&spades;");
        put("\\u2293\\uFE00", "&sqcaps;");
        put("\\u2294\\uFE00", "&sqcups;");
        put("\\uD835\\uDCC8", "&sscr;");
        put("\\u2606", "&star;");
        put("\\u03D5", "&straightphi;");
        put("\\u2282", "&sub;");
        put("\\u2AC5", "&subE;");
        put("\\u2ABD", "&subdot;");
        put("\\u2AC3", "&subedot;");
        put("\\u2AC1", "&submult;");
        put("\\u2ACB", "&subnE;");
        put("\\u228A", "&subne;");
        put("\\u2ABF", "&subplus;");
        put("\\u2979", "&subrarr;");
        put("\\u2AC7", "&subsim;");
        put("\\u2AD5", "&subsub;");
        put("\\u2AD3", "&subsup;");
        put("\\u266A", "&sung;");
        put("\\u00B9", "&sup1;");
        put("\\u00B2", "&sup2;");
        put("\\u00B3", "&sup3;");
        put("\\u2AC6", "&supE;");
        put("\\u2ABE", "&supdot;");
        put("\\u2AD8", "&supdsub;");
        put("\\u2AC4", "&supedot;");
        put("\\u27C9", "&suphsol;");
        put("\\u2AD7", "&suphsub;");
        put("\\u297B", "&suplarr;");
        put("\\u2AC2", "&supmult;");
        put("\\u2ACC", "&supnE;");
        put("\\u228B", "&supne;");
        put("\\u2AC0", "&supplus;");
        put("\\u2AC8", "&supsim;");
        put("\\u2AD4", "&supsub;");
        put("\\u2AD6", "&supsup;");
        put("\\u21D9", "&swArr;");
        put("\\u292A", "&swnwar;");
        put("\\u00DF", "&szlig;");
        put("\\u2316", "&target;");
        put("\\u03C4", "&tau;");
        put("\\u0165", "&tcaron;");
        put("\\u0163", "&tcedil;");
        put("\\u0442", "&tcy;");
        put("\\u2315", "&telrec;");
        put("\\uD835\\uDD31", "&tfr;");
        put("\\u03B8", "&theta;");
        put("\\u03D1", "&thetasym;");
        put("\\u00FE", "&thorn;");
        put("\\u00D7", "&times;");
        put("\\u2A31", "&timesbar;");
        put("\\u2A30", "&timesd;");
        put("\\u2336", "&topbot;");
        put("\\u2AF1", "&topcir;");
        put("\\uD835\\uDD65", "&topf;");
        put("\\u2ADA", "&topfork;");
        put("\\u2034", "&tprime;");
        put("\\u25B5", "&triangle;");
        put("\\u25BF", "&triangledown;");
        put("\\u225C", "&triangleq;");
        put("\\u25EC", "&tridot;");
        put("\\u2A3A", "&triminus;");
        put("\\u2A39", "&triplus;");
        put("\\u29CD", "&trisb;");
        put("\\u2A3B", "&tritime;");
        put("\\u23E2", "&trpezium;");
        put("\\uD835\\uDCC9", "&tscr;");
        put("\\u0446", "&tscy;");
        put("\\u045B", "&tshcy;");
        put("\\u0167", "&tstrok;");
        put("\\u2963", "&uHar;");
        put("\\u00FA", "&uacute;");
        put("\\u045E", "&ubrcy;");
        put("\\u016D", "&ubreve;");
        put("\\u00FB", "&ucirc;");
        put("\\u0443", "&ucy;");
        put("\\u0171", "&udblac;");
        put("\\u297E", "&ufisht;");
        put("\\uD835\\uDD32", "&ufr;");
        put("\\u00F9", "&ugrave;");
        put("\\u2580", "&uhblk;");
        put("\\u231C", "&ulcorn;");
        put("\\u230F", "&ulcrop;");
        put("\\u25F8", "&ultri;");
        put("\\u016B", "&umacr;");
        put("\\u0173", "&uogon;");
        put("\\uD835\\uDD66", "&uopf;");
        put("\\u03C5", "&upsi;");
        put("\\u21C8", "&upuparrows;");
        put("\\u231D", "&urcorn;");
        put("\\u230E", "&urcrop;");
        put("\\u016F", "&uring;");
        put("\\u25F9", "&urtri;");
        put("\\uD835\\uDCCA", "&uscr;");
        put("\\u22F0", "&utdot;");
        put("\\u0169", "&utilde;");
        put("\\u00FC", "&uuml;");
        put("\\u29A7", "&uwangle;");
        put("\\u2AE8", "&vBar;");
        put("\\u2AE9", "&vBarv;");
        put("\\u299C", "&vangrt;");
        put("\\u2205", "&varnothing;");
        put("\\u228A\\uFE00", "&varsubsetneq;");
        put("\\u2ACB\\uFE00", "&varsubsetneqq;");
        put("\\u228B\\uFE00", "&varsupsetneq;");
        put("\\u2ACC\\uFE00", "&varsupsetneqq;");
        put("\\u0432", "&vcy;");
        put("\\u22BB", "&veebar;");
        put("\\u225A", "&veeeq;");
        put("\\u22EE", "&vellip;");
        put("\\uD835\\uDD33", "&vfr;");
        put("\\uD835\\uDD67", "&vopf;");
        put("\\uD835\\uDCCB", "&vscr;");
        put("\\u299A", "&vzigzag;");
        put("\\u0175", "&wcirc;");
        put("\\u2A5F", "&wedbar;");
        put("\\u2259", "&wedgeq;");
        put("\\u2118", "&weierp;");
        put("\\uD835\\uDD34", "&wfr;");
        put("\\uD835\\uDD68", "&wopf;");
        put("\\uD835\\uDCCC", "&wscr;");
        put("\\uD835\\uDD35", "&xfr;");
        put("\\u03BE", "&xi;");
        put("\\u22FB", "&xnis;");
        put("\\uD835\\uDD69", "&xopf;");
        put("\\uD835\\uDCCD", "&xscr;");
        put("\\u00FD", "&yacute;");
        put("\\u044F", "&yacy;");
        put("\\u0177", "&ycirc;");
        put("\\u044B", "&ycy;");
        put("\\u00A5", "&yen;");
        put("\\uD835\\uDD36", "&yfr;");
        put("\\u0457", "&yicy;");
        put("\\uD835\\uDD6A", "&yopf;");
        put("\\uD835\\uDCCE", "&yscr;");
        put("\\u044E", "&yucy;");
        put("\\u00FF", "&yuml;");
        put("\\u017A", "&zacute;");
        put("\\u017E", "&zcaron;");
        put("\\u0437", "&zcy;");
        put("\\u017C", "&zdot;");
        put("\\u03B6", "&zeta;");
        put("\\uD835\\uDD37", "&zfr;");
        put("\\u0436", "&zhcy;");
        put("\\u21DD", "&zigrarr;");
        put("\\uD835\\uDD6B", "&zopf;");
        put("\\uD835\\uDCCF", "&zscr;");
        put("\\u200D", "&zwj;");
        put("\\u200C", "&zwnj;");

    }};


}
